package com.artfess.cqxy.ledger.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author 黎沐华
 * @date 2022/5/24 17:07
 */
@Data
public class BiddingLedgerVo {
    // 项目表
    @ApiModelProperty("年份")
    private String year;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID")
    private String projectId;

    @TableField("PROJECT_MANAGER_")
    @ApiModelProperty(value = "项目负责人")
    private String projectManager;

    @TableField("PROJECT_NAME_")
    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @TableField("COMMENCEMENT_TIME_")
    @ApiModelProperty(value = "开工时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commencementTime;

    @TableField("COMPLETION_TIME_")
    @ApiModelProperty(value = "完工时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionTime;

    // 概算表
    @TableField("PRELIMINARY_ESTIMATE_")
    @ApiModelProperty(value = "项目概算")
    private String preliminaryEstimate;

    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "招标名称")
    private String documentNumber;

    @TableField("BIDDING_CHARGE_TYPE_")
    @ApiModelProperty(value = "招标方式，（使用字典：1：公开招标，2：直接委托，3：走流程，4其他）")
    private String biddingChargeType;

    @TableField("BID_AMOUNT_EXAMINE_")
    @ApiModelProperty(value = "招标限价（万元）")
    private String bidAmountExamine;

    @TableField("BID_WINNER_")
    @ApiModelProperty(value = "中标单位")
    private String bidWinner;

    @TableField("BID_WINNER_AGENT_PHONE_")
    @ApiModelProperty(value = "中标人资质等级")
    private String bidWinnerPhone;

    @ApiModelProperty(value = "中标单位代理人姓名、电话")
    private String bidWinnerAgencyNamePhone;

    @ApiModelProperty(value = "实际付款方式及情况")
    private String actualPaymentMethodSituation;

    @ApiModelProperty(value = "审计情况及存在问题")
    private String auditSituationAndProblems;

    @ApiModelProperty(value = "实际结算金额（万元）")
    private String actualSettlementMoney;

    @TableField("BID_AMOUNT_")
    @ApiModelProperty(value = "中标总金额（单位：万元）")
    private String bidAmount;

    @TableField("ACTUAL_SETTLEMENT_AMOUNT_")
    @ApiModelProperty(value = "安全文明施工费（单位：万元）")
    private String actualSettlementAmount;

    @TableField("BIDDING_AGENCY_")
    @ApiModelProperty(value = "招标代理机构")
    private String biddingAgency;

    @TableField("RESPONSIBLE_UNIT_")
    @ApiModelProperty(value = "招标范围")
    private String responsibleUnit;

    @TableField("RESPONSIBLE_PERSON_")
    @ApiModelProperty(value = "招标企业数量")
    private Integer responsiblePerson;

    @TableField("PROJECT_BUDGET_")
    @ApiModelProperty(value = "投标保证金金额（万元）")
    private String projectBudget;

    @TableField("IMPLEMENTATION_PERSONNEL_PHONE_")
    @ApiModelProperty(value = "投标保证金支付方式（使用字典，1：现金，2：保函）")
    private String implementationPersonnelPhone;

    @TableField("IMPLEMENTATION_PERSONNEL_PHONE_URL_")
    @ApiModelProperty(value = "保函附件存储URL）")
    private String implementationPersonnelPhoneUrl;

    @TableField("IMPLEMENTATION_PERSONNEL_NAME_")
    @ApiModelProperty(value = "评标方法（使用字典，1：经评审的最低中标法，2：综合评标法）")
    private String implementationPersonnelName;

    @TableField("COMMENCEMENT_DATE_")
    @ApiModelProperty(value = "开标日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commencementDate;

    @TableField("FUNDS_SOURCE_")
    @ApiModelProperty(value = "是否违法违规（使用字典：1：否，0：是")
    private String fundsSource;

    @TableField("FUNDS_SOURCE_URL_")
    @ApiModelProperty(value = "违法违规附件URL")
    private String fundsSourceUrl;

    @TableField("HAS_COMPLAINT_")
    @ApiModelProperty(value = "有无投诉，（0：有，1：无）")
    private String hasComplaint;

    @TableField("HAS_COMPLAINT_URL_")
    @ApiModelProperty(value = "投诉文件url")
    private String hasComplaintUrl;

    @TableField("COMPLAINT_SITUATION_")
    @ApiModelProperty(value = "投诉情况")
    private String complaintSituation;

    @TableField("ACTUAL_PAYMENT_METHOD_")
    @ApiModelProperty(value = "项目概况")
    private String actualPaymentMethod;

    @TableField("CONTRACT_PAYMENT_METHOD_")
    @ApiModelProperty(value = "投资性质(使用字典，1：国有，2：非国有)")
    private String contractPaymentMethod;

    @TableField("BID_WINNER_AGENT_NAME_")
    @ApiModelProperty(value = "中标单位负责人(实施施工人或承建人、电话)")
    private String bidWinnerAgentName;

    @ApiModelProperty(value = "中标通知书签发日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionDate;

    @TableField("PAYEE_NAME_ACCOUNT_")
    @ApiModelProperty(value = "收款人及账号")
    private String payeeNameAccount;

    @TableField("SOURCE_FUNDS_")
    @ApiModelProperty(value = "资金来源，（默认值：业主自筹）")
    private String sourceFunds;

    @TableField("PAYEE_PHONE_")
    @ApiModelProperty(value = "中标单位负责人电话")
    private String payeePhone;

     //合同
    @TableField("PAYEE_ACCOUNT_PHONE_")
    @ApiModelProperty(value = "收款人及账号、电话")
    private String payeeAccountPhone;

    @TableField("TREATY_CONTENTS_")
    @ApiModelProperty(value = "合同约定付款方式")
    private String payType;

    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    // 合同表
    @TableField("TREATY_CONTENTS_")
    @ApiModelProperty(value = "合同约定付款方式")
    private String treatyContents;

    @TableField("MOLD_")
    @ApiModelProperty(value = "合同分类，（使用字典，1：G-工程类，2：J-技术类合同，3：F-服务类合同，4：C-采购类合同，5：P-配套类合同，6：其他）")
    private String mold;

}
