package com.artfess.cqxy.documentLibrary.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.projectManagement.model.DirectoryManagement;
import com.baomidou.mybatisplus.extension.service.IService;
import com.artfess.cqxy.documentLibrary.model.FileLibraryType;

import java.util.List;

/**
 * 文件库-分类表(FileLibraryType)表服务接口
 *
 * @author 黎沐华
 * @since 2022-04-02 09:21:22
 */
public interface FileLibraryTypeManager extends BaseManager<FileLibraryType> {
    /**
     * 更改父节点是否有子节点的状态
     * @param typeID typeID
     * @param flag 更改标志 true 有 false 无
     */
    void changeHasChildNode(String typeID, boolean flag);

    /**
     * 是否有子节点
     * @param id typeID
     * @return 是 / 否
     */
    boolean checkHasChild(String id);

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<FileLibraryType> queryChildNodeByPage(QueryFilter<FileLibraryType> queryFilter);

    /**
     * 根据父节点ID获取其子节点数据
     * @param pCode 父节点ID
     * @return 树状数据
     */
    List<FileLibraryType> getByParentCode(String pCode);

    /**
     * 是否存在键值
     *
     * @param id 主键
     * @param code      code类型
     * @return
     */
    boolean isKeyExist(String id, String code);
}

