package com.artfess.workflow.bpmModel.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.artfess.workflow.bpmModel.model.BpmOftenFlowUser;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *  通用流程授权对象表 接口
 *
 * @company 广州宏天软件股份有限公司
 * @author 超级管理员
 * @since 2020-11-04
 */
public interface BpmOftenFlowUserDao extends BaseMapper<BpmOftenFlowUser> {

    /**
     * 根据常用流程ID获取授权信息
     * @param oftenFlowId
     * @return
     */
    List<BpmOftenFlowUser> getBpmOftenFlowUsers(@Param("oftenFlowId")String oftenFlowId);

    /**
     * 根据常用流程ID删除授权信息
     * @param oftenFlowId
     */
    void removeByOftenFlowId(@Param("oftenFlowId")String oftenFlowId);
}
