package com.artfess.cqxy.projectManagement.dao;

import com.artfess.cqxy.projectManagement.model.ProjectStart;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * (ProjectStart)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-06-01 16:47:14
 */
public interface ProjectStartDao extends BaseMapper<ProjectStart> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    ProjectStart getById(@Param("id") String id);

    IPage<ProjectStart> queryAllByPage(IPage<ProjectStart> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ProjectStart> convert2Wrapper);


}

