package com.artfess.cqxy.processManagermant.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.processManagermant.dao.ProgressManageEpidemicControlDao;
import com.artfess.cqxy.processManagermant.manager.ProgressManageEpidemicControlManager;
import com.artfess.cqxy.processManagermant.model.ProgressManageEpidemicControl;
import com.artfess.cqxy.projectApproval.model.DecisionAnnualPlan;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 过程管理 - 进度管理 - 疫情防控(BizProgressManageEpidemicControl)表服务实现类
 *
 * @author 黎沐华
 * @since 2022-03-22 11:31:40
 */
@Service
public class ProgressManageEpidemicControlManagerImpl extends BaseManagerImpl<ProgressManageEpidemicControlDao, ProgressManageEpidemicControl> implements ProgressManageEpidemicControlManager {

    @Autowired
    private AccessoryManager accessoryManager;

    @Autowired
    private SystemConfigFeignService scfs;

    @Autowired
    private SysDictionaryManager sdm;

    @Autowired
    private ProjectManagementManager pmm;

    @Autowired
    private BaseContext baseContext;

    @Autowired
    private GlobalRetrievalManager grm;

    @Override
    public boolean saveOrUpdate(ProgressManageEpidemicControl entity) {
        boolean save = StringUtils.isEmpty(entity.getId());
//        String code = scfs.getNextIdByAlias("yqfk_yjbh");
//        entity.setEpidemicControlCode(code.substring(StringUtils.lastOrdinalIndexOf(code, "\"", 2) + 1, code.lastIndexOf("\"")));
//        entity.setEpidemicControlDate(null == entity.getEpidemicControlDate() ? new Date() : entity.getEpidemicControlDate());
        boolean savedMain = super.saveOrUpdate(entity);
        // 处理附件信息
        List<Accessory> flag = entity.getAccessoryInfo();//处理空指针
        List<Accessory> accessoryList = null == flag ? new ArrayList<>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.nine.getCode());
            ele.setGroup("ProgressManageEpidemicControl");
            ele.setNode(ProjectStatusEnum.nine.getCode());
            ele.setCreateBy(baseContext.getCurrentUserId());
            ele.setCreateName(baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        // 先清空该ID下的所有附件信息再添加
        accessoryManager.removeBySourceId(entity.getId());
        // 如果没有附件则返回true，不进入添加
        boolean saveAcc = accessoryList.size() == 0 || accessoryManager.saveAccess(accessoryList);
        //更新项目状态
        pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.eleven.getCode()));
        // 同步到检索表
        GlobalRetrieval globalRetrieval= grm.getByBizId(entity.getId());
        handleRetrieval(save|| BeanUtils.isEmpty(globalRetrieval) ?new GlobalRetrieval():globalRetrieval,entity);

        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, ProgressManageEpidemicControl entity){
        ProjectManagement projectManagement = pmm.getById(entity.getProjectId());
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.twentyTwo.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.twentyTwo.getName());
        globalRetrieval.setBizTableName(FunctionEnum.twentyTwo.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.twentyTwo.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.twentyTwo.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.twentyTwo.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.twentyTwo.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.twentyTwo.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getEpidemicControlCode());
        globalRetrieval.setSearchTitle(entity.getEpidemicControlCode()+"_"+entity.getEpidemicControlUser()+"_"+entity.getProgressDescription()+"_"+
                entity.getEpidemicControlView()+"_"+entity.getRemarks());
        grm.saveOrUpdate(globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        // 同步删除检索表中的信息
        for(String ele:ids){
            grm.remove(1,ele);
        }
        return removeByIds(ids);
    }

    @Override
    public ProgressManageEpidemicControl getById(String id) {
        ProgressManageEpidemicControl result = baseMapper.getById(id);
        result.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<ProgressManageEpidemicControl> queryAllByPage(QueryFilter<ProgressManageEpidemicControl> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bpmec", "pm");
        IPage<ProgressManageEpidemicControl> result =
                baseMapper.queryAllByPage(
                        convert2IPage(queryFilter.getPageBean()),
                        convert2Wrapper(queryFilter, currentModelClass()));
        // 附件信息处理
        List<ProgressManageEpidemicControl> records = result.getRecords();
        for (ProgressManageEpidemicControl ele : records) {
            ele.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(ele.getId()));
        }

        return new PageList<>(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull(projectId, "项目ID不能为空");
        try {
            //1、获取文件输入流
            InputStream inputStream = file.getInputStream();
            //2、获取Excel工作簿对象
            Workbook workbook = WorkbookFactory.create(inputStream);
            //3、得到Excel工作表对象
            Sheet sheetAt = workbook.getSheetAt(0);
            //4、循环读取表格数据
            for (Row row : sheetAt) {
                //首行（表头）不读取
                if (row.getRowNum() == 0) {
                    continue;
                }
                //读取当前行中单元格数据并赋值到对象，索引从0开始
                ProgressManageEpidemicControl data = new ProgressManageEpidemicControl();
                //处理单元格数据可能为空 getCell将会抛出空指针的问题
//                String code = scfs.getNextIdByAlias("yqfk_yjbh");
                data.setProgressDescription(null == row.getCell(0) ? row.createCell(0).getStringCellValue() : row.getCell(0).getStringCellValue());
                data.setEpidemicControlView(null == row.getCell(1) ? row.createCell(1).getStringCellValue() : row.getCell(1).getStringCellValue());
                Date date = null == row.getCell(2) ? row.createCell(2).getDateCellValue() : row.getCell(2).getDateCellValue();
                data.setEpidemicControlDate(null==date?new Date():date);
                data.setEpidemicControlUser(null == row.getCell(3) ? row.createCell(3).getStringCellValue() : row.getCell(3).getStringCellValue());
                data.setRemarks(null == row.getCell(4) ? row.createCell(4).getStringCellValue() : row.getCell(4).getStringCellValue());
                data.setEpidemicControlCode(null == row.getCell(5) ? row.createCell(5).getStringCellValue() : row.getCell(5).getStringCellValue());
                data.setProjectId(projectId);
                baseMapper.insert(data);
                // 同步到检索表
                handleRetrieval(new GlobalRetrieval(),data);
            }
            //5、关闭流
            workbook.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<ProgressManageEpidemicControl> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "过程管理-进度管理-疫情防控-导出结果";

        // 获取数据
        BizUtils.handleFilter(queryFilter, "bpmec", "pm");
        List<ProgressManageEpidemicControl> data = baseMapper.queryAllByPage(
                        convert2IPage(new PageBean(0, -1, false)),
                        convert2Wrapper(queryFilter, currentModelClass())).
                getRecords();
        if(null==data||data.size()==0){
            throw new RuntimeException("没有要导出的的数据！");
        }

        // EasyPoi 导出参数、样式、表格格式设置
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName += ".xlsx";

        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, ProgressManageEpidemicControl.class, data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper<ProgressManageEpidemicControl> wrapper = new UpdateWrapper<ProgressManageEpidemicControl>()
                .set(StringUtils.isNotBlank(newProjectId), "PROJECT_ID_", newProjectId)
                .in("PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update(wrapper);
    }
}

