package com.artfess.cqxy.feasiblePlan.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.feasiblePlan.dao.FeasibilityStudyReplyDao;
import com.artfess.cqxy.feasiblePlan.manager.FeasibilityStudyReplyManager;
import com.artfess.cqxy.feasiblePlan.model.FeasibilityStudyReply;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 可研批复表(BizFeasibilityStudyReply)表服务实现类
 * @author 黎沐华
 * @since 2022-02-14 16:09:41
 */
@Service
public class FeasibilityStudyReplyManagerImpl extends BaseManagerImpl<FeasibilityStudyReplyDao, FeasibilityStudyReply> implements FeasibilityStudyReplyManager {

    @Autowired
    private AccessoryManager accessoryManager;

    @Autowired
    private BaseContext baseContext;

    @Autowired
    private ProjectManagementManager pmm;

    @Autowired
    private GlobalRetrievalManager grm;

    @Override
    public boolean saveOrUpdate(FeasibilityStudyReply entity) {
        boolean save = StringUtils.isEmpty(entity.getId());
        boolean savedMain = super.saveOrUpdate(entity);
        // 处理附件信息
        List<Accessory> flag = entity.getAccessoryInfo();//处理空指针
        List<Accessory> accessoryList = null == flag ? new ArrayList<>():flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.three.getCode());
            ele.setGroup("FeasibilityStudyReply");
            ele.setNode(ProjectStatusEnum.three.getCode());
            ele.setCreateBy(baseContext.getCurrentUserId());
            ele.setCreateName(baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        // 先清空该ID下的所有附件信息再添加
        accessoryManager.removeBySourceId(entity.getId());
        // 如果没有附件则返回true，不进入添加
        boolean saveAcc = accessoryList.size() == 0 || accessoryManager.saveAccess(accessoryList);
        //更新项目状态
        pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.three.getCode()));
        // 同步到检索表
        GlobalRetrieval globalRetrieval= grm.getByBizId(entity.getId());
        handleRetrieval(save || BeanUtils.isEmpty(globalRetrieval) ?new GlobalRetrieval():globalRetrieval,entity);

        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval,FeasibilityStudyReply entity){
        ProjectManagement projectManagement = pmm.getById(entity.getProjectId());
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.four.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.four.getName());
        globalRetrieval.setBizTableName(FunctionEnum.four.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.four.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.four.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.four.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.four.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.four.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getDocumentNumber());
        globalRetrieval.setDocumentUnit(entity.getEstablishmentApprovalUnit());
        globalRetrieval.setSearchTitle(entity.getDocumentNumber()+"_"+entity.getEstablishmentApprovalUnit()+"_"+entity.getEstablishmentScale()+"_"+
                entity.getEstablishmentRemarks());
        grm.saveOrUpdate(globalRetrieval);
    }

    @Override
    public FeasibilityStudyReply getById(String id) {
        FeasibilityStudyReply result = baseMapper.getById(id);
        result.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        // 同步删除检索表中的信息
        for(String ele:ids){
            grm.remove(1,ele);
        }
        return removeByIds(ids);
    }

    @Override
    public PageList<FeasibilityStudyReply> queryAllByPage(QueryFilter<FeasibilityStudyReply> queryFilter) {
        BizUtils.handleFilter(queryFilter,"bfsr" ,"pm");
        IPage<FeasibilityStudyReply> result =
                baseMapper.queryAllByPage(
                        convert2IPage(queryFilter.getPageBean()),
                        convert2Wrapper(queryFilter, currentModelClass()));
        // 附件信息处理
        List<FeasibilityStudyReply> records = result.getRecords();
        for (FeasibilityStudyReply ele: records ) {
            ele.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(ele.getId()));
        }

        return new PageList<>(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull(projectId,"项目ID不能为空");
        try(InputStream inputStream = file.getInputStream();) {
            // 获取数据
            List<FeasibilityStudyReply> data = ExcelImportUtil.importExcel(inputStream,FeasibilityStudyReply.class,new ImportParams());
            for(FeasibilityStudyReply ele:data){
                ele.setProjectId(projectId);
                BigDecimal engineeringCost = StringUtils.isBlank(ele.getEngineeringCost())?new BigDecimal(0):new BigDecimal(ele.getEngineeringCost());
                BigDecimal reserveCost = StringUtils.isBlank(ele.getReserveCost())?new BigDecimal(0):new BigDecimal(ele.getReserveCost());
                BigDecimal landCost = StringUtils.isBlank(ele.getLandCost())?new BigDecimal(0):new BigDecimal(ele.getLandCost());
                BigDecimal engineeringOtherCost = StringUtils.isBlank(ele.getEngineeringCost())?new BigDecimal(0):new BigDecimal(ele.getEngineeringCost());
                ele.setEstablishmentInvestmentAmount(engineeringCost.add(reserveCost).add(landCost).add(engineeringOtherCost).toPlainString());
                // 保存数据 & 同步到检索表
                save(ele);
                handleRetrieval(new GlobalRetrieval(),ele);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDataToExcel(QueryFilter<FeasibilityStudyReply> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "可研批复-导出结果";

        // 获取数据
        BizUtils.handleFilter(queryFilter, "bfsr", "pm");
        List<FeasibilityStudyReply> data = baseMapper.queryAllByPage(
                        convert2IPage(new PageBean(0,-1,false)),
                        convert2Wrapper(queryFilter, currentModelClass())).
                getRecords();
        if(null==data||data.size()==0){
            throw new RuntimeException("没有要导出的的数据！");
        }

        // EasyPoi 导出参数、样式、表格格式设置
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName += ".xlsx";

        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, FeasibilityStudyReply.class, data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper<FeasibilityStudyReply> wrapper = new UpdateWrapper<FeasibilityStudyReply>()
                .set(StringUtils.isNotBlank(newProjectId), "PROJECT_ID_", newProjectId)
                .in("PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update(wrapper);
    }

    @Override
    public FeasibilityStudyReply getByProjectId(String projectId) {

        return this.baseMapper.getByProjectId(projectId);
    }
}

