package com.artfess.cqxy.designEstimate.dao;

import com.artfess.cqxy.designEstimate.model.PreliminaryDesign;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 设计概算 - 初步设计表(BizPreliminaryDesign)表数据库访问层
 * @author 黎沐华
 * @since 2022-02-15 16:49:24
 */
public interface PreliminaryDesignDao extends BaseMapper<PreliminaryDesign> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    PreliminaryDesign getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<PreliminaryDesign> queryAllByPage(IPage<PreliminaryDesign> convert2IPage, @Param(Constants.WRAPPER) Wrapper<PreliminaryDesign> convert2Wrapper);

}

