/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.ledger.manager.impl;

import cn.hutool.json.JSONObject;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.contract.manager.AdministrativePaymentManager;
import com.artfess.cqxy.contract.manager.ContractManager;
import com.artfess.cqxy.contract.model.AdministrativePayment;
import com.artfess.cqxy.designEstimate.manager.EstimateManager;
import com.artfess.cqxy.designEstimate.model.Estimate;
import com.artfess.cqxy.feasiblePlan.manager.FeasibilityStudyReplyManager;
import com.artfess.cqxy.feasiblePlan.manager.PlanningUseLandManager;
import com.artfess.cqxy.feasiblePlan.model.FeasibilityStudyReply;
import com.artfess.cqxy.ledger.manager.InvestmentLedgerManager;
import com.artfess.cqxy.ledger.vo.InvestmentLedgerVo;
import com.artfess.cqxy.ledger.vo.InvestmentMonthCountVo;
import com.artfess.cqxy.processManagermant.manager.ProgressManageManager;
import com.artfess.cqxy.processManagermant.manager.ProgressManageReportManager;
import com.artfess.cqxy.processManagermant.model.ProgressManage;
import com.artfess.cqxy.processManagermant.model.ProgressManageReport;
import com.artfess.cqxy.projectApproval.manager.ProjectEstablishmentManager;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class InvestmentLedgerManagerImpl
implements InvestmentLedgerManager {
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private ProjectManagementManager pmm;
    @Autowired
    private EstimateManager em;
    @Autowired
    private ProgressManageReportManager pmrm;
    @Autowired
    private ProgressManageManager progressManager;
    @Autowired
    private ContractManager contractManager;
    @Autowired
    private ProjectEstablishmentManager pem;
    @Autowired
    private FeasibilityStudyReplyManager feasibilityStudyReplyManager;
    @Autowired
    private AdministrativePaymentManager administrativePaymentManager;
    @Autowired
    private PlanningUseLandManager planningUseLandManager;

    @Override
    public Map<String, Object> queryByPage(QueryFilter<ProjectManagement> queryFilter) {
        queryFilter.withSorter(new FieldSort("PROJECT_TYPE_", Direction.ASC));
        queryFilter.addFilter("PARENT_ID_", (Object)"root", QueryOP.EQUAL);
        PageList<ProjectManagement> project = this.pmm.queryAllByPage(queryFilter);
        List projectManagementList = null == project ? new ArrayList() : project.getRows();
        HashMap<String, Object> result = new HashMap<String, Object>();
        List pStatus = this.sdm.queryDictListItemsByCode("xmgl-xmzt");
        ArrayList<InvestmentLedgerVo> data = new ArrayList<InvestmentLedgerVo>();
        List administrativePaymentList = this.administrativePaymentManager.list();
        for (ProjectManagement ele : projectManagementList) {
            BigDecimal engineeringCost;
            InvestmentLedgerVo temp = new InvestmentLedgerVo();
            temp.setId(ele.getId());
            temp.setProjectName(ele.getProjectName());
            temp.setProjectStatus(BizUtils.getDicValueByCode((List<DictModel>)pStatus, ele.getProjectStatus()));
            temp.setProjectManager(ele.getProjectManager());
            temp.setProjectType(Integer.valueOf(ele.getProjectType()));
            temp.setLandPrice(ele.getLandTotalPrice() == null ? BigDecimal.ZERO.stripTrailingZeros() : ele.getLandTotalPrice().setScale(2, 4).stripTrailingZeros());
            FeasibilityStudyReply feasibilityStudyReply = this.feasibilityStudyReplyManager.getByProjectId(ele.getId());
            Estimate estimate = (Estimate)((Object)this.em.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0")).last("limit 1")));
            if (null != estimate && StringUtils.isNotBlank((CharSequence)estimate.getDesignSpeed())) {
                if (null == temp.getLandPrice() || temp.getLandPrice().compareTo(BigDecimal.ZERO) < 1) {
                    temp.setLandPrice(new BigDecimal(estimate.getDesignSpeed()).setScale(2, 4).stripTrailingZeros());
                }
            } else if (null != feasibilityStudyReply && StringUtils.isNotBlank((CharSequence)feasibilityStudyReply.getLandCost()) && (null == temp.getLandPrice() || temp.getLandPrice().compareTo(BigDecimal.ZERO) < 1)) {
                temp.setLandPrice(new BigDecimal(feasibilityStudyReply.getLandCost()).setScale(2, 4).stripTrailingZeros());
            }
            if ((engineeringCost = this.contractManager.queryConstructionAmount2(ele.getId())) != null && engineeringCost.compareTo(BigDecimal.ZERO) > 0) {
                temp.setEngineeringCost(engineeringCost.setScale(2, 4).stripTrailingZeros().toPlainString());
            } else {
                temp.setEngineeringCost("0");
            }
            BigDecimal actualSettlementAmount = this.progressManager.geTamountAppropriatedTotalByProjectIdAndPurpose(ele.getId(), true, "2");
            if (actualSettlementAmount != null && actualSettlementAmount.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal bigDecimal = actualSettlementAmount.divide(new BigDecimal(10000)).stripTrailingZeros().setScale(2, 5);
                temp.setActualSettlementAmount(bigDecimal.toPlainString());
            } else {
                temp.setActualSettlementAmount("0");
            }
            temp.setTotalEstimate(BeanUtils.isEmpty((Object)ele.getProjectMoney()) ? "0" : ele.getProjectMoney().setScale(2, 4).stripTrailingZeros().toPlainString());
            String pemMoney = this.pem.getMoneyByPid(ele.getId());
            BigDecimal tempMoney = new BigDecimal(StringUtils.isNotBlank((CharSequence)pemMoney) ? pemMoney : "0");
            if (StringUtils.isEmpty((CharSequence)temp.getTotalEstimate()) && StringUtils.isNotBlank((CharSequence)pemMoney)) {
                temp.setTotalEstimate(tempMoney.setScale(2, 4).stripTrailingZeros().toPlainString());
            }
            Calendar now = Calendar.getInstance();
            int nowYear = now.get(1);
            BigDecimal estimate1 = this.em.getEstimate(ele.getId(), String.valueOf(nowYear));
            if (BigDecimal.ZERO.compareTo(estimate1) == 0) {
                temp.setCurrentEstimate("0");
            } else {
                temp.setCurrentEstimate(estimate1.divide(new BigDecimal(10000), 2, 4).stripTrailingZeros().toPlainString());
            }
            BigDecimal estimate2 = this.em.getEstimate(ele.getId(), String.valueOf(nowYear - 1));
            if (BigDecimal.ZERO.compareTo(estimate2) == 0) {
                temp.setBeforeEstimate("0");
            } else {
                temp.setBeforeEstimate(estimate2.divide(new BigDecimal(10000), 2, 4).stripTrailingZeros().toPlainString());
            }
            BigDecimal estimate3 = this.em.getEstimate(ele.getId(), "");
            if (BigDecimal.ZERO.compareTo(estimate3) == 0) {
                temp.setCompletedEstimate(BigDecimal.ZERO.add(temp.getLandPrice()).stripTrailingZeros().toPlainString());
            } else {
                temp.setCompletedEstimate(estimate3.divide(new BigDecimal(10000), 2, 4).add(temp.getLandPrice()).stripTrailingZeros().toPlainString());
            }
            BigDecimal twoTypePrice = this.progressManager.getTwoPrice(ele.getId(), "1");
            if (null != twoTypePrice && twoTypePrice.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal bigDecimal = twoTypePrice.divide(new BigDecimal(10000), 2, 4).stripTrailingZeros();
                temp.setTwoTypePrice(bigDecimal);
            } else {
                temp.setTwoTypePrice(BigDecimal.ZERO);
            }
            String year = null;
            try {
                year = BizUtils.getYearByQueryFields(queryFilter.getQuerys());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            QueryWrapper manageReportQueryWrapper = new QueryWrapper();
            ((QueryWrapper)manageReportQueryWrapper.eq((Object)"PROJECT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0");
            manageReportQueryWrapper.between(StringUtils.isNotBlank((CharSequence)year), (Object)"PORT_DATE_", (Object)(year + "-01-01"), (Object)(year + "-12-30"));
            List reportList = this.pmrm.getBaseMapper().selectList((Wrapper)manageReportQueryWrapper);
            List<Object> reports = null == reportList ? new ArrayList() : this.mergeList(reportList);
            BigDecimal currentTotal = new BigDecimal("0");
            ArrayList<InvestmentMonthCountVo> monthCountVos = new ArrayList<InvestmentMonthCountVo>();
            for (ProgressManageReport progressManageReport : reports) {
                InvestmentMonthCountVo monthCountVo = new InvestmentMonthCountVo();
                monthCountVo.setMonth(progressManageReport.getPortDate().getMonth());
                if (null != progressManageReport.getProgressDescription() && progressManageReport.getProgressDescription().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal bigDecimal = progressManageReport.getProgressDescription().divide(new BigDecimal(10000)).setScale(2, 5).stripTrailingZeros();
                    monthCountVo.setCurrentInvestment(bigDecimal);
                } else {
                    monthCountVo.setCurrentInvestment(BigDecimal.ZERO);
                }
                String imageProgress = progressManageReport.getWeeklyMouthlyWork();
                monthCountVo.setProgress(imageProgress);
                if (null != progressManageReport.getProjectOvervie()) {
                    BigDecimal bigDecimal = progressManageReport.getProjectOvervie().divide(new BigDecimal(10000)).stripTrailingZeros().setScale(2, 5).stripTrailingZeros();
                    monthCountVo.setTotalInvestment(bigDecimal);
                }
                monthCountVos.add(monthCountVo);
            }
            temp.setMonthCount(monthCountVos);
            BigDecimal payAnoumt = new BigDecimal(0);
            for (AdministrativePayment pay : administrativePaymentList) {
                if (!ele.getId().equals(pay.getProjectId())) continue;
                payAnoumt = payAnoumt.add(pay.getPaysValue());
            }
            temp.setAdminPaymentAmount(payAnoumt);
            data.add(temp);
        }
        result.put("data", data);
        result.put("total", project.getTotal());
        result.put("page", project.getPage());
        result.put("pageSize", project.getPageSize());
        return result;
    }

    private List<ProgressManageReport> mergeList(List<ProgressManageReport> list) {
        HashMap<String, ProgressManageReport> map = new HashMap<String, ProgressManageReport>();
        for (ProgressManageReport ele : list) {
            String key = String.valueOf(null == ele.getPortDate() ? "" : Integer.valueOf(ele.getPortDate().getMonth()));
            if (StringUtils.isEmpty((CharSequence)key)) continue;
            if (map.containsKey(String.valueOf(ele.getPortDate().getMonth()))) {
                BigDecimal mpd = null == ((ProgressManageReport)((Object)map.get(key))).getProgressDescription() ? new BigDecimal("0") : ((ProgressManageReport)((Object)map.get(key))).getProgressDescription();
                BigDecimal epd = null == ele.getProgressDescription() ? new BigDecimal("0") : ele.getProgressDescription();
                ele.setProgressDescription(mpd.add(epd));
                double mip = null == ((ProgressManageReport)((Object)map.get(key))).getImageProgress() ? 0.0 : (StringUtils.isEmpty((CharSequence)((ProgressManageReport)((Object)map.get(key))).getImageProgress()) ? 0.0 : Double.parseDouble(((ProgressManageReport)((Object)map.get(key))).getImageProgress().replace("%", "")));
                double eip = null == ele.getImageProgress() ? 0.0 : Double.parseDouble(ele.getImageProgress().replace("%", ""));
                ele.setImageProgress(String.valueOf(Math.max(mip, eip)));
                ele.setPortDate(ele.getPortDate());
            }
            map.put(key, ele);
        }
        list.clear();
        list.addAll(map.values());
        return list;
    }

    @Override
    public void exportDataToExcel(QueryFilter<ProjectManagement> queryFilter, HttpServletResponse response) throws Exception {
        int i;
        List pType = this.sdm.queryDictListItemsByCode("xmgl-xmlx");
        String type = "";
        List queryFieldList = queryFilter.getQuerys();
        String year = BizUtils.getYearByQueryFields(queryFieldList);
        if (StringUtils.isEmpty((CharSequence)year)) {
            year = String.valueOf(1);
        }
        String fileName = StringUtils.isEmpty((CharSequence)year) ? year + "\u5e74\u5ea6\u9879\u76ee\u6295\u8d44\u8fdb\u5ea6\u53f0\u8d26" : "\u9879\u76ee\u6295\u8d44\u8fdb\u5ea6\u53f0\u8d26";
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        cellStyle.setFont(font);
        HSSFCellStyle dataCellStyle = workbook.createCellStyle();
        HSSFRow titleRow = sheet.createRow(0);
        this.handelCell(workbook, cellStyle, fileName, titleRow.createCell(0), fileName, true);
        ArrayList<String> heards = new ArrayList<String>(50);
        ArrayList<String> subHeards = new ArrayList<String>(50);
        int index = 12;
        int endClo = 49;
        int dataCloIndex = 15;
        for (int i2 = 0; i2 < 12; ++i2) {
            if (i2 == 0) {
                heards.addAll(Arrays.asList("\u5e8f\u53f7", "\u9879\u76ee\u540d\u79f0", "\u4e1a\u4e3b\u5de5\u7a0b\u5e08", "\u5f62\u8c61\u8fdb\u5ea6", "\u603b\u6295\u8d44\uff08\u4e07\u5143\uff09", "\u7d2f\u8ba1\u5b8c\u6210\u603b\u6295\u8d44", Integer.valueOf(year) - 1 + "\u5e74\u6295\u8d44", year + "\u5e74\u6295\u8d44", "\u5efa\u5b89\u8d39\uff08\u4e07\u5143\uff09", "\u571f\u5730\u8d39\u7528\uff08\u4e07\u5143\uff09", "\u5730\u52d8\u3001\u8bbe\u8ba1\u8d39\uff0c\u76d1\u7406\u3001\u68c0\u6d4b\u8d39\u53ca\u4eba\u9632\u914d\u5957\u8d39\u7b49\u4e8c\u7c7b\u8d39\u7528\uff08\u4e07\u5143\uff09", "\u884c\u653f\u7f34\u8d39\u603b\u989d"));
                subHeards.addAll(Arrays.asList(" ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " "));
                heards.addAll(Arrays.asList(i2 + 1 + "\u6708", " ", " "));
            } else if (i2 == 11) {
                heards.addAll(Arrays.asList(i2 + 1 + "\u6708", " ", " ", "\u5e74\u5ea6\u7d2f\u8ba1", " "));
                subHeards.addAll(Arrays.asList("\u672c\u6708\u6295\u8d44\uff08\u4e07\u5143\uff09", "\u672c\u6708\u8fdb\u5ea6", "\u7d2f\u8ba1\u5de5\u7a0b\u6295\u8d44", "\u672c\u6708\u6295\u8d44\uff08\u4e07\u5143\uff09", "\u672c\u6708\u8fdb\u5ea6", "\u7d2f\u8ba1\u5de5\u7a0b\u6295\u8d44", "\u603b\u6295\u8d44\u989d", "\u5907\u6ce8"));
            } else {
                heards.addAll(Arrays.asList(i2 + 1 + "\u6708", " ", " "));
                subHeards.addAll(Arrays.asList("\u672c\u6708\u6295\u8d44\uff08\u4e07\u5143\uff09", "\u672c\u6708\u8fdb\u5ea6", "\u7d2f\u8ba1\u5de5\u7a0b\u6295\u8d44"));
            }
            sheet.addMergedRegion(new CellRangeAddress(2, 2, index, index + 2));
            index += 3;
        }
        HSSFRow titleRow1 = sheet.createRow(1);
        for (int i3 = 0; i3 <= endClo; ++i3) {
            this.handelCell(workbook, dataCellStyle, fileName, titleRow1.createCell(i3), " ", new boolean[0]);
            if (i3 != 0) continue;
            this.handelCell(workbook, dataCellStyle, fileName, titleRow1.createCell(i3), "\u586b\u5199\u90e8\u5ba4\uff1a", new boolean[0]);
        }
        HSSFRow titleRow2 = sheet.createRow(2);
        for (int i4 = 0; i4 < heards.size(); ++i4) {
            this.handelCell(workbook, cellStyle, fileName, titleRow2.createCell(i4), (String)heards.get(i4), new boolean[0]);
        }
        HSSFRow titleRow3 = sheet.createRow(3);
        for (i = 0; i < subHeards.size(); ++i) {
            this.handelCell(workbook, cellStyle, fileName, titleRow3.createCell(i), (String)subHeards.get(i), new boolean[0]);
        }
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, endClo));
        sheet.addMergedRegion(new CellRangeAddress(2, 2, endClo - 1, endClo));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 1));
        for (i = 0; i < 11; ++i) {
            sheet.addMergedRegion(new CellRangeAddress(2, 3, i, i));
        }
        queryFilter.withSorter(new FieldSort("PROJECT_TYPE_"));
        List data = (List)this.queryByPage(queryFilter).get("data");
        if (data.isEmpty()) {
            throw new RuntimeException("\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\uff01");
        }
        int row = 4;
        int currentType = 0;
        int counter = 1;
        DecimalFormat nf = new DecimalFormat(",###.##");
        for (int j = 1; j < ((InvestmentLedgerVo)data.get(0)).getProjectType(); ++j) {
            HSSFRow addRow = sheet.createRow(sheet.getLastRowNum() + 1);
            type = BizUtils.getDicValueByCode((List<DictModel>)pType, j);
            this.handleSubTitle(j, cellStyle, fileName, endClo, type, workbook, addRow);
            ++row;
        }
        for (int i5 = 0; i5 < data.size(); ++i5) {
            HSSFRow listRow = sheet.createRow(row);
            if (currentType != ((InvestmentLedgerVo)data.get(i5)).getProjectType()) {
                currentType = ((InvestmentLedgerVo)data.get(i5)).getProjectType();
                type = BizUtils.getDicValueByCode((List<DictModel>)pType, ((InvestmentLedgerVo)data.get(i5)).getProjectType());
                this.handleSubTitle(currentType, cellStyle, fileName, endClo, type, workbook, listRow);
                counter = 1;
                --i5;
            } else if (((InvestmentLedgerVo)data.get(i5)).getProjectType() - currentType > 1) {
                int j = currentType++;
                while (j < ((InvestmentLedgerVo)data.get(i5)).getProjectType()) {
                    HSSFRow addRow = sheet.createRow(sheet.getLastRowNum() + 1);
                    type = BizUtils.getDicValueByCode((List<DictModel>)pType, ((InvestmentLedgerVo)data.get(0)).getProjectType());
                    this.handleSubTitle(j, cellStyle, fileName, endClo, type, workbook, addRow);
                    j = currentType++;
                }
            } else {
                this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(0), String.valueOf(counter), new boolean[0]);
                this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(1), ((InvestmentLedgerVo)data.get(i5)).getProjectName(), new boolean[0]);
                this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(2), ((InvestmentLedgerVo)data.get(i5)).getProjectManager(), new boolean[0]);
                this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(3), ((InvestmentLedgerVo)data.get(i5)).getProjectStatus(), new boolean[0]);
                this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(4), new BigDecimal(((InvestmentLedgerVo)data.get(i5)).getTotalEstimate()), new boolean[0]);
                this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(5), new BigDecimal(((InvestmentLedgerVo)data.get(i5)).getCompletedEstimate()), new boolean[0]);
                this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(6), new BigDecimal(((InvestmentLedgerVo)data.get(i5)).getBeforeEstimate()), new boolean[0]);
                this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(7), new BigDecimal(((InvestmentLedgerVo)data.get(i5)).getCurrentEstimate()), new boolean[0]);
                this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(8), nf.format(new BigDecimal(((InvestmentLedgerVo)data.get(i5)).getEngineeringCost())), new boolean[0]);
                this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(9), nf.format(((InvestmentLedgerVo)data.get(i5)).getLandPrice()), new boolean[0]);
                this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(10), nf.format(((InvestmentLedgerVo)data.get(i5)).getTwoTypePrice()), new boolean[0]);
                this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(11), nf.format(((InvestmentLedgerVo)data.get(i5)).getAdminPaymentAmount()), new boolean[0]);
                for (int t = 12; t <= endClo; ++t) {
                    this.handelCell(workbook, cellStyle, fileName, listRow.createCell(t), "", new boolean[0]);
                }
                ArrayList monthCount = null == ((InvestmentLedgerVo)data.get(i5)).getMonthCount() ? new ArrayList() : ((InvestmentLedgerVo)data.get(i5)).getMonthCount();
                for (InvestmentMonthCountVo ele : monthCount) {
                    this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(dataCloIndex + ele.getMonth() * 3 - 6), nf.format((BeanUtils.isNotEmpty((Object)ele.getCurrentInvestment()) ? ele.getCurrentInvestment() : BigDecimal.ZERO).setScale(2, 4).stripTrailingZeros()), new boolean[0]);
                    this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(dataCloIndex + ele.getMonth() * 3 - 5), BeanUtils.isNotEmpty((Object)ele.getProgress()) ? ele.getProgress() : "", new boolean[0]);
                    this.handelCell(workbook, dataCellStyle, fileName, listRow.createCell(dataCloIndex + ele.getMonth() * 3 - 4), nf.format((BeanUtils.isNotEmpty((Object)ele.getTotalInvestment()) ? ele.getTotalInvestment() : BigDecimal.ZERO).setScale(2, 4).stripTrailingZeros()), new boolean[0]);
                }
                ++counter;
            }
            ++row;
        }
        int lastIndex = sheet.getLastRowNum() + 1;
        int n = ++currentType;
        ++currentType;
        int i6 = n;
        while (i6 < pType.size()) {
            HSSFRow lastRow = sheet.createRow(lastIndex++);
            type = BizUtils.getDicValueByCode((List<DictModel>)pType, i6 == 12 ? 8 : i6);
            this.handleSubTitle(i6, cellStyle, fileName, endClo, type, workbook, lastRow);
            i6 = currentType++;
        }
        sheet.setColumnWidth(0, 1000);
        sheet.setColumnWidth(1, 5000);
        for (i6 = 2; i6 < heards.size(); ++i6) {
            sheet.setColumnWidth(i6, 2300);
        }
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    private void handleSubTitle(int currentType, HSSFCellStyle cellStyle, String fileName, int endClo, String type, HSSFWorkbook workbook, HSSFRow row) {
        for (int t = 0; t <= endClo; ++t) {
            if (t == 0) {
                this.handelCell(workbook, cellStyle, fileName, row.createCell(t), BizUtils.converttoChinaNumber(currentType == 12 ? 8 : currentType) + "\u3001" + type, true);
                workbook.getSheetAt(0).addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), 0, 1));
                continue;
            }
            this.handelCell(workbook, cellStyle, fileName, row.createCell(t), " ", new boolean[0]);
        }
    }

    private void handelCell(HSSFWorkbook workbook, HSSFCellStyle cellStyle, String sheetName, HSSFCell cell, String value, boolean ... title) {
        cell.setCellValue(StringUtils.isEmpty((CharSequence)value) ? " " : value);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        HSSFFont font = cellStyle.getFont((Workbook)workbook);
        if (null == font) {
            font = workbook.createFont();
        }
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)12);
        if (title.length == 1 && title[0]) {
            font.setFontHeightInPoints((short)14);
            font.setBold(true);
        }
        font.setColor(IndexedColors.BLACK.index);
        cellStyle.setFont(font);
        cellStyle.setWrapText(true);
        cell.setCellStyle(cellStyle);
        if (title.length == 1 && title[0]) {
            HSSFCellStyle style = workbook.createCellStyle();
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            font.setFontHeightInPoints((short)13);
            font.setColor(IndexedColors.BLACK.index);
            style.setFont(font);
            style.setBorderBottom(BorderStyle.THIN);
            style.setBorderTop(BorderStyle.THIN);
            style.setBorderLeft(BorderStyle.THIN);
            style.setBorderRight(BorderStyle.THIN);
            cell.setCellStyle(style);
        }
        HSSFSheet sheet = workbook.getSheet(sheetName);
        sheet.setColumnWidth(0, 1536);
        for (int i = 0; i < cell.getColumnIndex(); ++i) {
            if (sheet.getColumnWidth(i) < 65280) {
                sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 2 < 3000 ? 3000 : sheet.getColumnWidth(i));
                continue;
            }
            sheet.setColumnWidth(i, 6000);
        }
        sheet.autoSizeColumn(cell.getColumnIndex());
        sheet.getRow(cell.getRowIndex()).setHeightInPoints(30.0f);
    }

    private void handelCell(HSSFWorkbook workbook, HSSFCellStyle cellStyle, String sheetName, HSSFCell cell, BigDecimal value, boolean ... title) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        HSSFFont font = cellStyle.getFont((Workbook)workbook);
        if (null == font) {
            font = workbook.createFont();
        }
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)12);
        if (title.length == 1 && title[0]) {
            font.setFontHeightInPoints((short)14);
            font.setBold(true);
        }
        font.setColor(IndexedColors.BLACK.index);
        cellStyle.setFont(font);
        cellStyle.setWrapText(true);
        cell.setCellStyle(cellStyle);
        if (title.length == 1 && title[0]) {
            HSSFCellStyle style = workbook.createCellStyle();
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            font.setFontHeightInPoints((short)13);
            font.setColor(IndexedColors.BLACK.index);
            style.setFont(font);
            style.setBorderBottom(BorderStyle.THIN);
            style.setBorderTop(BorderStyle.THIN);
            style.setBorderLeft(BorderStyle.THIN);
            style.setBorderRight(BorderStyle.THIN);
            cell.setCellStyle(style);
        }
        HSSFSheet sheet = workbook.getSheet(sheetName);
        sheet.setColumnWidth(0, 1536);
        for (int i = 0; i < cell.getColumnIndex(); ++i) {
            if (sheet.getColumnWidth(i) < 65280) {
                sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 2 < 3000 ? 3000 : sheet.getColumnWidth(i));
                continue;
            }
            sheet.setColumnWidth(i, 6000);
        }
        sheet.autoSizeColumn(cell.getColumnIndex());
        sheet.getRow(cell.getRowIndex()).setHeightInPoints(30.0f);
        if (null != value) {
            cell.setCellValue(value.doubleValue());
        }
    }

    @Override
    public JSONObject yearTotalInvest(Integer year) {
        Assert.notNull((Object)year, (String)"\u7edf\u8ba1\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a!");
        JSONObject result = new JSONObject();
        List progressList = this.progressManager.list((Wrapper)new QueryWrapper().eq((Object)"YEAR_", (Object)year));
        List paymentList = this.administrativePaymentManager.list((Wrapper)new QueryWrapper().eq((Object)"PAYS_YEAR_", (Object)year));
        BigDecimal payTotal = new BigDecimal(0);
        BigDecimal investTotal = new BigDecimal(0);
        for (ProgressManage pro : progressList) {
            payTotal = payTotal.add(pro.getPayeeAmountTotal());
            if ("1".equals(pro.getPurpose())) {
                investTotal = investTotal.add(pro.getPayeeAmountTotal().multiply(new BigDecimal(0.75)));
                continue;
            }
            investTotal = investTotal.add(pro.getPayeeAmountTotal());
        }
        for (AdministrativePayment pay : paymentList) {
            payTotal.add(pay.getPaysValue());
            investTotal.add(pay.getPaysValue());
        }
        result.set("payTotal", (Object)payTotal.setScale(2, 4).stripTrailingZeros());
        result.set("investTotal", (Object)investTotal.setScale(2, 4).stripTrailingZeros());
        return result;
    }

    @Override
    public BigDecimal totalInvestByYear(Integer year) {
        Object price;
        Map map4;
        Object price2;
        Map map3;
        Object price3;
        Map map1;
        Object price4;
        Assert.notNull((Object)year, (String)"\u7edf\u8ba1\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a!");
        BigDecimal result = BigDecimal.ZERO;
        Map map2 = this.progressManager.getMap((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().select(new String[]{"SUM(PAYEE_AMOUNT_TOTAL_) as price"}).eq(year != 0, (Object)"YEAR_", (Object)year)).eq((Object)"PURPOSE_", (Object)"1")).eq((Object)"IS_DELE_", (Object)"0"));
        if (BeanUtils.isNotEmpty((Object)map2) && BeanUtils.isNotEmpty(price4 = map2.get("price"))) {
            BigDecimal multiply = ((BigDecimal)price4).multiply(new BigDecimal(0.75));
            result = result.add(multiply);
        }
        if (BeanUtils.isNotEmpty((Object)(map1 = this.progressManager.getMap((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().select(new String[]{"SUM(PAYEE_AMOUNT_TOTAL_) as price"}).eq(year != 0, (Object)"YEAR_", (Object)year)).ne((Object)"PURPOSE_", (Object)"1")).eq((Object)"IS_DELE_", (Object)"0")))) && BeanUtils.isNotEmpty(price3 = map1.get("price"))) {
            result = result.add((BigDecimal)price3);
        }
        if (BeanUtils.isNotEmpty((Object)(map3 = this.administrativePaymentManager.getMap((Wrapper)((QueryWrapper)new QueryWrapper().select(new String[]{"SUM(PAYS_VALUE_) as price"}).eq(year != 0, (Object)"PAYS_YEAR_", (Object)year)).eq((Object)"IS_DELE_", (Object)"0")))) && BeanUtils.isNotEmpty(price2 = map3.get("price"))) {
            result = result.add((BigDecimal)price2);
        }
        if (BeanUtils.isNotEmpty((Object)(map4 = this.planningUseLandManager.getMap((Wrapper)((QueryWrapper)new QueryWrapper().select(new String[]{"SUM(LAND_MONEY_) as price"}).like(year != 0, (Object)"ESTABLISHMENT_DATE_", (Object)year)).eq((Object)"IS_DELE_", (Object)"0")))) && BeanUtils.isNotEmpty(price = map4.get("price"))) {
            result = result.add((BigDecimal)price);
        }
        return result.setScale(2, 4).stripTrailingZeros();
    }
}

