/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.designEstimate.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.designEstimate.dao.EstimateDao;
import com.artfess.cqxy.designEstimate.manager.EstimateManager;
import com.artfess.cqxy.designEstimate.model.Estimate;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class EstimateManagerImpl
extends BaseManagerImpl<EstimateDao, Estimate>
implements EstimateManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private ProjectManagementManager pmm;
    @Autowired
    private GlobalRetrievalManager grm;

    public boolean saveOrUpdate(Estimate entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.six.getCode());
            ele.setGroup("Estimate");
            ele.setNode(ProjectStatusEnum.six.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.six.getCode()));
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, Estimate entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.ten.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.ten.getName());
        globalRetrieval.setBizTableName(FunctionEnum.ten.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.ten.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.ten.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.ten.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.ten.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.ten.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getDocumentNumber());
        globalRetrieval.setName(entity.getName());
        globalRetrieval.setDocumentUnit(entity.getEstablishmentApprovalUnit());
        globalRetrieval.setSearchTitle(entity.getName() + "_" + entity.getDocumentNumber() + "_" + entity.getEstablishmentApprovalUnit() + "_" + entity.getProposedLocation() + "_" + entity.getConstructionScale() + "_" + entity.getEstablishmentRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public Estimate getById(String id) {
        Estimate result = ((EstimateDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<Estimate> queryAllByPage(QueryFilter<Estimate> queryFilter) {
        BizUtils.handleFilter(queryFilter, "be", "pm");
        IPage<Estimate> result = ((EstimateDao)this.baseMapper).queryAllByPage((IPage<Estimate>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Estimate>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (Estimate ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, Estimate.class, (ImportParams)new ImportParams());
            for (Estimate ele : data) {
                ele.setProjectId(projectId);
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<Estimate> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u8bbe\u8ba1\u6982\u7b97-\u6982\u7b97-\u5bfc\u51fa\u7ed3\u679c";
        BizUtils.handleFilter(queryFilter, "be", "pm");
        List data = ((EstimateDao)this.baseMapper).queryAllByPage((IPage<Estimate>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<Estimate>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, Estimate.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }

    @Override
    public BigDecimal getEstimate(String pid, String year) {
        return ((EstimateDao)this.baseMapper).getEstimate(pid, year);
    }
}

