package com.artfess.bpm.persistence.manager.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;

import com.artfess.bpm.persistence.dao.BpmWatermarkProcessDao;
import com.artfess.bpm.persistence.manager.BpmWatermarkProcessManager;

import com.artfess.bpm.persistence.model.BpmWatermarkProcess;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <pre>
 * 描述：水印分配流程 处理实现类
 * 构建组：x7
 * 作者:zjq
 * 邮箱:zjq@jee-soft.cn
 * 日期:2020-12-23 17:12:58
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@Service("bpmWatermarkProcessManager")
public class BpmWatermarkProcessManagerImpl extends BaseManagerImpl<BpmWatermarkProcessDao, BpmWatermarkProcess> implements BpmWatermarkProcessManager {
    @Override
    public void batchAdd(List<BpmWatermarkProcess> watermarkProcesses, int isAllSave) {
        if (isAllSave==0){
            List<BpmWatermarkProcess> processes = watermarkProcesses.stream().filter(item -> {
                BpmWatermarkProcess process = isExist(item.getProcDefKey());
                if (BeanUtils.isNotEmpty(process)){
                    return false;
                }else{
                    return true;
                }
            }).collect(Collectors.toList());
            saveBatch(processes);
        }else{
            for (BpmWatermarkProcess item : watermarkProcesses) {
                BpmWatermarkProcess process = isExist(item.getProcDefKey());
                if (BeanUtils.isNotEmpty(process)){
                    process.setWatermarkId(item.getWatermarkId());
                    update(process);
                }else{
                    create(item);
                }
            }
        }
    }

    @Override
    public CommonResult<String> isExist(List<BpmWatermarkProcess> watermarkProcesses) {
        List<String> existList = new ArrayList<>();
        List<String> existHereList = new ArrayList<>();
        for (BpmWatermarkProcess item : watermarkProcesses) {
            BpmWatermarkProcess process = isExist(item.getProcDefKey());
            if (BeanUtils.isNotEmpty(process)) {
                if (!item.getWatermarkId().equals(process.getWatermarkId())) {
                    existList.add(item.getProcDefName());
                } else {
                    existHereList.add(item.getProcDefName());
                }
            }
        }
        //设置的流程与存在此水印下的流程数量相同时证明已分配过
        if (existHereList.size() == watermarkProcesses.size()) {
            return new CommonResult<>(false, "此流程已分配");
        } else if (existList.size() > 0) {
            return new CommonResult<>(true, "[" + String.join(",", existList) + "]已设置");
        } else {
            return new CommonResult<>(true, "设置成功");
        }
    }

    private BpmWatermarkProcess isExist(String defKey) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq("proc_def_key_", defKey);
        BpmWatermarkProcess process = baseMapper.selectOne(wrapper);
        return process;
    }
}
