package com.artfess.workflow.runtime.params;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 添加打印记录参数类
 * @author zhangxw
 *
 */
 @ApiModel(value = "BpmPrintRecordObject",description = "添加打印记录参数类") 
public class BpmPrintRecordObject{

	@SuppressWarnings("unused")
	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty(value="流程定义key")
	protected String procDefKey; 
	
	@ApiModelProperty(value="流程定义名称")
	protected String procDefName; 
	
	@ApiModelProperty(value="流程定义id")
	protected String procDefId; 
	
	@ApiModelProperty(value="流程实例ID")
	protected String procInstId; 
	
	@ApiModelProperty(value="流程节点id")
	protected String nodeId; 
	
	@ApiModelProperty(value="表单key")
	protected String formKey; 
	
	@ApiModelProperty(value="打印模板ID")
	protected String templateId; 
	
	@ApiModelProperty(value="打印模板名称")
	protected String templateName; 
	
	@ApiModelProperty(value="打印文件id")
	protected String fileId; 
	
	public void setProcDefKey(String procDefKey) {
		this.procDefKey = procDefKey;
	}
	
	/**
	 * 返回 PROC_DEF_KEY_
	 * @return
	 */
	public String getProcDefKey() {
		return this.procDefKey;
	}
	public void setProcDefName(String procDefName) {
		this.procDefName = procDefName;
	}
	
	/**
	 * 返回 PROC_DEF_NAME_
	 * @return
	 */
	public String getProcDefName() {
		return this.procDefName;
	}
	public void setProcDefId(String procDefId) {
		this.procDefId = procDefId;
	}
	
	/**
	 * 返回 PROC_DEF_ID_
	 * @return
	 */
	public String getProcDefId() {
		return this.procDefId;
	}
	public void setProcInstId(String procInstId) {
		this.procInstId = procInstId;
	}
	
	/**
	 * 返回 PROC_INST_ID_
	 * @return
	 */
	public String getProcInstId() {
		return this.procInstId;
	}
	public void setNodeId(String nodeId) {
		this.nodeId = nodeId;
	}
	
	/**
	 * 返回 NODE_ID_
	 * @return
	 */
	public String getNodeId() {
		return this.nodeId;
	}
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	/**
	 * 返回 表单key
	 * @return
	 */
	public String getFormKey() {
		return this.formKey;
	}
	public void setTemplateId(String templateId) {
		this.templateId = templateId;
	}
	
	/**
	 * 返回 打印模板ID
	 * @return
	 */
	public String getTemplateId() {
		return this.templateId;
	}
	public void setTemplateName(String templateName) {
		this.templateName = templateName;
	}
	
	/**
	 * 返回 打印模板名称
	 * @return
	 */
	public String getTemplateName() {
		return this.templateName;
	}
	public void setFileId(String fileId) {
		this.fileId = fileId;
	}
	
	/**
	 * 返回 打印文件id
	 * @return
	 */
	public String getFileId() {
		return this.fileId;
	}
	/**
	 * @see Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this)
		.append("procDefKey", this.procDefKey) 
		.append("procDefName", this.procDefName) 
		.append("procDefId", this.procDefId) 
		.append("procInstId", this.procInstId) 
		.append("nodeId", this.nodeId) 
		.append("formKey", this.formKey) 
		.append("templateId", this.templateId) 
		.append("templateName", this.templateName) 
		.append("fileId", this.fileId) 
		.toString();
	}
}