/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.form.model.ComponentValidEntity;
import com.artfess.form.persistence.dao.ComponentValidDao;
import com.artfess.form.persistence.manager.ComponentValidManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ComponentValidServiceImpl
extends BaseManagerImpl<ComponentValidDao, ComponentValidEntity>
implements ComponentValidManager {
    @Autowired
    ComponentValidManager componentValidMapper;

    @Override
    @Transactional
    public String insertComponentValid(ComponentValidEntity componentValidEntity) {
        Assert.notNull((Object)((Object)componentValidEntity), (String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
        Integer nextSequence = this.getNextSequence(null);
        componentValidEntity.setSn(nextSequence);
        this.checkValidity(componentValidEntity);
        this.componentValidMapper.save((Object)componentValidEntity);
        return componentValidEntity.getId();
    }

    @Override
    @Transactional
    public String updateComponentValid(ComponentValidEntity componentValidEntity) {
        Assert.notNull((Object)((Object)componentValidEntity), (String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
        this.checkValidity(componentValidEntity);
        this.componentValidMapper.updateById((Object)componentValidEntity);
        return componentValidEntity.getId();
    }

    @Override
    public ComponentValidEntity loadComponentValid(String id) {
        Assert.hasText((String)id, (String)"\u53c2\u6570id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
        return (ComponentValidEntity)((Object)this.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public Integer deleteComponentValid(String ids) {
        Assert.hasText((String)ids, (String)"\u53c2\u6570ids\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
        List<String> idsList = Arrays.asList(ids.split(","));
        this.componentValidMapper.removeByIds(idsList);
        return 1;
    }

    @Override
    public List<ComponentValidEntity> queryComponentValid(ComponentValidEntity componentValidEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like(StringUtils.isNotBlank((CharSequence)componentValidEntity.getValidName()), (Object)"VALID_NAME", (Object)componentValidEntity.getValidName());
        queryWrapper.eq(Objects.nonNull(componentValidEntity.getValidMode()), (Object)"VALID_MODE", (Object)componentValidEntity.getValidMode());
        queryWrapper.orderByAsc((Object)"SEQUENCE");
        return this.componentValidMapper.list((Wrapper)queryWrapper);
    }

    @Override
    public void updateComponentValidStatus(String ids, Integer status) {
        List<String> idsList = Arrays.asList(ids.split(","));
    }

    private void checkValidity(ComponentValidEntity componentValidEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)componentValidEntity.getValidName()), (Object)"VALID_NAME", (Object)componentValidEntity.getValidName());
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)componentValidEntity.getId()), (Object)"ID", (Object)componentValidEntity.getId());
        Integer count = this.componentValidMapper.count((Wrapper)queryWrapper);
        if (count > 0) {
            throw new ApplicationException("\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
        }
    }
}

