/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.handler;

import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ContextThread;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantHandler;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MultiTenantHandler
implements TenantHandler,
ContextThread {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String tenantIdColumn = "tenant_id_";
    private List<String> ignoreTableNames = new ArrayList<String>();
    @Autowired
    private BaseContext apiContext;
    @Resource
    SaaSConfig saaSConfig;
    private static ThreadLocal<Boolean> threadLocalIgnore = new ThreadLocal();

    public static MultiTenantIgnoreResult setThreadLocalIgnore() {
        threadLocalIgnore.set(true);
        return new MultiTenantIgnoreResult();
    }

    public static Boolean getThreadLocalIgnore() {
        Boolean ignoreTable = threadLocalIgnore.get();
        if (BeanUtils.isNotEmpty(ignoreTable) && ignoreTable.booleanValue()) {
            return true;
        }
        return false;
    }

    public static void removeThreadLocalIgnore() {
        threadLocalIgnore.remove();
    }

    public Expression getTenantId(boolean where) {
        String tenantId = this.apiContext.getCurrentTenantId();
        this.log.debug("\u5f53\u524d\u79df\u6237\u4e3a{}", (Object)tenantId);
        if (tenantId == null) {
            return new NullValue();
        }
        return new StringValue(tenantId);
    }

    public String getTenantCode() {
        String currentTenantId;
        if (this.saaSConfig.isEnable() && !"-1".equals(currentTenantId = this.apiContext.getCurrentTenantId())) {
            UCFeignService ucFeign = AppUtil.getBean(UCFeignService.class);
            JsonNode tenantManage = ucFeign.getTenantById(currentTenantId);
            Assert.notNull((Object)tenantManage, (String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u6240\u5c5e\u7684\u79df\u6237\u4fe1\u606f");
            String tenantCode = JsonUtil.getString((JsonNode)((ObjectNode)tenantManage), "code");
            Assert.isTrue((boolean)StringUtil.isNotEmpty(tenantCode), (String)"\u79df\u6237\u4e2d\u7684\u79df\u6237\u522b\u540d\u4e3a\u7a7a");
            return tenantCode;
        }
        return null;
    }

    public void setTenantId(String tenantId) {
        this.tenantIdColumn = tenantId;
    }

    public void setIgnoreTableNames(List<String> list) {
        this.ignoreTableNames = list;
    }

    public List<String> getIgnoreTableNames() {
        return this.ignoreTableNames;
    }

    public String getTenantIdColumn() {
        return this.tenantIdColumn;
    }

    public boolean doTableFilter(String tableName) {
        if (MultiTenantHandler.getThreadLocalIgnore().booleanValue()) {
            return true;
        }
        if (StringUtil.isNotEmpty(tableName) && tableName.toUpperCase().startsWith("W_")) {
            return true;
        }
        if (StringUtil.isNotEmpty(tableName) && tableName.toUpperCase().startsWith("UC_MATRIX_")) {
            return true;
        }
        return this.ignoreTableNames.stream().anyMatch(e -> e.equalsIgnoreCase(tableName));
    }

    @Override
    public void cleanAll() {
        MultiTenantHandler.removeThreadLocalIgnore();
    }
}

