import Vue from "vue";
import Vuex from "vuex";
import styleSetting from "@/store/styleSetting.js";
import login from "@/store/login.js";
import user from "@/store/user.js";
import menu from "@/store/menu.js";
import flow from "@/store/flow.js";
import tenant from "@/store/tenant.js";
import form from '@/store/formStore.js';
// 前台表单、流程渲染相关
import bizForm from '@/store/bizFormStore.js';
import storeProcess from '@/store/storeProcess.js';
import getters from '@/store/getters.js';
import agent from '@/store/bizCommon/agentList.js';
import approvalItem from '@/store/bizCommon/approvalItemList.js';
import dialog from '@/store/bizCommon/dialogStore.js';
import index from '@/store/bizCommon/index.js'


Vue.use(Vuex);

const debug = process.env.NODE_ENV !== "production";

export default new Vuex.Store({
  modules: {
    styleSetting,
    login,
    user,
    menu,
    flow,
    tenant,
    form,
    bizForm,
    storeProcess,
    agent,
    approvalItem,
    dialog,
    index
  },
  getters,
  strict: debug
});

