import Vue from "vue";
import App from "./App.vue";
import router from "./router";
import store from "./store";
import ElementUI from "element-ui";
import HotentUi from "bpm_el_ui";
import i18n from '@/locale/index.js';
import "bpm_el_ui/lib/bpm_el_ui.css";
import "bpm_el_ui/src/assets/css/element-variables.scss"
import "@/assets/css/element-custom.scss";
import '@/directive.js';
import ExportData from "@/components/ImportExportData/ExportData/ExportData.vue";
import ImportData from "@/components/ImportExportData/ImportData/ImportData.vue";
import HtSubmitButton from "@/components/common/HtSubmitButton.vue";
import HtDeleteButton from "@/components/common/HtDeleteButton.vue";
import HtLoadData from "@/components/common/HtLoadData.vue";
import svgIcon from "@/components/global/svgIcon.vue";
import DictSelect from "@/components/dict/DictSelect.vue";
import VueUeditorWrap from "vue-ueditor-wrap"; //引入富文本组件
import VueCodeMirror from 'vue-codemirror';
import 'codemirror/lib/codemirror.css';
import 'codemirror/theme/base16-light.css'
import 'codemirror/mode/vue/vue'
import 'codemirror/mode/javascript/javascript'
import 'codemirror/mode/groovy/groovy'
import req from "@/request.js";
import 'jquery';
import AMap from 'vue-amap';
import dataV from '@jiaminghi/data-view'
import { url } from '@/tripartite/buildBigScreen/src/config'
// import '@/tripartite/buildBigScreen/src/mock/'
//注册自定义组件
import '@/tripartite/buildBigScreen/src/components/'
//导入主题文件
import '@/tripartite/buildBigScreen/src/theme/index.js'
window.axios = req.axios;
Vue.config.productionTip = false
Vue.prototype.url = url;
Vue.use(window.AVUE, {
  size: 'mini'
});
Vue.use(dataV)

Vue.use(AMap);
AMap.initAMapApiLoader({
  key: "babe07289a50fc3eda093e6ccea2f8a4",
  plugin: ['AMap.Autocomplete', 'AMap.PlaceSearch', 'AMap.Scale', 'AMap.OverView', 'AMap.ToolBar', 'AMap.MapType', 'AMap.PolyEditor', 'AMap.CircleEditor','AMap.Geolocation'],
  // 默认高德 sdk 版本为 1.4.4
  v: '1.4.4'
});
import deepmerge from 'deepmerge';
import validate from '@/validate.js';
import dict from "@/locale/validate/dict.js";
import VueAMap from 'vue-amap';//高德地图插件
import VueClipboard from 'vue-clipboard2';//复制内容到剪贴板
import preventClick  from './api/clickOnceAtime'
Vue.use(preventClick)
import moment from 'moment'//导入文件
Vue.filter("global_filter", function(value, type = "YYYY-MM-DD hh:mm:ss") {
    return moment(value).format(type);
  });
Vue.filter('formatDate', function(value,pattern = "YYYY-MM-DD HH:mm:ss") {
  if (!value){
    return "";
  }
  return moment(value).format(pattern)
})
Vue.prototype.$moment = moment;//赋值使用
import eventBus from './api/bus.js'
Vue.use(eventBus);
import '@/assets/svg/svg.css'
import echarts from 'echarts'
Vue.prototype.$echarts = echarts 
import Video from 'video.js'
import 'video.js/dist/video-js.css'
Vue.prototype.$video = Video
// window.httpurl = "http://139.9.47.90:8088"
// console.log(window.location)
// console.log(window.httpurl)

// 字符串解析和序列化字符串
import qs from 'qs'
Vue.prototype.qs = qs;

Vue.config.productionTip = false;
Vue.prototype.$http = req;

import $ from 'jquery'
Vue.prototype.$ = $;

Vue.use(ElementUI, {
    i18n: (key, value) => i18n.t(key, value),
    size: "small"
});
Vue.use(HotentUi, {
    i18n: (key, value) => i18n.t(key, value)
});
//使用vue-codemirror组件
Vue.use(VueCodeMirror);
Vue.use(VueAMap);
Vue.use(VueClipboard);
// 注册全局组件
Vue.component("HtSubmitButton", HtSubmitButton);
Vue.component("HtDeleteButton", HtDeleteButton);
Vue.component("HtLoadData", HtLoadData);
Vue.component('vue-ueditor-wrap', VueUeditorWrap);
Vue.component('svgIcon', svgIcon);
Vue.component("DictSelect", DictSelect);
Vue.component('ExportData', ExportData);
Vue.component('ImportData', ImportData);




let app = new Vue({
    router,
    store,
    i18n,
    render: h => h(App)
}).$mount("#app");

export default app;

let validateLocal = localStorage.getItem("lang");
let currentLocal = validateLocal || "zh-CN";
app && app.$validator && app.$validator.localize(currentLocal);

if (app.$validator) {
    for (let rule in validate) {
        app.$validator.rules[rule] = validate[rule];
    }
    app.$validator.dictionary.container = deepmerge(dict, app.$validator.dictionary.container, { clone: true })
}

// el-tooltip 默认显示
Vue.prototype.$tooltipplacement = "bottom";