//  token 未设置
// import axios from '@/utils/axios';
import axios from "@/utils/axiosCrossDomain";

const baseUrl = "/http-server-base/publish/quota-v1";
const api = `/bizapi1${baseUrl}`;

// 测试端口用20044 正式部署上去用20043
const hostName1 = "/bizapi2/http-server-plus";
const hostName2 =
  "/bizapi2/http-server-base/publish/cockpit/quota-v1";

/**
 * 监控点资源
 */
export function getVideoCameraResource(regionId, enunittype, dimension, level) {
  return axios.get(`${api}/videoResource`, {
    params: {
      regionId,
      enunittype,
      dimension,
      level,
    },
  });
}

/**
 * 视频区域树(旧)
 */
export function videoRegionTree() {
  return axios.get(`${api}/videoRegionTree`);
}
/**
 * 视频区域树(新)
 */
export function getVideoTree() {
  // return axios.get(`/bizapi1/http-server-redis/video/getTree`);
  return axios.get(`${hostName1}/video/getTree`);
}

//获取该节点下的视频数量
export function getVideoTreeCounts(id) {
  // return axios.get(`${api}/VideoTreeCountsAndStateCnt?videoregion=${id}`);
  return axios.get(`${hostName2}/VideoTreeCountsAndStateCnt?videoregion=${id}`);
}

// 视频树中摄像头增量更新
export function videoIdStatusUpdate() {
  // return axios.get(`${api}/videoIdStatusUpdate`);
  return axios.get(`${hostName2}/videoIdStatus`);
}

// 获取某个桩号附近的摄像头
export function getNearbyCameras(params) {
  return axios.get(`${hostName2}/rescueCameraList`, { params });
}
