import axios from "@/utils/axiosCrossDomain";

import { get } from "@/utils/cookie";
const cqjcMaintServiceApi = `/gis-cqjc-maint`;

// 驾驶舱接口 巡检
export const checkTaskData = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricTotal/checkTaskData`,
    data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};

// 机电故障数据 /electricTotal/faultTotalData
export const faultTotalData = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricTotal/faultTotalData`,
    data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};

// 机电任务 /electricTotal/maintTaskData
export const maintTaskData = (data) => {
  return axios.post(`${cqjcMaintServiceApi}/electricTotal/maintTaskData`, data);
};

// 故障统计率 /electricTotal/faultRate
export const faultRate = (data) => {
  return axios.post(`${cqjcMaintServiceApi}/electricTotal/faultRate`, data, {
    headers: {
      token: get("token"), //token换成从缓存获取
    },
  });
};

// 机电故障分析 /electricTotal/faultMapData
export const faultMapData = (data) => {
  return axios.post(`${cqjcMaintServiceApi}/electricTotal/faultMapData`, data, {
    headers: {
      token: get("token"), //token换成从缓存获取
    },
  });
};

// 备件数据 /electricTotal/repoData
export const repoData = (params) => {
  return axios.get(`${cqjcMaintServiceApi}/electricTotal/repoData`, { params });
};

//设备完好率、故障率 /electricTotal/faultAndEquipmentRate
export const faultAndEquipmentRate = (params) => {
  return axios.get(
    `${cqjcMaintServiceApi}/electricTotal/faultAndEquipmentRate`,
    { params }
  );
};
//设备系统下拉框  /electricTotal/typeSelect
export const typeSelect = (params) => {
  return axios.get(`${cqjcMaintServiceApi}/electricTotal/typeSelect`, {
    params,

    headers: {
      token: get("token"), //token换成从缓存获取
    },
  });
};
// 机电故障排行 /electricTotal/faultOrder
export const faultOrder = (data) => {
  return axios.post(`${cqjcMaintServiceApi}/electricTotal/faultOrder`, data, {
    headers: {
      token: get("token"), //token换成从缓存获取
    },
  });
};
// /electricTotal/page
export const page = (data) => {
  return axios.post(`${cqjcMaintServiceApi}/electricTotal/page`, data, {
    headers: {
      token: get("token"), //token换成从缓存获取
    },
  });
};

// 机电专项工程 /electricTotal/project
export const project = (data) => {
  return axios.post(`${cqjcMaintServiceApi}/electricTotal/project`, data);
};

// 设备完好率 /electricTotal/equipmentRate
export const equipmentRate = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricTotal/equipmentRate`,
    data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};

// 新智提供的组织 /sysOrg/orgByXZ
export const orgByXZ = (params) => {
  return axios.get(`${cqjcMaintServiceApi}/sysOrg/orgByXZ`, {
    params,
    headers: {
      token: get("token"), //token换成从缓存获取
    },
  });
};

// 新增页面
// 基础设施统计 /electricCfgPermissionLocation/basicStructure
export const basicStructure = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/basicStructure`,
    data
  );
};

// 机电设备统计 /electricCfgPermissionLocation/basicEq
export const basicEq = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/basicEq`,
    data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};

// 年度养护项目分布 /electricCfgPermissionLocation/project
export const permissProject = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/project`,
    data
  );
};
// 年度养护项目分布 /electricCfgPermissionLocation/project
export const permissProject1 = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/project1`,
    data
  );
};

// 机电设备完好率排名 /electricCfgPermissionLocation/orderByEqRate
export const orderByEqRate = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/orderByEqRate`,
    data
  );
};

// 机电推送故障统计 /electricCfgPermissionLocation/xzFault
export const xzFault = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/xzFault`,
    data
  );
};

// 机电人员统计 /electricCfgPermissionLocation/userPermissionNum
export const userPermissionNum = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/userPermissionNum`,
    data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};

// 设备详情 /electricCfgPermissionLocation/eqDetail
export const eqDetail = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/eqDetail`,
    data
  );
};

// /electricTotal/maintTaskLine
export const maintTaskLine = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricTotal/maintTaskLine`,
    data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};
// 每个路段该种设备类型类型
export const eqNumByType = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/eqNumByType`,
    data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};
// 推送机电设备实时状态
export const sxEqStatus = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/sxEqStatus`,
    data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};
// 推送机电设备实时状态
export const sxEqStatus2 = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/sxEqStatus2`,
    data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};

// 地图点标记
export const setEqInfoList = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/eqInfoList`,
    data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};

// 路段坐标
export const sectionPoints = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/sectionPoints`,
    data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};

// 工单完成分析
export const faultSatisfied = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricTotal/faultSatisfied`,
    data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};

// 年度养护项目分部2
export const project2 = (data) => {
  return axios.post(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/project2`,
    data,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};

// 获取驾驶舱路段信息
export const getPathList = (sectionId) => {
  return axios.get(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/sectionPointsNew?page=1&size=1&sectionId=${sectionId}`,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};
// 获取驾驶舱路况信息
export const getDrivingList = (startIndex, endIndex) => {
  return axios.get(
    `${cqjcMaintServiceApi}/electricCfgPermissionLocation/driving?startIndex=${startIndex}&endIndex=${endIndex}`,
    {
      headers: {
        token: get("token"), //token换成从缓存获取
      },
    }
  );
};
