/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.es.unit;

import com.artfess.es.unit.ElasticIndexApplication;
import com.artfess.es.unit.ElasticSearchApplicationImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetFieldMappingsRequest;
import org.elasticsearch.client.indices.GetFieldMappingsResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesResponse;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.client.indices.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElasticIndexApplicationImpl
implements ElasticIndexApplication {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchApplicationImpl.class);
    private final RestHighLevelClient restHighLevelClient;

    @Autowired
    public ElasticIndexApplicationImpl(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    @Override
    public boolean isIndexExist(String indexName) {
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        boolean exists = false;
        try {
            exists = this.restHighLevelClient.indices().exists(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u7d22\u5f15\u4fe1\u606f\u83b7\u53d6\u53d1\u751f\u5f02\u5e38\uff01");
        }
        return exists;
    }

    @Override
    public List<Map<String, Object>> getIndexMapping(String indexName) {
        GetMappingsRequest request = new GetMappingsRequest();
        request.indices(new String[]{indexName});
        try {
            GetMappingsResponse getMappingResponse = this.restHighLevelClient.indices().getMapping(request, RequestOptions.DEFAULT);
            Map allMappings = getMappingResponse.mappings();
            if (allMappings != null) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                Iterator iterator = allMappings.keySet().iterator();
                while (iterator.hasNext()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String indexName1 = (String)iterator.next();
                    MappingMetaData indexMapping = (MappingMetaData)allMappings.get(indexName1);
                    Map mapping = indexMapping.sourceAsMap();
                    map.put("indexName", indexName1);
                    map.put("mapping", mapping);
                    list.add(map);
                }
                return list;
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u83b7\u53d6\u7d22\u5f15\u7684\u5b57\u6bb5\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff01");
            return null;
        }
    }

    @Override
    public Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>> getIndexFieldMapping(String indexName, List<String> fieldNames) {
        GetFieldMappingsRequest request = new GetFieldMappingsRequest();
        request.indices(new String[]{indexName});
        if (fieldNames != null) {
            for (String str : fieldNames) {
                request.fields(new String[]{str});
            }
        }
        try {
            GetFieldMappingsResponse getFieldMappingResponse = this.restHighLevelClient.indices().getFieldMapping(request, RequestOptions.DEFAULT);
            return getFieldMappingResponse.mappings();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u83b7\u53d6\u7d22\u5f15\u7684\u5b57\u6bb5\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff01");
            return null;
        }
    }

    @Override
    public boolean createIndex(String newIndexName, String indexTemplateName) throws IOException {
        boolean boo = this.isIndexExist(newIndexName);
        if (boo) {
            return false;
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(newIndexName);
        GetIndexTemplatesRequest getIndexTemplatesRequest = new GetIndexTemplatesRequest(new String[]{indexTemplateName});
        GetIndexTemplatesResponse getIndexTemplatesResponse = this.restHighLevelClient.indices().getIndexTemplate(getIndexTemplatesRequest, RequestOptions.DEFAULT);
        List indexTemplates = getIndexTemplatesResponse.getIndexTemplates();
        if (indexTemplates.size() != 0) {
            IndexTemplateMetaData indexTemplateMetaData = (IndexTemplateMetaData)indexTemplates.get(0);
            MappingMetaData mappings = indexTemplateMetaData.mappings();
            Settings settings = indexTemplateMetaData.settings();
            createIndexRequest.mapping(mappings.getSourceAsMap());
            createIndexRequest.settings(settings);
        }
        CreateIndexResponse createIndexResponse = this.restHighLevelClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        return createIndexResponse.isAcknowledged();
    }

    @Override
    public List<IndexTemplateMetaData> getIndexTemplate(String indexTemplateName) throws IOException {
        GetIndexTemplatesRequest getIndexTemplatesRequest = new GetIndexTemplatesRequest(new String[]{indexTemplateName});
        GetIndexTemplatesResponse getIndexTemplatesResponse = this.restHighLevelClient.indices().getIndexTemplate(getIndexTemplatesRequest, RequestOptions.DEFAULT);
        List indexTemplates = getIndexTemplatesResponse.getIndexTemplates();
        return indexTemplates;
    }

    @Override
    public boolean createIndex(String newIndexName, Settings settings, XContentBuilder xContentBuilder) throws IOException {
        boolean boo = this.isIndexExist(newIndexName);
        if (boo) {
            return false;
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(newIndexName);
        createIndexRequest.mapping(xContentBuilder);
        createIndexRequest.settings(settings);
        CreateIndexResponse createIndexResponse = this.restHighLevelClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        return createIndexResponse.isAcknowledged();
    }

    @Override
    public RefreshResponse refreshIndex(String ... indexName) throws IOException {
        RefreshRequest refreshRequest = new RefreshRequest(indexName);
        return this.restHighLevelClient.indices().refresh(refreshRequest, RequestOptions.DEFAULT);
    }

    @Override
    public RefreshResponse refreshIndex() throws IOException {
        RefreshRequest refreshRequest = new RefreshRequest(new String[0]);
        return this.restHighLevelClient.indices().refresh(refreshRequest, RequestOptions.DEFAULT);
    }
}

