/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.controller;

import com.artfess.application.model.MessageConfig;
import com.artfess.application.model.MsgTemplate;
import com.artfess.application.persistence.manager.MessageConfigManager;
import com.artfess.application.persistence.manager.MsgTemplateManager;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/msg/messageConfig/v1"})
@Api(tags={"\u6d88\u606f\u914d\u7f6e"})
@ApiGroup(group={"group_application"})
public class MessageConfigController
extends BaseController<MessageConfigManager, MessageConfig> {
    @Resource
    MessageConfigManager messageConfigManager;
    @Resource
    MsgTemplateManager msgTemplateManager;
    @Resource
    UCFeignService ucFeignService;

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u6d88\u606f\u914d\u7f6e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u6d88\u606f\u914d\u7f6e\u5217\u8868")
    public PageList<MessageConfig> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<MessageConfig> queryFilter) throws Exception {
        return this.messageConfigManager.query(queryFilter);
    }

    @RequestMapping(value={"getById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u5185\u5bb9", httpMethod="GET", notes="\u6839\u636eID\u83b7\u53d6\u5185\u5bb9")
    public MessageConfig getById(@ApiParam(name="id", value="id", required=true) @RequestParam String id) {
        MessageConfig messageConfig = (MessageConfig)((Object)this.messageConfigManager.getById((Serializable)((Object)id)));
        return messageConfig;
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u6d88\u606f\u914d\u7f6e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u6d88\u606f\u914d\u7f6e")
    public CommonResult<String> save(@ApiParam(name="MessageConfig", value="\u6d88\u606f\u914d\u7f6e", required=true) @RequestBody MessageConfig messageConfig) throws Exception {
        String userStr;
        String msg = "\u6dfb\u52a0\u6d88\u606f\u914d\u7f6e\u6210\u529f";
        boolean isExist = false;
        if (ObjectUtils.isNotEmpty((Object)((Object)messageConfig))) {
            PageList query;
            QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
            String id = messageConfig.getId();
            String code = messageConfig.getCode();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                queryFilter.addFilter("id_", (Object)id, QueryOP.NOT_IN);
            }
            if (StringUtils.isNotBlank((CharSequence)code)) {
                queryFilter.addFilter("code_", (Object)code, QueryOP.EQUAL);
            }
            boolean bl = isExist = (query = ((MessageConfigManager)this.baseService).query(queryFilter)).getRows().size() > 0;
        }
        if (isExist) {
            return new CommonResult(false, "\u914d\u7f6e\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u6dfb\u52a0\u5931\u8d25", null);
        }
        System.out.println(messageConfig.getUserConfigType());
        if (messageConfig.getUserConfigType() == 2 && StringUtils.isNotBlank((CharSequence)(userStr = messageConfig.getUserStr()))) {
            List list = (List)JsonUtil.toBean((String)userStr, List.class);
            String userId = "";
            String orgId = "";
            for (Map m : list) {
                String codes;
                String type = String.valueOf(m.get("type"));
                if ("user".equalsIgnoreCase(type)) {
                    codes = String.valueOf(m.get("codes"));
                    if (StringUtils.isBlank((CharSequence)codes)) continue;
                    ArrayNode userByAccounts = this.ucFeignService.getUserByAccounts(codes);
                    for (JsonNode userByAccount : userByAccounts) {
                        String id = userByAccount.get("id").toString();
                        if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                        userId = id.replace("\"", "").replace("\"", "") + ",";
                    }
                }
                if (!"org".equalsIgnoreCase(type) || StringUtils.isBlank((CharSequence)(codes = String.valueOf(m.get("codes"))))) continue;
                ArrayNode orgList = this.ucFeignService.getOrgListByCodes(codes);
                for (JsonNode org : orgList) {
                    orgId = org.get("id").toString() + ",";
                }
            }
            int i = userId.lastIndexOf(",");
            messageConfig.setOrgId(orgId.substring(0, orgId.lastIndexOf(",")));
            messageConfig.setUserId(userId.substring(0, userId.lastIndexOf(",")));
        }
        if (StringUtil.isEmpty((String)messageConfig.getId())) {
            ((MessageConfigManager)this.baseService).create((Model)messageConfig);
        } else {
            ((MessageConfigManager)this.baseService).update((Model)messageConfig);
            msg = "\u66f4\u65b0\u6d88\u606f\u914d\u7f6e\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove/{id}"})
    @ApiOperation(value="\u5220\u9664\u6d88\u606f\u914d\u7f6e", httpMethod="DELETE", notes="\u5220\u9664\u6d88\u606f\u914d\u7f6e")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e1a\u52a1\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        String tplKey = ((MessageConfig)this.messageConfigManager.get((Serializable)((Object)id))).getTplKey();
        MsgTemplate msgTemplate = this.msgTemplateManager.gettypeKey(tplKey);
        if (msgTemplate == null) {
            this.messageConfigManager.remove((Serializable)((Object)id));
            return new CommonResult(true, "\u5220\u9664\u6210\u529f");
        }
        return new CommonResult(false, "\u8be5\u914d\u7f6e\u5df2\u88ab\u5e94\u7528\uff0c\u5220\u9664\u5931\u8d25\uff01");
    }

    @DeleteMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6d88\u606f\u914d\u7f6e", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6d88\u606f\u914d\u7f6e")
    public CommonResult<String> removes(String ... ids) throws Exception {
        String msg = "\u5220\u9664\u6d88\u606f\u5206\u7c7b\u6210\u529f";
        for (int i = 0; i < ids.length; ++i) {
            String name = ((MessageConfig)this.messageConfigManager.get((Serializable)((Object)ids[i]))).getName();
            String tplKey = ((MessageConfig)this.messageConfigManager.get((Serializable)((Object)ids[i]))).getTplKey();
            MsgTemplate msgTemplate = this.msgTemplateManager.gettypeKey(tplKey);
            if (msgTemplate != null) {
                msg = name + "\u5220\u9664\u6d88\u606f\u5206\u7c7b\u5931\u8d25";
                continue;
            }
            this.messageConfigManager.removeByIds(Arrays.asList(ids[i]));
        }
        return new CommonResult(msg);
    }

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d88\u606f\u914d\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6d88\u606f\u914d\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<MessageConfig> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<MessageConfig> queryFilter) throws Exception {
        PageList<MessageConfig> sysMsgConfigList = this.messageConfigManager.queryByTemplateName(queryFilter);
        return sysMsgConfigList;
    }
}

