package com.artfess.application.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.time.LocalDateTime;


/**
* 系统三员操作日志
* <pre>
* 描述：系统三员操作日志 实体对象
* </pre>
*/
@TableName("portal_sys_member_logs")
@ApiModel(value = "三员日志实体",description = "三员日志实体")
public class SysMemberLogs extends AutoFillModel<SysMemberLogs> {

   private static final long serialVersionUID = 1L;

   @ApiModelProperty(name="id", notes="主键")
   @TableId("id_")
   protected String id;

   @ApiModelProperty(value="'客户端IP'")
   @TableField("CLIENT_IP")
   protected String clientIp;


   @ApiModelProperty(value="操作(创建账号。机构人员。角色等)")
   @TableField("OPERATE")
   protected String operate;

   @ApiModelProperty(value="'日志内容（XXX人在XXX时间，操作什么功能，结果）")
   @TableField("OPERATE_CONTENT")
   protected String operateContent;

   @ApiModelProperty(value="日志类型")
   @TableField("JAVA_METHOD")
   protected String javaMethod;

   @ApiModelProperty(value="'请求类型'")
   @TableField("REAUEST_TYPE")
   protected String reaultType;

   @ApiModelProperty(value="请求url地址")
   @TableField("url")
   protected String url;

   @ApiModelProperty(value="请求结果")
   @TableField("result")
   protected String opeContent;

    @ApiModelProperty(value="请求参数")
    @TableField("PARAMS")
    protected String params;

    @ApiModelProperty(value="操作类型(1：管理员日志 2：安全员日志 3：审计员日志)")
    @TableField("TYPE")
    protected int type;

    @ApiModelProperty(value="耗时")
    @TableField("COST_TIME")
    protected int costTime;

    @ApiModelProperty(value="操作时间")
    @TableField("CREATE_DATE")
    protected LocalDateTime createDate;

   public SysMemberLogs(){

   }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getOperate() {
        return operate;
    }

    public void setOperate(String operate) {
        this.operate = operate;
    }

    public String getOperateContent() {
        return operateContent;
    }

    public void setOperateContent(String operateContent) {
        this.operateContent = operateContent;
    }

    public String getJavaMethod() {
        return javaMethod;
    }

    public void setJavaMethod(String javaMethod) {
        this.javaMethod = javaMethod;
    }

    public String getReaultType() {
        return reaultType;
    }

    public void setReaultType(String reaultType) {
        this.reaultType = reaultType;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getOpeContent() {
        return opeContent;
    }

    public void setOpeContent(String opeContent) {
        this.opeContent = opeContent;
    }

    public String getParams() {
        return params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getCostTime() {
        return costTime;
    }

    public void setCostTime(int costTime) {
        this.costTime = costTime;
    }

    public SysMemberLogs(String clientIp, String operate, String operateContent, String javaMethod, String reaultType,
                         String url, String opeContent, String params, int type, int costTime,LocalDateTime createDate) {
        this.clientIp = clientIp;
        this.operate = operate;
        this.operateContent = operateContent;
        this.javaMethod = javaMethod;
        this.reaultType = reaultType;
        this.url = url;
        this.opeContent = opeContent;
        this.params = params;
        this.type = type;
        this.costTime = costTime;
        this.createDate = createDate;
    }

    public LocalDateTime getCreateDate() {
        return createDate;
    }

    public void setCreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }
}