/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.kh.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.portal.kh.dao.KhSchemeDao;
import com.artfess.portal.kh.manager.KhSchemeIndicatorsManager;
import com.artfess.portal.kh.manager.KhSchemeManager;
import com.artfess.portal.kh.model.KhScheme;
import com.artfess.portal.kh.model.KhSchemeIndicators;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class KhSchemeManagerImpl
extends BaseManagerImpl<KhSchemeDao, KhScheme>
implements KhSchemeManager {
    @Autowired
    private KhSchemeIndicatorsManager detailsManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createInfo(KhScheme t) {
        t.setStatus("0");
        boolean save = this.save((Object)t);
        if (save) {
            this.processDetail(t);
            return save;
        }
        return false;
    }

    private void processDetail(KhScheme t) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        this.detailsManager.remove((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty(t.getSchemeIndicatorsList())) {
            return;
        }
        t.getSchemeIndicatorsList().forEach(detail -> detail.setSchemeId(t.getId()));
        this.detailsManager.saveBatch(t.getSchemeIndicatorsList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(KhScheme t) {
        boolean save = this.updateById((Object)t);
        if (save) {
            this.processDetail(t);
            return save;
        }
        return false;
    }

    @Override
    public KhScheme findById(String id) {
        KhScheme KhScheme2 = (KhScheme)this.get((Serializable)((Object)id));
        Assert.notNull((Object)((Object)KhScheme2), (String)"\u8bc4\u7ea7\u65b9\u6848\u4e0d\u5b58\u5728");
        List<KhSchemeIndicators> list = this.detailsManager.findBySchemeId(id);
        KhScheme2.setSchemeIndicatorsList(list);
        return KhScheme2;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(List<String> ids, String status) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(KhScheme::getId, ids);
        List list = this.list((Wrapper)lambdaQueryWrapper);
        list.forEach(KhScheme2 -> KhScheme2.setStatus(status));
        boolean b = this.updateBatchById(list);
        return b;
    }
}

