package com.artfess.form.persistence.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.cache.annotation.CachePut;
import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.cache.annotation.FirstCache;
import com.artfess.base.constants.CacheKeyConst;
import com.artfess.base.constants.DataSourceConsts;
import com.artfess.base.constants.SQLConst;
import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.SystemException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.manager.CommonManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.Column;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.template.impl.FreeMarkerEngine;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FilterJsonStructUtil;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bo.bodef.BoDefService;
import com.artfess.bo.constant.BoConstants;
import com.artfess.bo.context.FormContextThreadUtil;
import com.artfess.bo.instance.BoDataHandler;
import com.artfess.bo.instance.BoDataImportHandler;
import com.artfess.bo.instance.BoInstanceFactory;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoData;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.model.BoResult;
import com.artfess.bo.model.ValidateResult;
import com.artfess.bo.persistence.manager.BoAttributeManager;
import com.artfess.bo.persistence.manager.BoEntManager;
import com.artfess.bo.util.BoUtil;
import com.artfess.form.manager.FormDataTemplateExtendManager;
import com.artfess.form.manager.FormRemindDataManager;
import com.artfess.form.model.DisplayField;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormDataImportLog;
import com.artfess.form.model.FormDataTemplate;
import com.artfess.form.model.FormDataTemplateDraft;
import com.artfess.form.model.FormDataTemplateExtend;
import com.artfess.form.model.FormDataTemplateXml;
import com.artfess.form.model.FormDataTemplateXmlList;
import com.artfess.form.model.FormField;
import com.artfess.form.model.FormMeta;
import com.artfess.form.model.FormRemindData;
import com.artfess.form.model.FormTemplate;
import com.artfess.form.param.DataTemplateQueryVo;
import com.artfess.form.param.SelectParam;
import com.artfess.form.persistence.dao.FormDataTemplateDao;
import com.artfess.form.persistence.manager.FormDataImportLogManager;
import com.artfess.form.persistence.manager.FormDataTemplateDraftManager;
import com.artfess.form.persistence.manager.FormDataTemplateManager;
import com.artfess.form.persistence.manager.FormFieldManager;
import com.artfess.form.persistence.manager.FormManager;
import com.artfess.form.persistence.manager.FormMetaManager;
import com.artfess.form.persistence.manager.FormRightManager;
import com.artfess.form.persistence.manager.FormTemplateManager;
import com.artfess.form.service.FormService;
import com.artfess.form.util.FormUtil;
import com.artfess.form.util.FreeMakerUtil;
import com.artfess.form.vo.ExportSubVo;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.table.datasource.DataSourceUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.impl.util.PermissionCalc;
import com.artfess.uc.api.impl.util.PermissionUtil;
import com.artfess.uc.api.impl.var.IContextVar;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang.ArrayUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import static com.artfess.base.util.SQLUtil.ClobToString;

/**
 * 业务数据模板
 *
 * @author heyifan
 * @company 阿特菲斯信息技术有限公司
 * @email heyf@jee-soft.cn
 * @date 2020年4月14日
 */
@Service("bpmDataTemplateManager")
public class FormDataTemplateManagerImpl extends BaseManagerImpl<FormDataTemplateDao, FormDataTemplate> implements FormDataTemplateManager {
    private static final String LOGIN_USER = "loginUser";
    private static final String LOGIN_USER_ORGS = "loginUserOrgs";
    private static final String LOGIN_USER_SUB_ORGS = "loginUserSubOrgs";
    private static final String CUSTOM_ORGS = "customOrgs";
    private static final String[] flowField = {"F_bpm_proc_inst_id_", "F_bpm_subject_", "F_bpm_proc_def_name_", "F_bpm_status_", "F_bpm_create_time_", "F_bpm_end_time_", "F_bpm_is_forbidden_", "F_bpm_creator_", "F_bpm_is_dele_"};
    @Resource
    FormTemplateManager formTemplateManager;
    @Resource
    FormManager formManager;
    @Resource
    FormFieldManager formFieldManager;
    @Resource
    BoDataHandler boDataHandler;
    @Resource
    BoInstanceFactory boInstanceFactory;
    @Resource
    BoDefService boDefService;
    @Resource(name = "formPermissionCalc")
    PermissionCalc permssionCalc;
    @Resource
    FreeMarkerEngine freemarkEngine;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    FormMetaManager formMetaManager;
    @Autowired
    UserDetailsService userDetailsService;
    @Resource
    BoEntManager boEntManager;
    @Resource
    BoAttributeManager boAttributeManager;
    @Resource
    FormRightManager bpmFormRightManager;
    @Resource
    FormService formService;
    @Resource
    WorkflowFeignService workflowFeignService;
    @Resource
    CommonManager commonManager;
    @Resource
    FormDataTemplateDraftManager dataTemplateDraftManager;
    @Resource
    FormDataImportLogManager formDataImportLogManager;
    @Resource
    FormDataTemplateExtendManager formDataTemplateExtendManager;
    @Resource
    FormRemindDataManager formRemindDataManager;

    @Override
    public ObjectNode getByFormKey(String formKey, String boId) throws IOException {
        ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
        jsonObject.put("status", 1);
        jsonObject.put("msg", "支持生成业务数据模板");
        List<FormTemplate> templates = new ArrayList<FormTemplate>();
        FormDataTemplate bpmDataTemplate = new FormDataTemplate();
        List<FormField> fields = new ArrayList<FormField>();
        List<FormField> formField = new ArrayList<FormField>();
        BoDef baseBoDef = null;
        String boDefId = "";
        String colPrefix = "";
        String displaySettingFields = "";
        Boolean flag = true;
        List<BoEnt> subEnt = new ArrayList<BoEnt>();

        // formKey ==>获取表单元数据定义id  def_id 根据def_id 获取bo对象的个数， 只有一个才支持业务对象模板的绑定
        Form bpmForm = formManager.getMainByFormKey(formKey);
        String formId = bpmForm.getDefId();
        List<String> boDefIds = formMetaManager.getBODefIdByFormId(formId);
//		if(boDefIds.isEmpty() || boDefIds.size()!=1 ){
//			ThreadMsgUtil.addMsg("该业务表单不支持生成业务数据模板(只支持一个BO生成的表单)");
//			jsonObject.put("status", 0);
//			jsonObject.put("msg", ThreadMsgUtil.getMessage().trim());
//			fag = false;
//		}
        if (BeanUtils.isEmpty(boDefIds)) {
            ThreadMsgUtil.addMsg("该业务表单BO为空");
            jsonObject.put("status", 0);
            jsonObject.put("msg", ThreadMsgUtil.getMessage().trim());
            flag = false;
        }

        if (flag) {
            boDefId = boDefIds.get(0);
            if (StringUtil.isNotEmpty(boId)) {
                for (int i = 0; i < boDefIds.size(); i++) {
                    if (boDefIds.get(i).equals(boId)) {
                        boDefId = boDefIds.get(i);
                    }
                }
            }
//			boDefId = boDefIds.get(0);
            baseBoDef = boDefService.getByDefId(boDefId);
            colPrefix = baseBoDef.getBoEnt().isExternal() ? "" : SQLConst.CUSTOMER_COLUMN_PREFIX;
            if (!baseBoDef.isSupportDb()) {
                jsonObject.put("status", 0);
                jsonObject.put("msg", "该表单不支持数据库，不能生成业务数据模板");
                flag = false;
            }
        }
        if (flag) {

            BoDef boDef = boDefService.getByAlias(baseBoDef.getAlias());
            BoEnt boEnt = (BoEnt) boDef.getBoEnt();
            fields = getFormFields(boEnt.getId());
            for (FormField field : fields) {
                formField.add(field);
            }

			/*// 获取字段信息  根据form_id_(表单元数据定义id) , 业务对象定义id 获取主表字段
			List<FormField> initFields  = formFieldManager.getByFormIdAndBoDefId(formId, boDefId);
			//只获取主表字段
			for (FormField bpmFormField : initFields) {
				if(bpmFormField.getEntId().equals(boEnt.getId()) && !"sub".equals(bpmFormField.getCtrlType()) && !"tabs".equals(bpmFormField.getCtrlType())){
					fields.add(bpmFormField);
				}
			}*/

            displaySettingFields = this.getDisplayField(fields, "");
            bpmDataTemplate = new FormDataTemplate();
            bpmDataTemplate.setFormKey(formKey);
            bpmDataTemplate.setDisplayField(displaySettingFields);
            bpmDataTemplate.setBoDefId(boDefId); // 设置业务对象定义id
            bpmDataTemplate.setBoDefAlias(baseBoDef.getAlias());
            bpmDataTemplate.setName(bpmForm.getName());
            bpmDataTemplate.setTypeId(bpmForm.getTypeId());
            bpmDataTemplate.setTypeName(bpmForm.getTypeName());
            //添加流程字段
            if (StringUtil.isNotEmpty(bpmDataTemplate.getDefId())) {
                addFieldList(fields);
            }

            //获取子表与孙表数据
            subEnt = boEnt.getChildEntList();
        }

        // 获取表单模板
        templates = formTemplateManager.getTemplateType(FormTemplate.DATA_TEMPLATE);

        jsonObject.set("templates", JsonUtil.toJsonNode(templates));
        jsonObject.set("bpmDataTemplate", JsonUtil.toJsonNode(bpmDataTemplate));
        jsonObject.set("fields", JsonUtil.toJsonNode(fields));
        jsonObject.put("displaySettingFields", displaySettingFields);
        jsonObject.set("data", tidyJson(bpmDataTemplate));
        jsonObject.put("colPrefix", colPrefix);
        jsonObject.put("formId", formId);
        jsonObject.set("formField", JsonUtil.toJsonNode(formField));
        jsonObject.set("subFormField", JsonUtil.toJsonNode(subEnt));
        jsonObject.set("permissionList", PermissionUtil.getPermissionList("formPermissionCalcList"));
        return jsonObject;
    }

    @Override
    public ObjectNode getByTemplateId(String id, String boId) throws IOException {
        ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
        jsonObject.put("status", 1);
        jsonObject.put("msg", "支持生成业务数据模板");
        List<FormTemplate> templates = new ArrayList<FormTemplate>();
        FormDataTemplate bpmDataTemplate = this.get(id);
        bpmDataTemplate.setRemindSettingList(formDataTemplateExtendManager.getJsonByFormDataTemplateId(id));
        List<FormField> fields = new ArrayList<FormField>();
        List<FormField> formField = new ArrayList<FormField>();
        BoDef baseBoDef = null;
        String boDefId = "";
        String colPrefix = "";
        String displaySettingFields = "";
        Boolean flag = true;
        String formKey = bpmDataTemplate.getFormKey();
        List<BoEnt> subEnt = new ArrayList<BoEnt>();
        // formKey ==>获取表单元数据定义id  def_id 根据def_id 获取bo对象的个数， 只有一个才支持业务对象模板的绑定
        Form bpmForm = formManager.getMainByFormKey(formKey);
        String formId = bpmForm.getDefId();
        List<String> boDefIds = formMetaManager.getBODefIdByFormId(formId);

        if (BeanUtils.isEmpty(boDefIds)) {
            ThreadMsgUtil.addMsg("该业务表单BO为空");
            jsonObject.put("status", 0);
            jsonObject.put("msg", ThreadMsgUtil.getMessage().trim());
            flag = false;
        }

        if (flag) {
            boDefId = boDefIds.get(0);
            if (StringUtil.isNotEmpty(boId)) {
                for (int i = 0; i < boDefIds.size(); i++) {
                    if (boDefIds.get(i).equals(boId)) {
                        boDefId = boDefIds.get(i);
                    }
                }
            }
            baseBoDef = boDefService.getByDefId(boDefId);
            colPrefix = baseBoDef.getBoEnt().isExternal() ? "" : SQLConst.CUSTOMER_COLUMN_PREFIX;
            if (!baseBoDef.isSupportDb()) {
                jsonObject.put("status", 0);
                jsonObject.put("msg", "该表单不支持数据库，不能生成业务数据模板");
                flag = false;
            }
        }
        if (flag) {

            BoDef boDef = boDefService.getByAlias(baseBoDef.getAlias());
            BoEnt boEnt = (BoEnt) boDef.getBoEnt();
            fields = getFormFields(boEnt.getId());

            // 获取字段信息  根据form_id_(表单元数据定义id) , 业务对象定义id 获取主表字段
            List<FormField> initFields = formFieldManager.getByFormIdAndBoDefId(formId, boDefId);
            //只获取主表字段
            for (FormField bpmFormField : initFields) {
                if (bpmFormField.getEntId() != null && bpmFormField.getEntId().equals(boEnt.getId()) && !"sub".equals(bpmFormField.getCtrlType()) && !"tabs".equals(bpmFormField.getCtrlType())) {
//					fields.add(bpmFormField);
                    formField.add(bpmFormField);
                }
            }

            //添加流程字段
            if (StringUtil.isNotEmpty(bpmDataTemplate.getDefId())) {
                addFieldList(fields);
            }
            displaySettingFields = this.getDisplayField(fields, "");
            bpmDataTemplate.setDisplayField(bpmDataTemplate.getDisplayField());

            //获取子表与孙表数据
            subEnt = boEnt.getChildEntList();
        }
        // 获取表单模板
        templates = formTemplateManager.getTemplateType(FormTemplate.DATA_TEMPLATE);
        jsonObject.set("templates", JsonUtil.toJsonNode(templates));
        jsonObject.set("bpmDataTemplate", JsonUtil.toJsonNode(bpmDataTemplate));
        jsonObject.set("fields", JsonUtil.toJsonNode(fields));
        jsonObject.put("displaySettingFields", displaySettingFields);
        jsonObject.set("data", tidyJson(bpmDataTemplate));
        jsonObject.put("colPrefix", colPrefix);
        jsonObject.put("formId", formId);
        jsonObject.set("formField", JsonUtil.toJsonNode(formField));
        jsonObject.set("subFormField", JsonUtil.toJsonNode(subEnt));
        jsonObject.set("permissionList", PermissionUtil.getPermissionList("formPermissionCalcList"));
        return jsonObject;
    }

    private List<FormField> getFormFields(String boEntId) {
        List<FormField> fields = new ArrayList<>();
        List<BoAttribute> attributes = boAttributeManager.getByEntId(boEntId);
        fields.addAll(convertAttr2Field(attributes));
        return fields;
    }

    private List<FormField> convertAttr2Field(List<BoAttribute> attributes) {
        List<FormField> fields = new ArrayList<>();
        for (BoAttribute attribute : attributes) {
            FormField field = new FormField();
            field.setName(attribute.getName());
            field.setDesc(attribute.getDesc());
            field.setType(attribute.getDataType());
            field.setShowFlowField(true);
            field.setStatus(attribute.getStatus());
            fields.add(field);
        }
        return fields;
    }

    private ObjectNode tidyJson(FormDataTemplate template) throws IOException {
        template.setTemplateHtml("");
        ObjectNode jsonObject = (ObjectNode) JsonUtil.toJsonNode(template);
        jsonObject.remove("pageBean");
        jsonObject.remove("createBy");
        jsonObject.remove("createtime");
        jsonObject.remove("updateBy");
        jsonObject.remove("updatetime");
        return jsonObject;
    }

    private String getDisplayField(List<FormField> fields, String displayField) throws IOException {
        Map<String, String> map = getDisplayFieldRight(displayField);
        Map<String, String> descMap = getDisplayFieldDesc(displayField);
        if (BeanUtils.isNotEmpty(fields)) {
            ArrayNode jsonAry = JsonUtil.getMapper().createArrayNode();
            for (FormField bpmFormField : fields) {
                ObjectNode json = JsonUtil.getMapper().createObjectNode();
                json.put("name", bpmFormField.getName());
                String desc = bpmFormField.getDesc();
                if (BeanUtils.isNotEmpty(map) && map.containsKey(bpmFormField.getName())) {
                    desc = descMap.get(bpmFormField.getName());
                }
                json.put("desc", desc);
                json.put("type", bpmFormField.getType());
                json.put("status", bpmFormField.getStatus());
                String right = "";
                if (BeanUtils.isNotEmpty(map))
                    right = map.get(bpmFormField.getName());
                if (StringUtil.isEmpty(right))
                    right = getDefaultDisplayFieldRight();

                json.put("right", right);
                if (bpmFormField.isShowFlowField()) {
                    json.put("showFlowField", true);
                }
                json.put("isFlowField", bpmFormField.getFlowField());
                jsonAry.add(json);
            }
            displayField = jsonAry.toString();
        }
        return displayField;

    }

    private Map<String, String> getDisplayFieldDesc(String displayField) throws IOException {
        if (StringUtil.isEmpty(displayField))
            return null;
        Map<String, String> map = new HashMap<String, String>();
        ArrayNode jsonAry = (ArrayNode) JsonUtil.toJsonNode(displayField);
        for (Object obj : jsonAry) {
            ObjectNode json = (ObjectNode) obj;
            String name = json.get("name").asText();
            String desc = json.get("desc").asText();
            map.put(name, desc);
        }
        return map;
    }

    private Map<String, String> getDisplayFieldRight(String displayField) throws IOException {
        if (StringUtil.isEmpty(displayField))
            return null;
        Map<String, String> map = new HashMap<String, String>();
        ArrayNode jsonAry = (ArrayNode) JsonUtil.toJsonNode(displayField);

        for (Object obj : jsonAry) {
            ObjectNode json = (ObjectNode) obj;
            String name = json.get("name").asText();
            ArrayNode right = (ArrayNode) json.get("right");
            map.put(name, right.toString());
        }
        return map;
    }

    private String getDefaultDisplayFieldRight() {
        ArrayNode array = JsonUtil.getMapper().createArrayNode();
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        json.put("type", "everyone");
        json.put("id", "");
        json.put("name", "");
        json.put("script", "");
        array.add(json);
        return array.toString();
    }

    @Override
    @Transactional
    public void save(FormDataTemplate bpmDataTemplate, boolean resetTemp) throws Exception {
        Integer bpmDataTemplateNum = getCountByAlias(bpmDataTemplate.getAlias());
        boolean flag1 = bpmDataTemplateNum > 0;//判断是否已存在数据
        boolean flag2 = StringUtil.isEmpty(bpmDataTemplate.getId());

        String templateHtml = generateTemplate(bpmDataTemplate);
        if (!flag1 && flag2) {//新
            bpmDataTemplate.setId(UniqueIdUtil.getSuid());
            bpmDataTemplate.setTemplateHtml(templateHtml);//每次保存都需要重新生成模板
            bpmDataTemplate.setCreateTime(LocalDateTime.now());
            this.create(bpmDataTemplate);
        } else {
            FormDataTemplate temp = getByAlias(bpmDataTemplate.getAlias());
            if (temp != null && !bpmDataTemplate.getId().equals(temp.getId())) {
                throw new BaseException("报表别名：" + bpmDataTemplate.getAlias() + "已存在，请输入其他别名！");
            }
            if (resetTemp) {//需要更新模板
                bpmDataTemplate.setTemplateHtml(templateHtml);
            } else {
                FormDataTemplate old = baseMapper.getByAlias(bpmDataTemplate.getAlias());
                bpmDataTemplate.setTemplateHtml(old.getTemplateHtml());
            }
            bpmDataTemplate.setUpdateTime(LocalDateTime.now());
            this.update(bpmDataTemplate);
        }
        if (StringUtil.isNotEmpty(bpmDataTemplate.getRemindSettingList())) {
            formDataTemplateExtendManager.save(bpmDataTemplate.getRemindSettingList(), bpmDataTemplate.getId());
        }
    }

    /**
     * 解析生成第一次的模板
     *
     * @param bpmDataTemplate
     * @return
     * @throws Exception
     */
    private String generateTemplate(FormDataTemplate bpmDataTemplate) throws Exception {

        FormTemplate bpmFormTemplate = formTemplateManager.getByTemplateAlias(bpmDataTemplate.getTemplateAlias());//获取需要第一次解释的模板
        List<FormField> fileds = formFieldManager.getByboDefId(bpmDataTemplate.getBoDefId()); // 获取主表字段
        // 是否有条件查询
        String conditionField = bpmDataTemplate.getConditionField();
        boolean hasCondition = hasCondition(conditionField);
        // 是否有功能按钮
        boolean hasManage = hasManage(bpmDataTemplate.getManageField());
        //合并查询处理
        String isIndistinct = bpmDataTemplate.getIsIndistinct();
        String conditionAllName = "";
        String conditionAllDesc = "请输入关键字  " + bpmDataTemplate.getConditionAllDesc();

        // 获取主键
        BoDef boDef = boDefService.getByAlias(bpmDataTemplate.getBoDefAlias());
        BoEnt boEnt = boDef.getBoEnt();
        if (hasCondition) {
            ArrayNode conditions = (ArrayNode) JsonUtil.toJsonNode(conditionField);
            for (JsonNode jsonNode : conditions) {
                ObjectNode condition = (ObjectNode) jsonNode;
                String qt = condition.get("qt").asText();
                String type = "";
                if (condition.hasNonNull("ty") && "date".equals(condition.get("ty").asText())) {
                    String field = ((boEnt.isExternal() ? "" : BoEnt.FIELD_PREFIX) + condition.get("name").asText()).toLowerCase();
                    BoAttribute attribute = boEnt.getAttrByField(field);
                    if (BeanUtils.isNotEmpty(attribute)) {
                        condition.put("format", attribute.getFormat());
                        if ("between".equals(qt)) {
                            type = "yyyy-MM-dd HH:mm:ss".equals(attribute.getFormat()) ? "datetimerange" : "daterange";
                        } else {
                            type = "yyyy-MM-dd HH:mm:ss".equals(attribute.getFormat()) ? "datetime" : "date";
                        }
                    }
                } else if (condition.hasNonNull("ct") && "date".equals(condition.get("ct").asText())) {//此处不好获取表单里面日期字符串的格式化配置，暂时使用年月日时分秒
                    condition.put("format", "yyyy-MM-dd HH:mm:ss");
                    type = "between".equals(qt) ? "datetimerange" : "datetime";
                }
                condition.put("ctrlType", type);
            }
            bpmDataTemplate.setConditionField(JsonUtil.toJson(conditions));
        }
        String[] conditionArr = bpmDataTemplate.getConditionAllName().split(",");
        for (int i = 0; i < conditionArr.length; i++) {
            if (boEnt.isExternal()) {
                conditionAllName += conditionArr[i] + ",";
            } else {
                conditionAllName += SQLConst.CUSTOMER_COLUMN_PREFIX + conditionArr[i] + ",";
            }
        }
        if (!"".equals(conditionAllName)) {
            conditionAllName = conditionAllName.substring(0, conditionAllName.length() - 1);
        }

        // 第一次解析模板
        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("bpmDataTemplate", bpmDataTemplate);
        map.put("hasCondition", hasCondition);
        map.put("hasManage", hasManage);
        map.put("pkField", boEnt.getPkKey().toLowerCase());
        map.put("colPrefix", boEnt.isExternal() ? "" : SQLConst.CUSTOMER_COLUMN_PREFIX);
        List<FormField> list = new ArrayList<>();
        for (int i = 0; i < fileds.size(); i++) {
            if ("textFixed".equals(fileds.get(i).getCtrlType())) {
                fileds.get(i).setDesc(fileds.get(i).getDesc().replaceAll("\"", "\'"));
            }
            list.add(fileds.get(i));
        }
        map.put("formatData", list);
        map.put("util", freeMakerUtil);
        map.put("isIndistinct", isIndistinct);
        map.put("conditionAllName", conditionAllName);
        map.put("conditionAllDesc", conditionAllDesc);

        Map<String, Object> filteringFieldMap = new HashMap<>();
        if (StringUtil.isNotEmpty(bpmDataTemplate.getFilteringField())) {
            ArrayNode arrayNode = (ArrayNode) JsonUtil.toJsonNode(bpmDataTemplate.getFilteringField());
            for (JsonNode jsonNode : arrayNode) {
                filteringFieldMap.put(jsonNode.get("name").asText(), jsonNode.get("formatterData"));
            }
        }
        map.put("filteringFieldMap", filteringFieldMap);

        Map<String, Object> sortFieldMap = new HashMap<>();
        if (StringUtil.isNotEmpty(bpmDataTemplate.getSortField())) {
            ArrayNode arrayNode = (ArrayNode) JsonUtil.toJsonNode(bpmDataTemplate.getSortField());
            for (JsonNode jsonNode : arrayNode) {
                sortFieldMap.put(jsonNode.get("name").asText(), jsonNode.get("sort").asText());
            }
        }
        map.put("sortFieldMap", sortFieldMap);

        if (BeanUtils.isEmpty(sortFieldMap)) {
            map.put("defaultAllSort", true);
        }
        String templateHtml = freemarkEngine.parseByStringTemplate(bpmFormTemplate.getHtml(), map);
        return templateHtml;

    }

    /**
     * 是否有管理
     *
     * @param manageField
     * @return
     * @throws IOException
     */
    private boolean hasManage(String manageField) throws IOException {
        if (StringUtil.isEmpty(manageField))
            return false;
        ArrayNode jsonAry = (ArrayNode) JsonUtil.toJsonNode(manageField);
        return jsonAry.size() > 0 ? true : false;
    }

    /**
     * 是否有条件
     *
     * @param conditionField
     * @return
     * @throws IOException
     */
    private boolean hasCondition(String conditionField) throws IOException {
        if (StringUtil.isEmpty(conditionField))
            return false;
        ArrayNode jsonAry = (ArrayNode) JsonUtil.toJsonNode(conditionField);
        return jsonAry.size() > 0 ? true : false;
    }

    private List<Map<String, Object>> dataFormatProcessing(List<Map<String, Object>> list, List<BoAttribute> columnList) throws Exception, Exception {
        List<Map<String, Object>> newlist = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : list) {
            for (BoAttribute column : columnList) {
                //处理oracle clob 字段
                Object object = map.get(column.getFieldName().toLowerCase());
                if (BeanUtils.isNotEmpty(object) && object instanceof Clob) {
                    Clob clob = (Clob) object;
                    String string = ClobToString(clob);
                    map.put(column.getFieldName(), string);
                    map.remove(column.getFieldName().toLowerCase());
                } else if ("date".equals(column.getDataType())) {
                    if (BeanUtils.isNotEmpty(map.get(column.getFieldName().toLowerCase()))) {

                        map.put(column.getFieldName(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(map.get(column.getFieldName().toLowerCase())));
                        map.remove(column.getFieldName().toLowerCase());
                    }
                } else {

                    map.put(column.getFieldName(), map.get(column.getFieldName().toLowerCase()));
                    map.remove(column.getFieldName().toLowerCase());
                }
            }
            newlist.add(map);
        }
        return newlist;
    }

    /**
     * 根据formKey获取业务表单数量。
     *
     * @param bpmDataTemplate
     * @return
     */
    public Integer getCountByAlias(FormDataTemplate bpmDataTemplate) {
        return baseMapper.getCountByAlias(bpmDataTemplate.getAlias());
    }

    /**
     * 根据表单key获取是否定义了数据模版。
     *
     * @param alias
     * @return
     */
    public Integer getCountByAlias(String alias) {
        return baseMapper.getCountByAlias(alias);
    }

    @Override
    public String getDisplay(String alias, Map<String, Object> params,
                             Map<String, Object> queryParams) throws Exception {
        Map<String, Set<String>> curProfiles = permssionCalc.getCurrentProfiles();
        Map<String, Object> model = new HashMap<String, Object>();

        //获取业务模板数据
        FormDataTemplate bpmDataTemplate = baseMapper.getByAlias(alias);

        params.put(FormDataTemplate.PARAMS_KEY_BOALIAS, bpmDataTemplate.getBoDefAlias());
        params.put(FormDataTemplate.PARAMS_KEY_FORM_KEY, bpmDataTemplate.getFormKey());
        params.put(FormDataTemplate.PARAMS_KEY_DEF_ID, BeanUtils.isEmpty(bpmDataTemplate.getDefId()) ? "" : bpmDataTemplate.getDefId());

        Map<String, Boolean> managePermission = getManagePermission(bpmDataTemplate.getManageField(), curProfiles);

        if (StringUtil.isEmpty(bpmDataTemplate.getDefId())) {
            managePermission.put(FormDataTemplate.MANAGE_TYPE_START_FLOW, false);
        }

        List<Map<String, String>> filters = getFilterPermission(bpmDataTemplate.getFilterField(), curProfiles);
        // actionUrl
        //model.put("actionUrl", getActionUrl(params));
        model.put("ctx", params.get(FormDataTemplate.PARAMS_KEY_CTX));
        model.put("bpmDataTemplate", bpmDataTemplate);
        // 当前字段的权限
        model.put("permission", getPermission(bpmDataTemplate.getDisplayField(), curProfiles));
        // 功能按钮的权限
        model.put("managePermission", managePermission);
        model.put("hasSub", StringUtil.isNotEmpty(getSubEntIds(bpmDataTemplate.getFormKey())) ? true : false);//当前是否有子表

        // 获取主键
        BoDef boDef = boDefService.getByAlias(bpmDataTemplate.getBoDefAlias());
        BoEnt boEnt = (BoEnt) boDef.getBoEnt();
        model.put("pkField", boEnt.getPkKey().toLowerCase());
        model.put("colPrefix", boEnt.isExternal() ? "" : SQLConst.CUSTOMER_COLUMN_PREFIX);
        model.put("filters", filters);
        JsonUtil jsonUtil = new JsonUtil();
        model.put("JsonUtil", jsonUtil);
        String templateHtml = bpmDataTemplate.getTemplateHtml();

        String html = freemarkEngine.parseByStringTemplate(templateHtml, model);

        return html;
    }

    private String getSubEntIds(String formKey) {
        try {
            List<BoEnt> list = formMetaManager.getChildrenByFormKey(formKey);
            if (BeanUtils.isNotEmpty(list)) {
                StringBuilder sql = new StringBuilder();
                boolean isInit = false;
                for (BoEnt boEnt : list) {
                    if (!isInit) {
                        isInit = true;
                    } else {
                        sql.append(",");
                    }
                    sql.append(boEnt.getId());
                }
                return sql.toString();
            }
        } catch (IOException e) {
        }
        return "";
    }

    /**
     * 获取当前用户有权限的过滤条件
     *
     * @param filterField
     * @param curProfiles
     * @return
     * @throws IOException
     */
    private List<Map<String, String>> getFilterPermission(String filterField,
                                                          Map<String, Set<String>> curProfiles) throws IOException {
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (StringUtil.isEmpty(filterField))
            return list;
        ArrayNode jsonAry = (ArrayNode) JsonUtil.toJsonNode(filterField);

        for (Object obj : jsonAry) {
            ObjectNode json = (ObjectNode) obj;
            ArrayNode rights = json.get("right").isArray() ? (ArrayNode) json.get("right") : (ArrayNode) JsonUtil.toJsonNode(json.get("right").asText());
            boolean hasRight = false;
            for (JsonNode permission : rights) {
                hasRight = permssionCalc.hasRight(permission.toString(), curProfiles);
                if (hasRight) {
                    break;
                }
            }
            if (hasRight) {
                Map<String, String> map = new HashMap<String, String>();
                map.put("name", JsonUtil.getString(json, "name", ""));
                map.put("filterKey", JsonUtil.getString(json, "key", ""));
                list.add(map);
            }
        }

        return list;
    }

    /**
     * 获取管理的权限
     *
     * @param manageField
     * @param currentMap
     * @return
     * @throws IOException
     */
    private Map<String, Boolean> getManagePermission(String manageField, Map<String, Set<String>> currentMap) throws IOException {
        if (StringUtil.isEmpty(manageField))
            return null;
        ArrayNode jsonAry = (ArrayNode) JsonUtil.toJsonNode(manageField);
        return getPermissionMap(jsonAry, currentMap);
    }

    /**
     * [{"desc":"新增","name":"add","right":[{"type":"everyone"}]},
     * {"desc":"编辑","name":"edit","right":[{"type":"everyone"}]},
     * {"desc":"删除","name":"del","right":[{"type":"everyone"}]},
     * {"desc":"明细","name":"detail","right":[{"type":"everyone"}]}]
     *
     * @param jsonAry
     * @param currentMap
     * @return
     * @throws IOException
     */
    private Map<String, Boolean> getPermissionMap(ArrayNode jsonAry,
                                                  Map<String, Set<String>> currentMap) throws IOException {
        Map<String, Boolean> map = new HashMap<String, Boolean>();
        if (BeanUtils.isEmpty(jsonAry) || jsonAry.size() < 1) {
            return map;
        }
        for (Object obj : jsonAry) {
            ObjectNode json = (ObjectNode) JsonUtil.toJsonNode(obj);
            String name = json.get("name").asText();
            String rightStr = json.get("right").textValue();
            ArrayNode rights = StringUtil.isEmpty(rightStr) ? (ArrayNode) json.get("right") : (ArrayNode) JsonUtil.toJsonNode(rightStr);
            boolean hasRight = false;
            for (JsonNode permission : rights) {
                hasRight = permssionCalc.hasRight(permission.toString(), currentMap);
                if (hasRight) {
                    map.put(name, hasRight);
                    break;
                }
            }
            map.put(name, hasRight);
        }
        return map;
    }

    /**
     * 获取字段的权限
     *
     * @param displayField
     * @param rightMap
     * @return
     * @throws IOException
     */
    private Map<String, Boolean> getPermission(String displayField, Map<String, Set<String>> rightMap) throws IOException {
        ArrayNode jsonAry = (ArrayNode) JsonUtil.toJsonNode(displayField);
        return getPermissionMap(jsonAry, rightMap);
    }

    @Override
    public Map<String, Object> getFormByFormKey(String formKey) {
        Map<String, Object> map = new HashMap<String, Object>();
        Form formModel = formManager.getMainByFormKey(formKey);
        if (formModel == null || StringUtil.isEmpty(formModel.getFormHtml())) {
            map.put("result", "formEmpty");
            return map;
        }
        map.put("form", formModel);
        map.put("result", true);
        return map;
    }

    @Override
    @Transactional
    public void boSave(ObjectNode jsonObject, String boAlias, String delDraftId) throws Exception {
        JsonNode jsonData = JsonUtil.toJsonNode(jsonObject.get(boAlias).toString());
        jsonData = transJSON(jsonData);
        BoData boData = BoUtil.transJSON(jsonData);
        BoDataHandler handler = boInstanceFactory.getBySaveType(BoConstants.SAVE_MODE_DB);
        BoDef boDef = boDefService.getByAlias(boAlias);
        BoEnt boEnt = boDef.getBoEnt();
        boData.setBoEnt(boEnt);
        boData.setBoDef(boDef);
        if (BeanUtils.isNotEmpty(jsonData.get("subMap"))) {
            handlerSubMap(boData, (ObjectNode) jsonData);
        }
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("boData", boData);
        //业务数据模板别名
        FormDataTemplate template = null;
        if (jsonObject.has("templateKey")) {
            String templateKey = jsonObject.get("templateKey").asText();
            template = getByAlias(templateKey);
            //判断是否有前置groovy脚本
            if (BeanUtils.isNotEmpty(template.getBeforeScript())) {
                groovyScriptEngine.execute(template.getBeforeScript(), param);
            }
        }

        List<BoResult> resultList = handler.save("", "", boData);
        if (BeanUtils.isNotEmpty(resultList)) {
            //添加修改记录
            handleBoResult(resultList, jsonObject);
        }
        String pk = StringUtil.isEmpty(boEnt.getPk()) ? "id_" : boEnt.getPk();
        if (jsonObject.has("formKey")) {
            String formKey = jsonObject.get("formKey").asText();
            String boDataId = "";
            if (jsonData.has(pk)) {
                boDataId = jsonData.get(pk).asText();
            } else {
                BoResult a = resultList.stream().filter(b -> "add".equals(b.getAction())).findAny().orElse(null);
                if (a != null) {
                    boDataId = a.getPk();
                }
            }
            List<FormDataTemplateExtend> list = formDataTemplateExtendManager.getDataTemplateExtendByFormKey(formKey);
            formRemindDataManager.deleteFormRemindDataByBoDataId(new QueryWrapper<FormRemindData>().eq("OPEM_ID", boDataId));
            List<FormRemindData> insertList = new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                FormDataTemplateExtend formDataTemplateExtend = list.get(i);
                String scriptJson = formDataTemplateExtend.getRule();
                if (StringUtil.isEmpty(scriptJson)) {
                    continue;
                }
                JsonNode node = JsonUtil.toJsonNode(scriptJson);
                String script = node.get("scriptStr").asText();
                boolean res = groovyScriptEngine.executeBoolean(Base64.getFromBase64(script), boData.getData());
                if (res) {//符合提醒条件
                    String typeObj = formDataTemplateExtend.getTypeObj();
                    String objId = formDataTemplateExtend.getObjId();
                    String content = formDataTemplateExtend.getContent();
                    String count = formDataTemplateExtend.getCount();
                    String refId = formDataTemplateExtend.getId();
                    if (typeObj.equals("script")) {
                        objId = boData.getData().get(objId) + "";
                        FormRemindData formRemindData = new FormRemindData();
                        formRemindData.setContent(content);
                        formRemindData.setCount(count);
                        formRemindData.setObjId(objId);
                        formRemindData.setTypeObj("user");
                        formRemindData.setOpemId(boDataId);
                        formRemindData.setSubject(formDataTemplateExtend.getSubject());
                        formRemindData.setOpemType(formDataTemplateExtend.getAlias());
                        formRemindData.setRefId(refId);
                        insertList.add(formRemindData);

                    } else {
                        String[] objIds = objId.split(",");
                        for (int j = 0; j < objIds.length; j++) {
                            FormRemindData formRemindData = new FormRemindData();
                            formRemindData.setContent(content);
                            formRemindData.setCount(count);
                            formRemindData.setObjId(objIds[j]);
                            formRemindData.setSubject(formDataTemplateExtend.getSubject());
                            formRemindData.setTypeObj(typeObj);
                            formRemindData.setOpemId(boDataId);
                            formRemindData.setOpemType(formDataTemplateExtend.getAlias());
                            formRemindData.setRefId(refId);
                            insertList.add(formRemindData);
                        }
                    }
                }
            }
            formRemindDataManager.saveBatch(insertList);
        }
        //删除草稿
        if (BeanUtils.isNotEmpty(delDraftId)) {
            dataTemplateDraftManager.remove(delDraftId);
        }
        //判断是否有后置groovy脚本
        if (BeanUtils.isNotEmpty(template) && BeanUtils.isNotEmpty(template.getAfterScript())) {
            groovyScriptEngine.execute(template.getAfterScript(), param);
        }
    }

    /**
     * 将JSON转成BoData
     *
     * @param jsonNode json格式数据
     * @return bo数据
     */
    public JsonNode transJSON(JsonNode jsonNode) {
        ObjectNode data = JsonUtil.getMapper().createObjectNode();
        Iterator<Entry<String, JsonNode>> fields = jsonNode.fields();
        while (fields.hasNext()) {
            Entry<String, JsonNode> next = fields.next();
            String key = next.getKey();
            JsonNode jNode = next.getValue();
            if (jNode.isArray()) {
                boolean isCheck = false;
                if (BeanUtils.isNotEmpty(jNode)) {
                    for (JsonNode fxk : jNode) {
                        //为复选框  复选框从前端传过来的是数组 不添加到子表中 过滤掉
                        if (!fxk.isObject()) {
                            isCheck = true;
                            break;
                        }
                    }
                }
                if (!isCheck && key.toString().indexOf("sub_") > -1) {
                    String tmp = key.toString().replaceFirst("sub_", "");
                    ObjectNode subNode = (ObjectNode) data.get("subMap");
                    if (BeanUtils.isEmpty(subNode)) {
                        subNode = JsonUtil.getMapper().createObjectNode();
                    }
                    subNode.set(tmp, jNode);
                    data.set("subMap", subNode);
                } else {
                    ((ObjectNode) data).set(key, jNode);
                }
            } else {
                ((ObjectNode) data).set(key, jNode);
            }
        }
        return data;
    }

    /**
     * 处理子表数据
     *
     * @param curData
     * @param boData
     * @throws JsonParseException
     * @throws JsonMappingException
     * @throws IOException
     */
    private void handlerSubMap(BoData curData, ObjectNode boData) throws JsonParseException, JsonMappingException, IOException {
        ObjectNode subMapNode = (ObjectNode) boData.get("subMap");
        Iterator<Entry<String, JsonNode>> fields = subMapNode.fields();
        while (fields.hasNext()) {
            Entry<String, JsonNode> next = fields.next();
            String key = next.getKey();
            JsonNode jNode = next.getValue();
            if (jNode.isArray()) {
                List<BoData> datas = new ArrayList<BoData>();
                for (JsonNode jsonNode : jNode) {
                    Iterator<Entry<String, JsonNode>> subFields = jsonNode.fields();
                    BoData data = new BoData();
                    Map<String, List<BoData>> sunBoDataMap = new HashMap<String, List<BoData>>();
                    while (subFields.hasNext()) {
                        Entry<String, JsonNode> subNext = subFields.next();
                        String subkey = subNext.getKey();
                        data.set(subkey, subNext.getValue());
                        if (subkey.startsWith("sub_") && BeanUtils.isNotEmpty(subNext.getValue())) {
                            JsonNode sunNode = subNext.getValue();
                            List<BoData> sunBoDatas = new ArrayList<BoData>();
                            for (JsonNode itemNode : sunNode) {
                                BoData sunData = new BoData();
                                Iterator<Entry<String, JsonNode>> sunFields = itemNode.fields();
                                while (sunFields.hasNext()) {
                                    Entry<String, JsonNode> sunNext = sunFields.next();
                                    String sunkey = sunNext.getKey();
                                    sunData.set(sunkey, sunNext.getValue());
                                }
                                BoData bb = JsonUtil.toBean(JsonUtil.toJson(sunData), BoData.class);
                                sunBoDatas.add(bb);
                            }
                            sunBoDataMap.put(subkey, sunBoDatas);
                        }
                    }
                    //这里不通过json转bean的话不能取到正确属性类型的值，比如数字的取到的是转string后的值
                    BoData aa = JsonUtil.toBean(JsonUtil.toJson(data), BoData.class);
                    if (!sunBoDataMap.isEmpty()) {
                        for (String sunKey : sunBoDataMap.keySet()) {
                            aa.setSubList(sunKey, sunBoDataMap.get(sunKey));
                        }
                    }
                    datas.add(aa);
                }
                curData.setSubList(key, datas);
            }
        }
    }

    @Override
    @Transactional
    public void boSaveDraft(FormDataTemplateDraft dataTemplateDraft) {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty(dataTemplateDraft.getId())) {
            FormDataTemplate dataTemplate = this.getByAlias(dataTemplateDraft.getTempAlias());
            String currentTime = DateUtil.getCurrentTime();
            dataTemplateDraft.setTitle(dataTemplate.getName() + "_" + currentTime);
            dataTemplateDraft.setId(UniqueIdUtil.getSuid());
            dataTemplateDraft.setCreateBy(currentUser.getUserId());
            dataTemplateDraft.setCreateTime(LocalDateTime.now());
            dataTemplateDraftManager.create(dataTemplateDraft);
        } else {
            dataTemplateDraftManager.update(dataTemplateDraft);
        }
    }

    private void handleBoResult(List<BoResult> resultList, ObjectNode data) throws Exception {
        List<ObjectNode> list = new ArrayList<ObjectNode>();
        for (BoResult result : resultList) {
            list.add((ObjectNode) JsonUtil.toJsonNode(result));
        }
        Map<String, Object> params = new HashMap<String, Object>();
        ArrayNode boResult = JsonUtil.listToArrayNode(list);
        params.put("boResult", boResult);
        params.put("data", data);
        workflowFeignService.handleBoDateModify(params);
    }

    @Override
    @Transactional
    public void boDel(String[] ids, String boAlias) {
        BoDataHandler handler = boInstanceFactory.getBySaveType(BoConstants.SAVE_MODE_DB);
        handler.removeBoData(boAlias, ids);
    }

    @Override
    public List<FormDataTemplate> getTemplateByFormKey(String formKey) {
        return baseMapper.getByFormKey(formKey);
    }

    @Override
    public FormDataTemplate getExportDisplay(String alias) throws IOException {
        FormDataTemplate bpmDataTemplate = baseMapper.getByAlias(alias);
        if (BeanUtils.isNotEmpty(bpmDataTemplate)) {
            ArrayNode jsonAry = (ArrayNode) JsonUtil.toJsonNode(bpmDataTemplate.getDisplayField());
            Map<String, Set<String>> curProfiles = permssionCalc.getCurrentProfiles();
            if (BeanUtils.isNotEmpty(jsonAry) && jsonAry.size() > 0) {
                ArrayNode newjsonAry = JsonUtil.getMapper().createArrayNode();
                for (Object obj : jsonAry) {
                    ObjectNode json = (ObjectNode) obj;
                    ArrayNode rights = (ArrayNode) JsonUtil.toJsonNode(json.get("right").asText());
                    boolean hasRight = false;
                    for (JsonNode permission : rights) {
                        hasRight = permssionCalc.hasRight(permission.toString(), curProfiles);
                        break;
                    }
                    json.put("permission", hasRight);
                    newjsonAry.add(json);
                }
                bpmDataTemplate.setDisplayField(newjsonAry.toString());
            }
        }
        return bpmDataTemplate;
    }

    @Override
    public String getFilterSql(String filterField, String dsName, Map<String, Object> param) throws IOException {
        StringBuffer sb = new StringBuffer();
        String sql = "";
        Map<String, Set<String>> curProfiles = permssionCalc.getCurrentProfiles();
        List<Map<String, String>> filters = getFilterPermission(filterField, curProfiles);
        ArrayNode jsonArray = (ArrayNode) JsonUtil.toJsonNode(filterField);
        ObjectNode json = JsonUtil.arrayToObject(jsonArray, "key");
        if (BeanUtils.isEmpty(filters)) return sb.toString();
        for (Map<String, String> map : filters) {
            ObjectNode jsonObject = (ObjectNode) json.get(map.get("filterKey"));
            int type = JsonUtil.getInt(jsonObject, "type", 0);
            switch (type) {
                case 1:// 条件脚本
                    String dbType = databaseContext.getDbTypeByAlias(dsName);
                    sql = FilterJsonStructUtil.getSql(JsonUtil.getString(jsonObject, "condition"), dbType);
                    break;
                case 3:// 追加SQL
                    String filterSql = jsonObject.get("condition").asText();
                    filterSql = filterSql.replaceAll("\\n", "");
                    sql = executeScript(filterSql, param);
                    break;
                case 4://数据权限
                    sql = getDataPermissionSql(jsonObject.get("condition").asText(), "");
                    break;
            }
            if (StringUtil.isNotEmpty(sql)) {
                if (4 != type && !sql.trim().toUpperCase().startsWith("AND")) {
                    sb.append(" AND ");
                }
                sb.append(sql);
            }
        }
        return sb.toString();
    }

    @Override
    public String getFilterSql(String filterField, String dsName, Map<String, Object> param, BoEnt boEnt) throws IOException {
        StringBuffer sb = new StringBuffer();
        String sql = "";
        Map<String, Set<String>> curProfiles = permssionCalc.getCurrentProfiles();
        List<Map<String, String>> filters = getFilterPermission(filterField, curProfiles);
        ArrayNode jsonArray = (ArrayNode) JsonUtil.toJsonNode(filterField);
        ObjectNode json = JsonUtil.arrayToObject(jsonArray, "key");
        if (BeanUtils.isEmpty(filters)) return sb.toString();
        for (Map<String, String> map : filters) {
            ObjectNode jsonObject = (ObjectNode) json.get(map.get("filterKey"));
            int type = JsonUtil.getInt(jsonObject, "type", 0);
            switch (type) {
                case 1:// 条件脚本
                    String dbType = databaseContext.getDbTypeByAlias(dsName);
                    if (SQLConst.DB_ORACLE.equals(dbType)) {
                        String condition = JsonUtil.getString(jsonObject, "condition");
                        ArrayNode array = (ArrayNode) JsonUtil.toJsonNode(condition);
                        for (int i = 0; i < array.size(); i++) {
                            String flowvarKey = JsonUtil.getString(array.get(i), "flowvarKey");
                            for (BoAttribute attribute : boEnt.getBoAttrList()) {
                                if (attribute.getName().equals(flowvarKey.replace(BoEnt.FIELD_PREFIX, ""))) {
                                    if (Column.COLUMN_TYPE_CLOB.equals(attribute.getDataType())) {
                                        ObjectNode objectNode = (ObjectNode) array.get(i);
                                        objectNode.put("flowvarKey", "TO_CHAR(" + flowvarKey + ")");
                                        array.set(i, objectNode);
                                    }
                                }
                            }
                        }
                        sql = FilterJsonStructUtil.getSql(JsonUtil.toJson(array), dbType);
                    } else {
                        sql = FilterJsonStructUtil.getSql(JsonUtil.getString(jsonObject, "condition"), dbType);
                    }

                    break;
                case 3:// 追加SQL
                    String filterSql = jsonObject.get("condition").asText();
                    filterSql = filterSql.replaceAll("\\n", "  ");
                    sql = executeScript(filterSql, param);
                    break;
                case 4://数据权限
                    sql = getDataPermissionSql(jsonObject.get("condition").asText(), "");
                    break;
            }
            if (StringUtil.isNotEmpty(sql)) {
                if (sb.length() == 0) {
                    sb.append(" AND (( ");
                } else {
                    sb.append(" OR (");
                }
                sb.append(sql);
                sb.append(" ) ");
            }
        }
        if (sb.length() > 0) {
            sb.append(" ) ");
        }
        return sb.toString();
    }

    @Override
    public String getDataPermissionSql(String dataPermission, String fieldPre) throws IOException {
        StringBuffer sb = new StringBuffer();
        if (StringUtil.isNotEmpty(dataPermission)) {
            ArrayNode permissionArrayJson = (ArrayNode) JsonUtil.toJsonNode(dataPermission);
            Set<String> orgIds = new HashSet<String>();
            IUser currentUser = ContextUtil.getCurrentUser();
            //  获取数据权限配置 从缓存中获取
            for (JsonNode node : permissionArrayJson) {
                if (BeanUtils.isNotEmpty(node.get("field"))) {
                    if (LOGIN_USER.equals(node.get("type").asText())) {
                        if (sb.length() > 0) {
                            sb.append(" AND ");
                        }
                        sb.append(fieldPre + node.get("field").asText() + "='" + currentUser.getUserId() + "'");
                    } else if (LOGIN_USER_ORGS.equals(node.get("type").asText())) {
                        String currentUserOrgIds = currentUser.getAttrbuite("CURRENT_USER_ORGIDS");
                        if (StringUtil.isNotEmpty(currentUserOrgIds)) {
                            if (sb.length() > 0) {
                                sb.append(" AND ");
                            }
                            String[] oids = currentUserOrgIds.split(",");
                            Set<String> oidSet = new HashSet<String>(Arrays.asList(oids));
                            String inSql = StringUtil.convertListToSingleQuotesString(oidSet);
                            sb.append(fieldPre + node.get("field").asText() + " in (" + inSql + ")");
                            orgIds.addAll(oidSet);
                        }
                    } else if (LOGIN_USER_SUB_ORGS.equals(node.get("type").asText())) {
                        if (sb.length() > 0) {
                            sb.append(" AND ");
                        }
                        String currentUserSubOrgIds = StringUtil.isNotEmpty(AuthenticationUtil.getCurrentUserSubOrgIds()) ? AuthenticationUtil.getCurrentUserSubOrgIds() : "";
                        String currentUserOrgIds = StringUtil.isNotEmpty(AuthenticationUtil.getCurrentUserOrgIds()) ? AuthenticationUtil.getCurrentUserOrgIds() : "";
                        currentUserSubOrgIds += "," + currentUserOrgIds;
                        String[] oids = new String[]{};
                        if (StringUtil.isNotEmpty(currentUserSubOrgIds)) {
                            oids = currentUserSubOrgIds.split(",");
                        }
                        if (oids.length == 0) {
                            oids = new String[]{"-1"};
                        }
                        Set<String> oidSet = new HashSet<String>(Arrays.asList(oids));
                        String inSql = StringUtil.convertListToSingleQuotesString(oidSet);
                        sb.append(fieldPre + node.get("field").asText() + " in (" + inSql + ")");
                        orgIds.addAll(oidSet);
                    } else if (CUSTOM_ORGS.equals(node.get("type").asText())) {
                        if (sb.length() > 0) {
                            sb.append(" AND ");
                        }
                        ArrayNode tmpArray = (ArrayNode) node.get("orgs");
                        for (JsonNode tmpJsonNode : tmpArray) {
                            orgIds.add(tmpJsonNode.get("id").asText());
                        }
                        String inSql = StringUtil.convertListToSingleQuotesString(orgIds);
                        sb.append(fieldPre + node.get("field").asText() + " in (" + inSql + ")");
                    }
                }
            }
        }
        return sb.toString();
    }

    /**
     * 字符串的常量
     *
     * @param script
     * @return String
     * @throws
     * @since 1.0.0
     */
    private String executeScript(String script, Map<String, Object> param) {
        Map<String, Object> vars = new HashMap<String, Object>();
        vars.put("param", param);
        vars.putAll(param);
        String str = groovyScriptEngine.executeString(replaceVar(script), vars);
        return str;
    }

    private String replaceVar(String str) {
        //当前用户id
        @SuppressWarnings("unchecked")
        List<IContextVar> comVarList = (List<IContextVar>) AppUtil.getBean("queryViewComVarList");
        for (IContextVar c : comVarList) {
            str = str.replace("[" + c.getAlias() + "]", c.getValue());
        }
        return "return \"" + str + "\" ;";
    }

    @Override
    public Set<String> getAllFormKeys() {
        Set<String> formSets = new HashSet<String>();
        List<String> formKeys = baseMapper.getAllFormKeys();
        if (BeanUtils.isNotEmpty(formKeys)) {
            formSets = new HashSet<String>(formKeys);
        }
        return formSets;
    }

    @Override
    @Transactional
    public void importData(List<MultipartFile> files, String refId, String alias) throws Exception {
        Iterator<MultipartFile> it = files.iterator();
        while (it.hasNext()) {
            MultipartFile file = it.next();
            List<Map<String, String>> rows = ExcelUtil.ImportDate(file);
            BoEnt boEnt = boEntManager.getByName(alias);
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(boEnt.getDsName() == null ? DataSourceConsts.LOCAL_DATASOURCE : boEnt.getDsName());
            String dbType = databaseContext.getDbType();
            boolean isPgSql = SQLConst.DB_POSTGRESQL.equals(dbType);
            boolean isOracle = SQLConst.DB_ORACLE.equals(dbType) || SQLConst.DB_DM.equals(dbType);
            for (Map<String, String> row : rows) {
                int i = 0;
                StringBuilder excuteSql = preSql(boEnt);
                excuteSql.append(UniqueIdUtil.getSuid() + ",");
                excuteSql.append(refId);
                for (Entry<String, String> map : row.entrySet()) {
                    String dataType = ((BoAttribute) boEnt.getColumnList().get(i++)).getDataType();
                    //如果是pgsql，日期类型也要加单引号
                    if (Column.COLUMN_TYPE_VARCHAR.equals(dataType) || (isOracle && Column.COLUMN_TYPE_CLOB.equals(dataType))) {
                        excuteSql.append(",'" + map.getValue() + "'");
                    } else if (isPgSql && Column.COLUMN_TYPE_DATE.equals(dataType)) {
                        if (StringUtil.isNotEmpty(map.getValue())) {
                            excuteSql.append(",'" + map.getValue() + "'");
                        } else {
                            excuteSql.append(",null");
                        }
                    } else if (isOracle && Column.COLUMN_TYPE_DATE.equals(dataType)) {
                        excuteSql.append(",TO_DATE('" + map.getValue() + "','yyyy-MM-dd HH24:mi:ss')");
                    } else if (Column.COLUMN_TYPE_NUMBER.equals(dataType) || Column.COLUMN_TYPE_INT.equals(dataType)) {
                        excuteSql.append("," + map.getValue());
                    } else {
                        if (StringUtil.isNotEmpty(map.getValue())) {
                            excuteSql.append(",'" + map.getValue() + "'");
                        } else {
                            excuteSql.append(",null");
                        }
                    }
                }
                excuteSql.append(",0)");
                template.execute(excuteSql.toString());

            }
        }
    }

    @SuppressWarnings("unchecked")
    @Override
    @Transactional
    public void importMain(List<MultipartFile> files, String alias) throws Exception {
        FormDataTemplate template = this.getByAlias(alias);
        BoDef boDef = this.boDefService.getByDefId(template.getBoDefId());
        BoEnt boEnt = boDef.getBoEnt();
        Iterator<MultipartFile> it = files.iterator();
        ArrayNode displays = (ArrayNode) JsonUtil.toJsonNode(template.getDisplayField());
        Map<String, String> nameFieldMap = new HashMap<String, String>();
        for (JsonNode field : displays) {//这里同注释的会被覆盖，所以要导入导出的不要出现相同的列注释
            nameFieldMap.put(field.get("desc").asText(), field.get("name").asText());
        }
        while (it.hasNext()) {
            MultipartFile file = it.next();
            List<Map<String, String>> rows = ExcelUtil.ImportDate(file);
            JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(boEnt.getDsName() == null ? DataSourceConsts.LOCAL_DATASOURCE : boEnt.getDsName());
            for (Map<String, String> row : rows) {
                StringBuffer sql = new StringBuffer("insert into ");

                List<String> fields = new ArrayList<String>();
                List<String> values = new ArrayList<String>();
                for (Entry<String, String> map : row.entrySet()) {
                    if ("主键".equals(map.getKey())) {
                        fields.add(boEnt.getPkKey());
                        if (BeanUtils.isNotEmpty(row.get("主键"))) {
                            values.add("'" + row.get("主键") + "'");
                        } else {
                            values.add(UniqueIdUtil.getSuid());
                        }
                    } else {
                        //excel单元格有值才去拼接sql
                        if (BeanUtils.isNotEmpty(map.getValue())) {
                            String key = map.getKey();
                            String field = this.getFieldName(key, boEnt.getColumnList(), nameFieldMap.get(key));
                            fields.add(field);
                            String dataType = this.getDataType(key, boEnt.getColumnList(), nameFieldMap.get(key));
                            if ("number".equals(dataType)) {
                                values.add(map.getValue());
                            } else {
                                values.add("'" + map.getValue() + "'");
                            }
                        }
                    }
                }
                //判断如果excel中无[主键]列，则补充完整
                if (!fields.contains(boEnt.getPkKey())) {
                    fields.add(boEnt.getPkKey());
                    values.add(UniqueIdUtil.getSuid());
                }
                //加入额外的两个字段
                fields.add(BoEnt.FK_NAME);
                values.add("0");
                fields.add("F_form_data_rev_");
                values.add("0");

                sql.append(boEnt.getTableName());
                sql.append("(" + String.join(",", fields) + ")");
                sql.append(" values ");
                sql.append("(" + String.join(",", values) + ")");

                jdbcTemplate.execute(sql.toString());
            }
        }
    }

    private String getFieldName(String key, List<BoAttribute> columnList, String fieldName) {
        for (BoAttribute boAtt : columnList) {
            if (boAtt.getDesc().equals(key) || boAtt.getName().equals(fieldName)) {
                return boAtt.getFieldName();
            }
        }
        return "";
    }

    private String getDataType(String key, List<BoAttribute> columnList, String fieldName) {
        for (BoAttribute boAtt : columnList) {
            if (boAtt.getDesc().equals(key) || boAtt.getName().equals(fieldName)) {
                return boAtt.getDataType();
            }
        }
        return "";
    }

    @Override
    public Map<String, Object> getFormData(String formKey, String boAlias, String id, String action, String recordId, String dataKey) throws Exception {
        int type = convert2Type(action);
        Map<String, Object> map = getFormByFormKey(formKey);
        if ("formEmpty".equals(map.get("result"))) {
            return map;
        }
        // 表单权限
        JsonNode permission = bpmFormRightManager.getPermission(formKey, dataKey, type);
        map.put("permission", permission);
        // 表单数据
        List<BoData> boDatas = new ArrayList<BoData>();
        if (StringUtil.isNotEmpty(id)) {
            //表单修改记录数据
            if (StringUtil.isNotEmpty(recordId)) {
                ObjectNode record = workflowFeignService.getModifyById(recordId);
                if (BeanUtils.isNotEmpty(record)) {
                    if (BeanUtils.isNotEmpty(record.get("data"))) {
                        String data = record.get("data").asText();
                        if (StringUtil.isNotEmpty(data)) {
                            JsonNode formData = JsonUtil.toJsonNode(data);
                            map.put("permission", permission);
                            map.put("data", formData);
                            return map;
                        }
                    }
                }
            }
            // 获取编辑数据
            if (permission.hasNonNull("subRowAuth")) {
                FormContextThreadUtil.putCommonVars("subRowAuthJosn", JsonUtil.toJson(permission.get("subRowAuth")));
            }
            BoData boData = boDataHandler.getById(id, boAlias);
            if (StringUtil.isEmpty(boData.getBoDefAlias())) {
                boData.setBoDefAlias(boData.getBoDef().getAlias());
            }
            boDatas = Arrays.asList(boData);
        } else {
            for (String code : Arrays.asList(boAlias)) {
                BoData boData = formService.getBodataByDefCode("database", code);
                if (StringUtil.isEmpty(boData.getBoDefAlias())) {
                    boData.setBoDefAlias(boData.getBoDef().getAlias());
                }
                if (BeanUtils.isNotEmpty(boData)) {
                    boDatas.add(boData);
                }
            }
        }
        Set<String> set = new HashSet<>();
        boDatas.forEach(item -> {
            for (String subKey : item.getSubMap().keySet()) {
                set.add(subKey);
                Map<String, Object> sunInitData = item.getInitDataMap().get(subKey);//孙表initData
                Object initData = sunInitData.get("initData");
                if (BeanUtils.isNotEmpty(initData) && initData instanceof HashMap) {
                    for (String o : ((HashMap<String, Object>) initData).keySet()) {
                        set.add(o);
                    }
                }

            }
        });
        JsonNode object = BoUtil.hanlerData(boDatas);
        // 表单数据
        map.put("data", object);
        //处理多建模有子表 表单列表点新增和编辑报错
        ObjectNode table = (ObjectNode) permission.get("table");
        if (BeanUtils.isNotEmpty(table)) {
            Iterator<String> keyIterator = table.fieldNames();
            while (keyIterator.hasNext()) {
                String key = keyIterator.next();
                if (!set.contains(key)) {
                    ((ObjectNode) table.get(key)).put("hidden", true);
                }

            }
        }
        map.put("permission", permission);

        return map;
    }

    public Integer convert2Type(String action) {
        if ("add".equals(action)) {
            return 3;
        } else if ("edit".equals(action)) {
            return 4;
        } else if ("get".equals(action)) {
            return 5;
        }
        return 0;
    }

    @Override
    public Map<String, Object> getTempDraftData(String draftId) throws IOException {
        FormDataTemplateDraft formDataTemplateDraft = dataTemplateDraftManager.get(draftId);
        FormDataTemplate formDataTemplate = this.getByAlias(formDataTemplateDraft.getTempAlias());

        Map<String, Object> map = getFormByFormKey(formDataTemplate.getFormKey());
        if ("formEmpty".equals(map.get("result"))) {
            return map;
        }
        // 表单权限
        map.put("permission", bpmFormRightManager.getPermission(formDataTemplate.getFormKey(), "", "", "", 1));
        // 表单数据
        JsonNode object = JsonUtil.toJsonNode(formDataTemplateDraft.getDataJson());
        // 表单数据
        map.put("data", object);
        map.put("draft", formDataTemplateDraft);
        return map;
    }

    @Override
    public void exportData(HttpServletResponse response, String formKey, String getType, String filterKey, String expField, QueryFilter queryFilter) throws Exception {
        FormDataTemplate template = getByAlias(formKey);
        getType = StringUtil.isEmpty(getType) ? "getType" : getType;
        PageBean page = new PageBean(1, PageBean.WITHOUT_PAGE);
        if ("page".equals(getType)) {
            if (BeanUtils.isNotEmpty(queryFilter.getPageBean())) {
                page.setPage(queryFilter.getPageBean().getPage());
                page.setPageSize(queryFilter.getPageBean().getPageSize());
            }
        }
        expField = Base64.getFromBase64(expField);
        queryFilter.setPageBean(page);
        filterKey = StringUtil.isNotEmpty(filterKey) ? filterKey : "";
        DataTemplateQueryVo vo = new DataTemplateQueryVo();
        vo.setTemplateId(template.getId());
        vo.setQueryFilter(queryFilter);
        PageList<Map<String, Object>> pageList = getList(template, vo);
        // 拼装exprotMaps
        Map<String, String> exportMaps = new LinkedHashMap<String, String>();
        ArrayNode formField = (ArrayNode) JsonUtil.toJsonNode(template.getFormField());
        ObjectNode showJO = JsonUtil.getMapper().createObjectNode();
        ArrayNode displayField = (ArrayNode) JsonUtil.toJsonNode(template.getDisplayField());
        displayField.forEach(obj -> {
            showJO.put(obj.get("name").asText(), obj.get("desc").asText());
        });
        formField.forEach(obj -> {//导出已BO实体注释为准 不然导入有问题
            showJO.put(obj.get("name").asText(), obj.get("desc").asText());
        });
        for (String str : expField.split(",")) {
            exportMaps.put(str, showJO.get(str).asText());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel(template.getName(), 24, exportMaps, pageList.getRows());
        ExcelUtil.downloadExcel(book, template.getName(), response);
    }

    @Override
    @SuppressWarnings("unchecked")
    public void downloadMainTempFile(HttpServletResponse response, String alias) throws Exception {
        FormDataTemplate template = this.getByAlias(alias);

        BoDef boDef = this.boDefService.getByDefId(template.getBoDefId());
        BoEnt boEnt = boDef.getBoEnt();
        Map<String, String> exportMaps = new LinkedHashMap<String, String>();
        //加入主键列
        //exportMaps.put(boEnt.getPkKey(), "主键");

        List<BoAttribute> boAttrList = boEnt.getColumnList();
        for (BoAttribute boAttr : boAttrList) {
            exportMaps.put(boAttr.getName(), boAttr.getDesc());
        }
        // 拼装exprotMaps
        HSSFWorkbook book = ExcelUtil.exportExcel(template.getName(), 24, exportMaps, new ArrayList<>(), 1);

        ExcelUtil.downloadExcel(book, template.getName() + "_导入模板", response);
    }

    @Override
    public PageList getList(FormDataTemplate template, DataTemplateQueryVo dataTemplateQueryVo) throws Exception {
        PageList<Map<String, Object>> returnData = new PageList<Map<String, Object>>();
        String dbType = SQLUtil.getDbType();
        QueryFilter queryFilter = dataTemplateQueryVo.getQueryFilter();
        WorkflowFeignService service = AppUtil.getBean(WorkflowFeignService.class);
        List<Map<String, Object>> flowBpmList = null;
        Map<String, Object> flowFields = new LinkedHashMap<String, Object>();
        String flowQuery = "";
        if (template.getNeedPage() == 1 && BeanUtils.isEmpty(queryFilter.getPageBean())) {
            queryFilter.setPageBean(new PageBean(1, 30, true));
        }
        returnData.setRows(new ArrayList<Map<String, Object>>());

        // todo 查询关联主表下的数据视图数据 前端新增该数据视图数据时未添加关联字段 refid 数据，导致无法获取数据
        //如果传入了外键的值
//		if(StringUtil.isNotEmpty(dataTemplateQueryVo.getRefIdValue())) {
//			queryFilter.addFilter(BoEnt.FK_NAME, dataTemplateQueryVo.getRefIdValue(), QueryOP.EQUAL);
//		}
        BoDef boDef = boDefService.getByAlias(template.getBoDefAlias());
        BoEnt boEnt = (BoEnt) boDef.getBoEnt();
        //数据视图控件查询
        if (BeanUtils.isNotEmpty(dataTemplateQueryVo.getSelectList())) {
            List<SelectParam> selectList = dataTemplateQueryVo.getSelectList();
            for (SelectParam param : selectList) {
                String fieldName = boEnt.getFieldPrefix() + param.getBindSelectd();
                if (StringUtil.isEmpty(param.getSelectValue())) {
                    returnData.setPage(1);
                    if (template.getNeedPage() == 1) {
                        returnData.setPageSize(template.getPageSize());
                    } else {
                        returnData.setPageSize(-1);
                    }
                    return returnData;
                }
                queryFilter.addFilter(fieldName, param.getSelectValue(), QueryOP.EQUAL);
            }
        }

        //处理PGSQL下的日期类型
        if (SQLConst.DB_POSTGRESQL.equals(dbType)) {
            List<BoAttribute> boAttrList = boEnt.getBoAttrList();
            for (Object query : queryFilter.getQuerys()) {
                if (query.getClass().isAssignableFrom(QueryField.class)) {
                    QueryField queryField = (QueryField) query;
                    String property = queryField.getProperty();
                    for (BoAttribute boAttribute : boAttrList) {
                        if ((boEnt.getFieldPrefix() + boAttribute.getName()).equals(property) &&
                                Column.COLUMN_TYPE_DATE.equals(boAttribute.getDataType()) &&
                                QueryOP.BETWEEN.equals(queryField.getOperation()) &&
                                queryField.getValue().getClass() == ArrayList.class) {
                            ArrayList<String> value = (ArrayList<String>) queryField.getValue();
                            ArrayList<Date> newVal = new ArrayList<>();
                            for (int i = 0; i < value.size(); i++) {
                                if (StringUtil.isNotEmpty(value.get(i))) {
                                    newVal.add(DateFormatUtil.parseDate(value.get(i), "yyyy-MM-dd HH:mm:ss"));
                                } else {
                                    newVal.add(null);
                                }
                            }
                            queryField.setValue(newVal);
                        } else if ((boEnt.getFieldPrefix() + boAttribute.getName()).equals(property) &&
                                Column.COLUMN_TYPE_DATE.equals(boAttribute.getDataType()) &&
                                queryField.getValue().getClass() != ArrayList.class &&
                                StringUtil.isNotEmpty((String) queryField.getValue())) {
                            queryField.setValue(DateFormatUtil.parseDate((String) queryField.getValue(), "yyyy-MM-dd HH:mm:ss"));
                        }
                    }
                }
            }
        }

        //过滤流程字段查询
        QueryFilter flowQueryFilter = QueryFilter.build();
        boolean isFlowBpmField = false;

        //处理ORACLE的clob类型
        if (SQLConst.DB_ORACLE.equals(dbType) || SQLConst.DB_DM.equals(dbType)) {
            for (BoAttribute boAttribute : boEnt.getBoAttrList()) {
                if (Column.COLUMN_TYPE_CLOB.equals(boAttribute.getDataType()) && StringUtil.isNotEmpty(boAttribute.getName())) {
                    List<QueryField> querys = queryFilter.getQuerys();
                    for (QueryField query : querys) {
                        if ((boEnt.getFieldPrefix() + boAttribute.getName()).equals(query.getProperty())) {
                            query.setProperty("TO_CHAR(" + query.getProperty() + ")");
                        }
                    }
                } else if (Column.COLUMN_TYPE_DATE.equals(boAttribute.getDataType()) && StringUtil.isNotEmpty(boAttribute.getName())) {
                    List<QueryField> querys = queryFilter.getQuerys();
                    for (QueryField query : querys) {
                        if ((boEnt.getFieldPrefix() + boAttribute.getName()).equals(query.getProperty()) && String.class == query.getValue().getClass()) {
                            query.setValue(DateFormatUtil.parse((String) query.getValue(), boAttribute.getFormat()));
                        }
                    }
                }
            }
        }

        Iterator<QueryField> it = queryFilter.getQuerys().iterator();
        while (it.hasNext()) {
            QueryField flowObj = it.next();
            if (ArrayUtils.contains(flowField, flowObj.getProperty())) {
                if (flowObj.getValue() != null) {
                    isFlowBpmField = true;

                    String flowProperty = flowObj.getProperty().substring(6);
                    flowQueryFilter.addFilter(flowProperty, flowObj.getValue(), flowObj.getOperation());
                    it.remove();
                } else {
                    it.remove();
                }

            }
            //过滤树作为查询条件的时候,需要判断是否是外部表,然后拼接f_
            String property = flowObj.getProperty();
            if (property.startsWith("$TREE$")) {
                String newproperty = property;
                //判断当前是否是外部表
                if (boEnt.getIsExternal() == 0) {
                    newproperty = property.replaceFirst("\\$TREE\\$", "F_");
                } else {
                    newproperty = property.replaceFirst("\\$TREE\\$", "");
                }
                flowObj.setProperty(newproperty);
            }

        }
        //添加流程定义查询
        if (StringUtil.isNotEmpty(template.getDefId())) {
            flowQueryFilter.addFilter("proc_def_key_", template.getDefId(), QueryOP.EQUAL);
        }
        PageBean pageBean = new PageBean(1, PageBean.WITHOUT_PAGE);
        //
        if (isFlowBpmField) {//流程字段查询
            flowQueryFilter.setPageBean(pageBean);
            flowBpmList = service.getFlowFieldList(flowQueryFilter);
            if (BeanUtils.isNotEmpty(flowBpmList)) {
                for (Map<String, Object> oNode : flowBpmList) {
                    //添加查询字段信息
                    String id = oNode.get("id_").toString();
                    flowQuery = flowQuery + id + ",";

                    flowFields.put(id, oNode);
                }
                queryFilter.addFilter("ID_", flowQuery, QueryOP.IN);
            } else {
                returnData.setPage(1);
                if (template.getNeedPage() == 1) {
                    returnData.setPageSize(template.getPageSize());
                } else {
                    returnData.setPageSize(PageBean.WITHOUT_PAGE);
                }

                return returnData;
            }
        } else {//表单字段查询
            flowQueryFilter.setPageBean(pageBean);
            flowBpmList = service.getFlowFieldList(flowQueryFilter);
            if (BeanUtils.isNotEmpty(flowBpmList)) {
                for (Map<String, Object> oNode : flowBpmList) {
                    //添加查询字段信息
                    String id = oNode.get("id_").toString();

                    flowFields.put(id, oNode);
                }
            }
        }

        Map<String, Object> params = queryFilter.getParams();
        String dsName = boEnt.getDsName();
        if (StringUtil.isEmpty(dsName)) {
            dsName = DataSourceConsts.LOCAL_DATASOURCE;
        }

        //		String showSql = " select *  from " + boEnt.getTableName()+ "as t";
        StringBuffer showSql = new StringBuffer("select t.* ");
        JsonNode jsonNode = JsonUtil.toJsonNode(template.getDisplayField());
        for (JsonNode node : jsonNode) {
            DisplayField displayField = JsonUtil.toBean(node, DisplayField.class);
            if (displayField.getCustomColumn() != null && displayField.getCustomColumn()) {
                if (displayField.getSql() == null || displayField.getSql() == "") {
                    throw new BaseException("存在字段未配置SQL，请先配置完整");
                }
                showSql.append(displayField.getSql());
//				showSql = "select * ,"+displayField.getSql()+" from "+boEnt.getTableName()+ "as t";
            }
        }
        showSql.append(" from " + boEnt.getTableName() + " t");
        if (dataTemplateQueryVo.isJoinFlow()) {
            String pk = "id_";
            if (StringUtil.isNotEmpty(boEnt.getPk())) {
                pk = boEnt.getPk();
            }
            ObjectNode nodes = JsonUtil.getMapper().createObjectNode();
            nodes.put("defKey", dataTemplateQueryVo.getDefKey());
            nodes.put("taskType", dataTemplateQueryVo.getTaskType());
            List<String> listIds = workflowFeignService.getBusLink(nodes);
            if (listIds.size() > 0) {
                queryFilter.addFilter(pk, listIds, QueryOP.IN);
            } else {
                return returnData;
            }
        }

        //排序处理（字段前缀）
        if (BeanUtils.isNotEmpty(queryFilter.getSorter())) {
            String colPrefix = boEnt.isExternal() ? "" : SQLConst.CUSTOMER_COLUMN_PREFIX;
            List<FieldSort> sorter = queryFilter.getSorter();
            if (sorter != null) {
                sorter.forEach(i -> {
                    i.setProperty(colPrefix + i.getProperty());
                });
            }
        }
        //处理排序等其他条件
        queryFilter = getTemplateQueryFilter(queryFilter, template, boEnt);
        String filterSql = getFilterSql(template.getFilterField(), dsName, params, boEnt);
        // 处理分页
        PageList<Map<String, Object>> list = null;
        try (DatabaseSwitchResult result = databaseContext.setDataSource(dsName)) {
            list = (PageList<Map<String, Object>>) query(showSql.toString(), queryFilter, filterSql);
        } catch (Exception e) {
            throw new BaseException(e.getMessage(), e);
        }
        if (BeanUtils.isNotEmpty(list)) {
            returnData.setPage(list.getPage());
            returnData.setPageSize(list.getPageSize());
            for (Map<String, Object> rowMap : list.getRows()) {
                Map<String, Object> rtnMap = convertDbToData(boEnt, rowMap);
                rtnMap.put("isStartFlow", true);

                for (JsonNode node : jsonNode) {
                    DisplayField displayField = JsonUtil.toBean(node, DisplayField.class);
                    if (displayField.getCustomColumn() != null && displayField.getCustomColumn()) {
                        rtnMap.put(displayField.getName(), rowMap.get(displayField.getName()));
                    }
                }
                returnData.getRows().add(rtnMap);
                returnData.setTotal(list.getTotal());
            }
        }
        return returnData;
    }

    @Override
    public PageList<Map<String, Object>> getSubDataPagination(QueryFilter queryFilter, String alias, String refId) throws Exception {
        if (StringUtil.isNotEmpty(refId) && StringUtil.isNotEmpty(alias)) {
            return getSubList(queryFilter, alias, refId);
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getSubData(String alias, String refId) throws Exception {
        if (StringUtil.isNotEmpty(refId) && StringUtil.isNotEmpty(alias)) {
            return getSubList(alias, refId);
        }
        return null;
    }

    @Override
    public void exportSub(HttpServletResponse response, ExportSubVo exportVo) throws Exception {
        String getType = StringUtil.isEmpty(exportVo.getType()) ? "getType" : exportVo.getType();
        PageBean page = new PageBean(1, PageBean.WITHOUT_PAGE);
        if ("page".equals(getType)) {
            page.setPageSize(10);
        }
        QueryFilter queryFilter = exportVo.getQueryFilter();
        queryFilter.setPageBean(page);
        PageList<Map<String, Object>> pageList = getSubList(queryFilter, exportVo.getAlias(), exportVo.getRefId());
        // 拼装exprotMaps
        Map<String, String> exportMaps = new LinkedHashMap<String, String>();
        for (JsonNode str : (ArrayNode) JsonUtil.toJsonNode(exportVo.getExpField())) {
            exportMaps.put(str.get("key").asText(), str.get("value").asText());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel(exportVo.getAlias(), 24, exportMaps, pageList.getRows());
        ExcelUtil.downloadExcel(book, exportVo.getAlias(), response);
    }

    @SuppressWarnings("unchecked")
    public StringBuilder preSql(BoEnt boEnt) {
        StringBuilder sql = new StringBuilder("insert into ");
        sql.append(boEnt.getTableName());
        sql.append(" (id_,ref_id_");
        List<?> columnList = boEnt.getColumnList();
        if (columnList != null) {
            ((List<BoAttribute>) columnList).forEach(i -> {
                sql.append("," + i.getFieldName());
            });
        }
        sql.append(",F_form_data_rev_");
        sql.append(") values (");
        return sql;
    }

    //生成流程字段
    private void addFieldList(List<FormField> fields) {
        String[] fileArr = new String[]{"流程编号", "标题", "流程名称", "实例状态", "创建时间", "结束时间", "是否挂起", "发起人", "是否删除"};
        String[] nameArr = new String[]{"bpm_proc_inst_id_", "bpm_subject_", "bpm_proc_def_name_", "bpm_status_", "bpm_create_time_", "bpm_end_time_", "bpm_is_forbidden_", "bpm_creator_", "bpm_is_dele_"};
        String[] typeArr = new String[]{"varchar", "varchar", "varchar", "varchar", "date", "date", "varchar", "varchar", "varchar"};

        for (int i = 0; i < fileArr.length; i++) {
            FormField field = new FormField();
            field.setFlowField(true);
            field.setName(nameArr[i]);
            field.setDesc(fileArr[i]);
            field.setType(typeArr[i]);
            field.setShowFlowField(true);
            fields.add(field);
        }
    }

    @Override
    public FormDataTemplate getByAlias(String alias) {
        return baseMapper.getByAlias(alias);
    }

    @Override
    public void removeByFormKey(String formKey) {
        baseMapper.removeByFormKey(formKey);
    }

    /**
     * 将从数据库读取的数据到实例数据。
     *
     * @param boEnt
     * @param map
     * @return
     */
    private Map<String, Object> convertDbToData(BoEnt boEnt, Map<String, Object> map) {
        Map<String, Object> rtnMap = new HashMap<String, Object>();

        for (Entry<String, Object> ent : map.entrySet()) {
            String field = ent.getKey().toLowerCase();
            BoAttribute attribute = boEnt.getAttrByField(field);
            if (BeanUtils.isNotEmpty(attribute)) {
                // 处理日期。
                Object val = handValue(attribute, ent.getValue());
                rtnMap.put(attribute.getName(), val);
            }
        }
        String pkKey = boEnt.getPkKey();
        if (boEnt.isPkNumber() && BeanUtils.isNotEmpty(rtnMap.get(pkKey))) {
            rtnMap.put(pkKey, rtnMap.get(pkKey).toString());
        }
        return rtnMap;
    }

    /**
     * 数据根据bo属性处理。
     *
     * @param attr
     * @param val
     * @return
     */
    private Object handValue(BoAttribute attr, Object val) {
        if (BeanUtils.isEmpty(val))
            return val;
        String format = attr.getFormat();
        if (val instanceof Timestamp) {
            Timestamp times = (Timestamp) val;
            return TimeUtil.getDateTimeString(times.toLocalDateTime(), format);
        } else if (val instanceof Date) {
            return TimeUtil.getDateTimeString(DateFormatUtil.parse((Date) val), format);
        } else {
            return val;
        }
    }

    private QueryFilter getTemplateQueryFilter(QueryFilter queryFilter, FormDataTemplate bpmDataTemplate, BoEnt boEnt) throws Exception {
        if (BeanUtils.isNotEmpty(bpmDataTemplate)) {
            // 是否分页
            PageBean page = queryFilter.getPageBean();
            if (2 == bpmDataTemplate.getNeedPage()) {
                page.setPageSize(PageBean.WITHOUT_PAGE);
            } else {
                page.setPageSize(queryFilter.getPageBean().getPageSize());
            }
            queryFilter.setPageBean(page);
            // 排序
            String sortField = bpmDataTemplate.getSortField();
            if (StringUtil.isNotZeroEmpty(sortField)) {
                //获取字段前缀
                String colPrefix = boEnt.isExternal() ? "" : SQLConst.CUSTOMER_COLUMN_PREFIX;
                ArrayNode array = (ArrayNode) JsonUtil.toJsonNode(sortField);
                for (int i = 0; i < array.size(); i++) {
                    ObjectNode obj = (ObjectNode) array.get(i);
                    queryFilter.getSorter().add(new FieldSort(colPrefix + obj.get("name").asText(), Direction.fromString(obj.get("sort").asText())));
                }
            }
        }
        return queryFilter;
    }

    private PageList<?> query(String sql, QueryFilter queryFilter, String filterSql) throws SystemException {
        Assert.notNull(sql, "sql can not be empty.");
        Assert.notNull(queryFilter, "queryFilter can not be empty.");
        if (StringUtil.isNotEmpty(filterSql)) {
            queryFilter.addParams(filterSql, null);
        }
        queryFilter.withParam("filterSql", filterSql);
        return commonManager.queryByCustomSql(sql, queryFilter);
    }

    private PageList<Map<String, Object>> getSubList(QueryFilter queryFilter, String alias, String refId) throws Exception {
        // 处理分页
        PageList<Map<String, Object>> pageList = new PageList<>();
        BoEnt boEnt = boEntManager.getByName(alias);
        String dsName = boEnt.getDsName();
        if (StringUtil.isEmpty(dsName)) {
            dsName = DataSourceConsts.LOCAL_DATASOURCE;
        }
        String showSql = "select * from " + boEnt.getTableName();
        if (StringUtil.isNotEmpty(refId)) {
            queryFilter.addFilter(boEnt.getFk(), refId, QueryOP.EQUAL);
        }
        try (DatabaseSwitchResult result = databaseContext.setDataSource(dsName)) {
            if (SQLConst.DB_POSTGRESQL.equals(result.getDbType())) {
                //处理pgsql下的日期、数字类型的模糊查询
                List<QueryField> queryFields = queryFilter.getQuerys();
                List<BoAttribute> boAttrList = boEnt.getBoAttrList();
                for (QueryField queryField : queryFields) {
                    for (BoAttribute boAttribute : boAttrList) {
                        if (boAttribute.getFieldName().toUpperCase().equals(queryField.getProperty().toUpperCase())) {
                            if (Column.COLUMN_TYPE_NUMBER.equals(boAttribute.getDataType()) || Column.COLUMN_TYPE_DATE.equals(boAttribute.getDataType())) {
                                queryField.setProperty(queryField.getProperty() + "||''");
                            } else {
                                break;
                            }

                        }
                    }
                }
            } else if (SQLConst.DB_ORACLE.equals(result.getDbType())) {
                //处理pgsql下的日期、数字类型的模糊查询
                List<QueryField> queryFields = queryFilter.getQuerys();
                List<BoAttribute> boAttrList = boEnt.getBoAttrList();
                for (QueryField queryField : queryFields) {
                    for (BoAttribute boAttribute : boAttrList) {
                        if (boAttribute.getFieldName().toUpperCase().equals(queryField.getProperty().toUpperCase())) {
                            if (Column.COLUMN_TYPE_DATE.equals(boAttribute.getDataType())) {
                                queryField.setProperty(" TO_CHAR(" + queryField.getProperty() + ",'yyyy-MM-dd') ");
                            } else {
                                break;
                            }

                        }
                    }
                }
            }
            pageList = (PageList<Map<String, Object>>) query(showSql, queryFilter, "");
        } catch (Exception e) {
            throw new BaseException(e.getMessage(), e);
        }
        List<Map<String, Object>> list = pageList.getRows();
        convertToDateTime(list, boEnt.getColumnList());
        //大小写兼容处理
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> m = list.get(i);
            Map<String, Object> tm = new HashMap<>();
            for (String k : m.keySet()) {
                try {
                    tm.put(k.toLowerCase(), m.get(k));
                } catch (Exception e) {
                    tm.put(k.toLowerCase(), m.get(k));
                }
                list.set(i, tm);
            }
        }
        pageList.setRows(list);
        if (BeanUtils.isNotEmpty(pageList)) {
            return pageList;
        }
        return pageList;
    }

    private void convertToDateTime(List<Map<String, Object>> list, List<BoAttribute> columnList) {
        for (Map<String, Object> map : list) {
            for (BoAttribute column : columnList) {
                if ("date".equals(column.getDataType())) {
                    if (BeanUtils.isNotEmpty(map.get(column.getFieldName().toLowerCase()))) {
                        map.put(column.getFieldName(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(map.get(column.getFieldName().toLowerCase())));
                    } else if (BeanUtils.isNotEmpty(map.get(column.getFieldName()))) {
                        map.put(column.getFieldName(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(map.get(column.getFieldName())));
                    } else if (BeanUtils.isNotEmpty(map.get(column.getFieldName().toUpperCase()))) {
                        map.put(column.getFieldName().toUpperCase(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(map.get(column.getFieldName().toUpperCase())));
                    }
                }
            }
        }
    }

    private List<Map<String, Object>> getSubList(String alias, String refId) throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(1, PageBean.WITHOUT_PAGE));
        PageList<Map<String, Object>> pageList = getSubList(queryFilter, alias, refId);
        return pageList.getRows();
    }

    @Override
    public Map<String, String> exportDef(List<String> list) throws Exception {
        Map<String, String> map = new HashMap<String, String>();
        FormDataTemplateXmlList formDataTemplateXmlList = new FormDataTemplateXmlList();
        for (String id : list) {
            FormDataTemplateXml formDataTemplateXml = getByTemplateId(id);
            formDataTemplateXmlList.addFormDataTemplateXml(formDataTemplateXml);
        }
        try {
            String xml = JAXBUtil.marshall(formDataTemplateXmlList, FormDataTemplateXmlList.class);
            map.put("formDataTemplates.form.xml", xml);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出失败！" + e.getMessage(), e);
        }
        return map;
    }

    @Override
    @CachePut(value = CacheKeyConst.EIP_FORM_DATATEMPLATE_IMPORT_FILE, key = "#fileId",
            firstCache = @FirstCache(expireTime = 1, timeUnit = TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileJson) {
        return fileJson;
    }

    @Override
    @Cacheable(value = CacheKeyConst.EIP_FORM_DATATEMPLATE_IMPORT_FILE, key = "#fileId",
            firstCache = @FirstCache(expireTime = 1, timeUnit = TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    @CacheEvict(value = CacheKeyConst.EIP_FORM_DATATEMPLATE_IMPORT_FILE, key = "#fileId")
    public void delImportFileFromCache(String fileId) {
    }

    @Override
    public CommonResult<String> importDef(ObjectNode objectNode, String typeId) {
        try {
            String formDataTemplatesXml = objectNode.get("formDataTemplatesXml").asText();

            // 数据报表xml 导入处理
            FormDataTemplateXmlList formDataTemplateXmlList = (FormDataTemplateXmlList) JAXBUtil.unmarshall(formDataTemplatesXml, FormDataTemplateXmlList.class);
            List<FormDataTemplateXml> list = formDataTemplateXmlList.getFormDataTemplateXmlList();
            for (FormDataTemplateXml formDataTemplateXml : list) {
                importDef(formDataTemplateXml, typeId);
            }
            return new CommonResult<String>("导入成功");

        } catch (Exception e) {
            throw new RuntimeException("XML转换为POJO类型错误" + e.getMessage(), e);
        }
    }

    /**
     * 导入某个数据报表
     *
     * @param formDataTemplateXml void
     */
    private void importDef(FormDataTemplateXml formDataTemplateXml, String typeId) {
        importDefinition(formDataTemplateXml, typeId);
    }

    /**
     * 导入数据报表
     *
     * @param formDataTemplateXml
     * @return FormDataTemplate
     */
    private FormDataTemplate importDefinition(FormDataTemplateXml formDataTemplateXml, String typeId) {
        FormDataTemplate formDataTemplate = formDataTemplateXml.getFormDataTemplate();
        SystemConfigFeignService systemConfigFeignService = AppUtil.getBean(SystemConfigFeignService.class);
        ObjectNode sysType = systemConfigFeignService.getSysTypeById(typeId);
        String typeName = "";
        if (BeanUtils.isNotEmpty(sysType)) {
            typeName = sysType.get("name").asText();
        }
        // 数据报表分类
        if (StringUtil.isNotEmpty(typeId)) {
            formDataTemplate.setTypeId(typeId);
            formDataTemplate.setTypeName(typeName);
        }
        IUser user = ContextUtil.getCurrentUser();
        if (BeanUtils.isNotEmpty(user)) {
            formDataTemplate.setCreateBy(user.getUserId());
        }
        formDataTemplate.setCreateTime(LocalDateTime.now());
        FormDataTemplate entity = baseMapper.getByAlias(formDataTemplate.getAlias());
        //判断导入的数据报表数据库是否存在
        if (BeanUtils.isNotEmpty(entity)) {
            if (BeanUtils.isNotEmpty(user)) {
                formDataTemplate.setUpdateBy(user.getUserId());
                formDataTemplate.setUpdateTime(LocalDateTime.now());
            }
            baseMapper.updateById(formDataTemplate);
        } else {
            formDataTemplate.setId(UniqueIdUtil.getSuid());
            baseMapper.insert(formDataTemplate);
        }
        return formDataTemplate;
    }

    /**
     * 根据流程定义ID获取FormDataTemplateXml
     *
     * @param id
     * @return FormDataTemplateXml
     */
    private FormDataTemplateXml getByTemplateId(String id) {
        FormDataTemplate formDataTemplate = baseMapper.selectById(id);

        FormDataTemplateXml formDataTemplateXml = new FormDataTemplateXml();
        // 数据报表
        formDataTemplateXml.setFormDataTemplate(formDataTemplate);

        return formDataTemplateXml;
    }

    @Override

    @Transactional
    public void checkAndImportData(List<Map<String, Object>> rows, BoEnt boEnt, Map<String, BoAttribute> columnMap, String bindFilld, String fillValue, String refIdValue, FormDataTemplate template, BoDataImportHandler boDataImportHandler, Map<String, String> nameFieldMap) throws Exception {
        String refValue = "undefined".equals(refIdValue) ? "0" : refIdValue;
        FormMeta formDef = formMetaManager.getByKey(template.getFormKey());
        Map<String, Map<String, JsonNode>> filedValidateMap = new HashMap<>();
        ArrayNode filedsArray = FormUtil.resolutionFieldsByFormMeta(formDef);
        if (BeanUtils.isNotEmpty(filedsArray)) {
            //解析表单配置的校验规则，后台支持的校验规则，在后台校验一遍
            for (JsonNode filed : filedsArray) {
                if (BeanUtils.isEmpty(filed.get("options")) || BeanUtils.isEmpty(filed.get("options").get("validateList"))) {
                    continue;
                }
                Map<String, JsonNode> validateMap = new HashMap<>();
                for (JsonNode validat : filed.get("options").get("validateList")) {
                    validateMap.put(validat.get("key").asText(), validat);
                }
                filedValidateMap.put(filed.get("name").asText(), validateMap);
            }
        }

        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(boEnt.getDsName() == null ? DataSourceConsts.LOCAL_DATASOURCE : boEnt.getDsName());
        List<FormDataImportLog> validateList = new ArrayList<>();
        Map<String, Object> threadVarMap = new HashMap<>();
        //临时存放唯一校验的map
        Map<String, Set<Object>> uniqueValeMap = new HashMap<>();
        for (int i = 0; i < rows.size(); i++) {
            StringBuffer sql = new StringBuffer("insert into ");
            Map<String, Object> row = rows.get(i);
            if (BeanUtils.isEmpty(row)) {
                continue;
            }
            List<ValidateResult> validateData = validateData(row, filedValidateMap, columnMap, uniqueValeMap);
            if (BeanUtils.isNotEmpty(validateData)) {
                for (ValidateResult validateResult : validateData) {
                    FormDataImportLog log = new FormDataImportLog(validateResult);
                    log.setId(UniqueIdUtil.getSuid());
                    log.setRowNumber(i + 3);
                    log.setPId(refValue);
                    log.setBoAlias(template.getBoDefAlias());
                    validateList.add(log);
                }
                continue;
            }
            if (boDataImportHandler != null) {
                //校验数据
                List<ValidateResult> validateRes = boDataImportHandler.validateData(rows.get(i), boEnt, threadVarMap);
                if (BeanUtils.isNotEmpty(validateRes)) {
                    for (ValidateResult validateResult : validateRes) {
                        FormDataImportLog log = new FormDataImportLog(validateResult);
                        log.setId(UniqueIdUtil.getSuid());
                        log.setRowNumber(i + 3);
                        log.setPId(refValue);
                        log.setBoAlias(template.getBoDefAlias());
                        validateList.add(log);
                    }
                    continue;
                }
                //调用接口转换数据
                row = boDataImportHandler.transData(rows.get(i), boEnt, threadVarMap);
            }

            List<String> fields = new ArrayList<String>();
            List<Object> values = new ArrayList<Object>();
            StringBuffer params = new StringBuffer();
            String dbType = SQLUtil.getDbType();
            for (Entry<String, Object> map : row.entrySet()) {
                if ("主键".equals(map.getKey())) {
                    fields.add(boEnt.getPkKey());
                    if (BeanUtils.isNotEmpty(row.get("主键"))) {
                        values.add("'" + row.get("主键") + "'");
                    } else {
                        values.add(UniqueIdUtil.getSuid());
                    }
                    params.append("?,");
                } else {
                    //excel单元格有值才去拼接sql
                    if (BeanUtils.isNotEmpty(map.getValue())) {
                        String key = map.getKey();
                        if (nameFieldMap.containsKey(key)) {
                            key = nameFieldMap.get(key);
                        }
                        BoAttribute field = columnMap.get(key);
                        if (BeanUtils.isEmpty(field) || field.getName().equals(bindFilld)) {
                            continue;
                        }
                        fields.add(field.getFieldName());
                        if (map.getValue() instanceof String) {
                            if (DateUtil.isRqSjFormat(map.getValue().toString())
                                    && (dbType.equals(SQLConst.DB_POSTGRESQL) || dbType.equals(SQLConst.DB_ORACLE))) {
                                // 判断传入的文本是否符合日期格式 如果符合,则转为Timestamp格式
                                values.add(Timestamp.valueOf(map.getValue().toString()));
                            } else if (DateUtil.isRqFormat(map.getValue().toString())
                                    && (dbType.equals(SQLConst.DB_POSTGRESQL) || dbType.equals(SQLConst.DB_ORACLE))) {
                                // 判断传入的文本是否符合日期格式 如果符合,则转为Timestamp格式
                                values.add(Timestamp.valueOf(map.getValue().toString() + " 00:00:00"));
                            } else if (map.getValue().toString().matches("\\d+(.\\d+)?") && dbType.equals(SQLConst.DB_POSTGRESQL)) {
                                // 若为数字转为浮点型
                                values.add(Float.parseFloat(map.getValue().toString()));
                            } else {
                                values.add(map.getValue());
                            }
                        } else {
                            values.add(map.getValue());
                        }
                        params.append("?,");
                    }
                }
            }
            //判断如果excel中无[主键]列，则补充完整
            if (!fields.contains(boEnt.getPkKey())) {
                fields.add(boEnt.getPkKey());
                if (boEnt.isPkNumber()) {
                    values.add(UniqueIdUtil.getUId());
                } else {
                    values.add(UniqueIdUtil.getSuid());
                }
                params.append("?,");
            }

            if (StringUtil.isNotEmpty(bindFilld) && StringUtil.isNotEmpty(fillValue)) {
                fields.add(BoEnt.FIELD_PREFIX + bindFilld);
                values.add(fillValue);
                params.append("?,");
            }

            //加入外键，如果有的话
            if (StringUtil.isNotEmpty(boEnt.getFk())) {
                fields.add(boEnt.getFk());
                if (StringUtil.isNotEmpty(refValue)) {
                    values.add(refValue);
                } else {
                    values.add("0");
                }
                params.append("?,");
            }

            //非外部表则加入表单版本字段
            if (!boEnt.isExternal()) {
                fields.add("F_form_data_rev_");
                if (dbType.equals(SQLConst.DB_POSTGRESQL)) {
                    values.add(0);
                } else {
                    values.add("0");
                }
                params.append("?,");
            }

            //加入额外的两个字段
            fields.add(BoEnt.FK_NAME);
            if (StringUtil.isNotEmpty(refValue)) {
                values.add(refValue);
            } else {
                values.add("0");
            }

            params.append("?,");
            fields.add("F_form_data_rev_");
            if (dbType.equals(SQLConst.DB_POSTGRESQL)) {
                values.add(0);
            } else {
                values.add("0");
            }
            params.append("?");

            sql.append(boEnt.getTableName());
            sql.append("(" + String.join(",", fields) + ")");
            sql.append(" values ");
            sql.append("(" + params.substring(0, params.length() - 1) + ")");

            try {
                jdbcTemplate.update(sql.toString(), values.toArray());
            } catch (Exception e) {
                FormDataImportLog log = new FormDataImportLog();
                log.setId(UniqueIdUtil.getSuid());
                log.setRowNumber(i + 3);
                log.setPId(refValue);
                log.setBoAlias(template.getBoDefAlias());
                log.setErrorMsg(e.getMessage());
                validateList.add(log);
            }
        }
        if (validateList.size() > 0) {
            ExecutorService executorService = Executors.newCachedThreadPool();
            executorService.execute(() -> {
                try {
                    formDataImportLogManager.deleteByPid(refValue, template.getBoDefAlias());
                    formDataImportLogManager.saveBatch(validateList);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            throw new RuntimeException("导入失败，详情请查看导入日志");
        } else {
            formDataImportLogManager.deleteByPid(refValue, template.getBoDefAlias());
        }
        if (StringUtil.isNotEmpty(bindFilld)) {
            //系统本身生成的id是很长的，临时外键使用时间戳。比当前时间还小1天的，并且在2020年之后的。当做冗余的脏数据清理掉
            String cleanSql = "delete from " + boEnt.getTableName() + " where " + BoEnt.FK_NAME + " < " + String.valueOf(System.currentTimeMillis() - 24 * 60 * 60 * 1000) + " and " + BoEnt.FIELD_PREFIX + bindFilld + " > " + String.valueOf(TimeUtil.getMillsByDateString("2020-01-01"));
            jdbcTemplate.execute(cleanSql);
        }
    }

    private List<ValidateResult> validateData(Map<String, Object> data, Map<String, Map<String, JsonNode>> filedValidateMap, Map<String, BoAttribute> columnMap, Map<String, Set<Object>> uniqueValeMap) {
        List<ValidateResult> list = new ArrayList<>();
        Map<String, BoAttribute> filedNameMap = new HashMap<>();
        for (BoAttribute attr : columnMap.values()) {
            filedNameMap.put(attr.getName(), attr);
        }
        for (Iterator<Entry<String, Map<String, JsonNode>>> iterator = filedValidateMap.entrySet().iterator(); iterator.hasNext(); ) {
            Entry<String, Map<String, JsonNode>> next = iterator.next();
            if (!filedNameMap.containsKey(next.getKey())) {
                continue;
            }
            BoAttribute attribute = filedNameMap.get(next.getKey());
            Object value = data.get(attribute.getDesc());
            for (Iterator<Entry<String, JsonNode>> iterator2 = next.getValue().entrySet().iterator(); iterator2.hasNext(); ) {
                Entry<String, JsonNode> entity = iterator2.next();
                ValidateResult validateRes = validate(attribute, value, entity.getKey(), entity.getValue(), filedNameMap, data, uniqueValeMap);
                if (BeanUtils.isNotEmpty(validateRes)) {
                    list.add(validateRes);
                }
            }
        }
        return list;
    }

    private ValidateResult validate(BoAttribute attribute, Object value, String validateName, JsonNode validate, Map<String, BoAttribute> filedNameMap,
                                    Map<String, Object> data, Map<String, Set<Object>> uniqueValeMap) {
        String errorMsg = "";
        switch (validateName) {
            case "required":
                if (BeanUtils.isEmpty(value)) {
                    errorMsg = "不能为空";
                }
                break;
            case "max":
                int maxLen = JsonUtil.getInt((ObjectNode) validate, "value");
                if (BeanUtils.ObjectToString(value).length() > maxLen) {
                    errorMsg = "长度超出" + maxLen;
                }
                break;
            case "min":
                int minLen = JsonUtil.getInt((ObjectNode) validate, "value");
                if (BeanUtils.ObjectToString(value).length() < minLen) {
                    errorMsg = "长度不够" + minLen;
                }
                break;
            case "is":
                String valueScope = JsonUtil.getString((ObjectNode) validate, "value");
                if (StringUtil.isNotEmpty(valueScope)) {
                    Set<String> values = new HashSet<>(Arrays.asList(valueScope.split(",")));
                    if (!values.contains(value)) {
                        errorMsg = "输入值不在【" + StringUtil.join(values) + "】范围之内";
                    }
                }
                break;
            case "regex":
                String regex = JsonUtil.getString((ObjectNode) validate, "value");
                if (StringUtil.isNotEmpty(regex) && !Pattern.matches(regex, BeanUtils.ObjectToString(value))) {
                    errorMsg = "正则不匹配";
                }
                break;
            case "row_unique":
                List<String> uniqueKeyList = new ArrayList<>(Arrays.asList(JsonUtil.getString((ObjectNode) validate, "value").split(",")));
                if (!uniqueKeyList.contains(attribute.getName())) {
                    uniqueKeyList.add(attribute.getName());
                }
                List<String> uniqueValList = new ArrayList<>();
                List<String> uniqueDescList = new ArrayList<>();
                for (String key : uniqueKeyList) {
                    if (key.split("\\.").length == 3) {
                        key = key.split("\\.")[2];
                    }
                    if (filedNameMap.containsKey(key)) {
                        uniqueValList.add(BeanUtils.ObjectToString(data.get(filedNameMap.get(key).getDesc())));
                        uniqueDescList.add(filedNameMap.get(key).getDesc());
                    }
                }
                String uniqueKey = StringUtil.join(uniqueKeyList, "");
                Set<Object> valueSet = BeanUtils.isNotEmpty(uniqueValeMap.get(uniqueKey)) ? uniqueValeMap.get(uniqueKey) : new HashSet<>();
                if (valueSet.contains(StringUtil.join(uniqueValList, ""))) {
                    errorMsg = "违反【" + StringUtil.join(uniqueDescList, "+") + "】唯一约束";
                } else {
                    valueSet.add(StringUtil.join(uniqueValList, ""));
                }
                uniqueValeMap.put(uniqueKey, valueSet);
                break;
            default:
                break;
        }
        if (StringUtil.isEmpty(errorMsg)) {
            return null;
        }
        return new ValidateResult(attribute.getDesc(), errorMsg);
    }

    @Override

    public List<Map<String, Object>> resolutionExcel(MultipartFile firstFile, Map<String, BoAttribute> columnMap, String bindFilld) {
        //用来存放表中数据
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Workbook wb = ExcelUtil.readExcel(firstFile);
        if (wb == null) {
            return list;
        }
        List<Map<String, String>> listMap = ExcelUtil.ImportDate(firstFile).stream().filter(item -> !isEmptyRow(item)).collect(Collectors.toList());
        listMap.forEach(map -> {
            Map<String, Object> boData = new LinkedHashMap<String, Object>();
            map.forEach((key, value) -> {
                if (columnMap.containsKey(key)) {
                    BoAttribute boAttribute = columnMap.get(key);
                    boData.put(boAttribute.getDesc(), value);
                }
            });
            if (boData.size() > 0) {
                list.add(boData);
            }
        });

        return list;

    }

    private boolean isEmptyRow(Map<String, String> param) {
        boolean isEmpty = true;
        for (String key : param.keySet()) {
            if (BeanUtils.isNotEmpty(param.get(key))) {
                isEmpty = false;
            }
        }
        return isEmpty;
    }

    @SuppressWarnings("deprecation")
    public Object getCellFormatValue(BoAttribute boAttribute, Cell cell) {

        if (cell == null) {
            return "";
        }
        Object cellValue = null;
        //判断cell类型
        switch (boAttribute.getDataType()) {
            case "number": {
                cellValue = cell.getNumericCellValue();
                break;
            }
            case "date": {
                if (CellType.STRING == cell.getCellType()) {
                    cellValue = cell.getRichStringCellValue().getString();
                } else {
                    cellValue = cell.getDateCellValue();
                }

                break;
            }
            case "varchar": {
                if (CellType.NUMERIC == cell.getCellType()) {
                    cellValue = BeanUtils.ObjectToString(cell.getNumericCellValue());
                } else {
                    cellValue = cell.getRichStringCellValue().getString();
                }
                break;
            }
            default:
                cellValue = "";
        }
        return cellValue;
    }

    @Override
    @SuppressWarnings("unchecked")
    public void downloadMainTempByFormKey(HttpServletResponse response, String alias) throws Exception {

        Form bpmForm = formManager.getMainByFormKey(alias);
        String formId = bpmForm.getDefId();
        List<String> boDefIds = formMetaManager.getBODefIdByFormId(formId);

        BoDef boDef = this.boDefService.getByDefId(boDefIds.get(0));
        BoEnt boEnt = boDef.getBoEnt();
        Map<String, String> exportMaps = new LinkedHashMap<String, String>();
        //加入主键列
        //exportMaps.put(boEnt.getPkKey(), "主键");

        List<BoAttribute> boAttrList = boEnt.getColumnList();
        for (BoAttribute boAttr : boAttrList) {
            exportMaps.put(boAttr.getName(), boAttr.getDesc());
        }
        // 拼装exprotMaps
        HSSFWorkbook book = ExcelUtil.exportExcel(bpmForm.getName(), 24, exportMaps, new ArrayList<>());

        ExcelUtil.downloadExcel(book, bpmForm.getName() + "_导入模板", response);
    }

    @Override
    public int updateTempRefId(ObjectNode objectNode) throws Exception {
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(DataSourceConsts.LOCAL_DATASOURCE);
        String tableName = objectNode.get("tabName").asText();
        String refFiled = BoEnt.FK_NAME;
        String oldValue = objectNode.get("oldValue").asText();
        String newValue = objectNode.get("newValue").asText();
        final List<Object> values = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tableName).append(" set ").append(refFiled).append("= ? ");
        values.add(newValue);
        sql.append(" where ");
        sql.append(refFiled);
        sql.append("=?");
        values.add(oldValue);
        int update = jdbcTemplate.update(sql.toString(), values.toArray());

        StringBuffer logUpdateSql = new StringBuffer();
        logUpdateSql.append(" update form_data_import_log  set  P_ID_").append("= ? ");
        logUpdateSql.append(" where P_ID_ =?");
        jdbcTemplate.update(logUpdateSql.toString(), values.toArray());
        return update;
    }

    @Override
    @Transactional
    public void boBatchUpdate(List<ObjectNode> listJson, String boAlias) throws Exception {
        BoDef boDef = boDefService.getByAlias(boAlias);
        BoDataHandler handler = boInstanceFactory.getBySaveType(BoConstants.SAVE_MODE_DB);
        BoEnt boEnt = boDef.getBoEnt();
        String pk = boEnt.getPk();
        if (StringUtil.isEmpty(pk)) {
            pk = BoEnt.PK_NAME;
        }
        for (int i = 0; i < listJson.size(); i++) {
            ObjectNode objectNode = listJson.get(i);
            if (!objectNode.has(pk)) {
                if (objectNode.has(pk.toUpperCase())) {
                    pk = pk.toUpperCase();
                } else if (objectNode.has(pk.toLowerCase())) {
                    pk = pk.toLowerCase();
                } else {
                    continue;
                }
            }

            String id = objectNode.get(pk).asText();
            BoData boData = handler.getResById(id, boAlias);
            Map<String, Object> map = boData.getData();
            map.forEach((key, value) -> {
                if (objectNode.has(key)) {
                    if (value instanceof BigDecimal) {
                        map.put(key, new BigDecimal(objectNode.get(key).asText()));
                    } else if (value instanceof Integer) {
                        map.put(key, Integer.parseInt(objectNode.get(key).asText()));
                    } else {
                        map.put(key, objectNode.get(key).asText());
                    }

                }
            });
            if (BeanUtils.isEmpty(boData.getBoEnt())) {
                boData.setBoEnt(boEnt);
            }
            List<BoResult> resultList = handler.save("", "", boData);
            if (BeanUtils.isNotEmpty(resultList)) {
                //添加修改记录
                handleBoResult(resultList, (ObjectNode) JsonUtil.toJsonNode(boData.getData()));
            }
            if (objectNode.has("formKey")) {
                String formKey = objectNode.get("formKey").asText();
                saveBo(boData, id, formKey);
            }
        }
    }

    private void saveBo(BoData boData, String boDataId, String formKey) throws Exception {
        List<FormDataTemplateExtend> list = formDataTemplateExtendManager.getDataTemplateExtendByFormKey(formKey);
        QueryWrapper<FormRemindData> qw = new QueryWrapper<>();
        qw.eq("ID_", boDataId);
        formRemindDataManager.deleteFormRemindDataByBoDataId(qw);

        List<FormRemindData> insertList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            FormDataTemplateExtend formDataTemplateExtend = list.get(i);
            String scriptJson = formDataTemplateExtend.getRule();
            if (StringUtil.isEmpty(scriptJson)) {
                continue;
            }
            JsonNode node = JsonUtil.toJsonNode(scriptJson);
            String script = node.get("scriptStr").asText();
            boolean res = groovyScriptEngine.executeBoolean(Base64.getFromBase64(script), boData.getData());
            if (res) {//符合提醒条件
                String typeObj = formDataTemplateExtend.getTypeObj();
                String objId = formDataTemplateExtend.getObjId();
                String content = formDataTemplateExtend.getContent();
                String count = formDataTemplateExtend.getCount();
                if (typeObj.equals("script")) {
                    objId = boData.getData().get(objId) + "";
                    FormRemindData formRemindData = new FormRemindData();
                    formRemindData.setSubject(formDataTemplateExtend.getSubject());
                    formRemindData.setContent(content);
                    formRemindData.setCount(count);
                    formRemindData.setObjId(objId);
                    formRemindData.setTypeObj("user");
                    formRemindData.setOpemId(boDataId);
                    formRemindData.setOpemType(formDataTemplateExtend.getAlias());
                    insertList.add(formRemindData);
                } else {
                    String[] objIds = objId.split(",");
                    for (int j = 0; j < objIds.length; j++) {
                        FormRemindData formRemindData = new FormRemindData();
                        formRemindData.setSubject(formDataTemplateExtend.getSubject());
                        formRemindData.setContent(content);
                        formRemindData.setCount(count);
                        formRemindData.setObjId(objIds[j]);
                        formRemindData.setTypeObj(typeObj);
                        formRemindData.setOpemId(boDataId);
                        formRemindData.setOpemType(formDataTemplateExtend.getAlias());
                        insertList.add(formRemindData);
                    }
                }
            }
        }
        formRemindDataManager.saveBatch(insertList);
    }

    @Override
    public List<FormDataTemplate> getExistsByFormKey(String formKey) {
        QueryFilter<FormDataTemplate> filter = QueryFilter.build();
        filter.addFilter("FORM_KEY_", formKey, QueryOP.EQUAL, FieldRelation.AND);
        PageList<FormDataTemplate> query = this.query(filter);
        if (BeanUtils.isEmpty(query.getRows())) {
            return null;
        }
        return query.getRows();
    }
}
