import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = []
    const fixedOptionList: IOption[] = [
        {
            title: '企业名称',
            prop: 'e.COMPANY_NAME_',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '评价年度',
            prop: 'assessYear',
            type: 'date',
            dateOption: {
                type: 'year',
                format: 'YYYY',
                valueFormat: 'YYYY',
                placeholder: '请选择评价年度'
            },
            span: 4,
            value: []
        },
    ]
    const columnsList: COption[] = [
        {
            title: '企业名称',
            prop: 'enterpriseName',
            minWidth: 180,
            sortable: true
        },
        {
            title: '评价年度',
            prop: 'assessYear',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '总供应商',
            prop: 'supplierNum',
            minWidth: 120,
            sortable: true
        },
        {
            title: '预警通知',
            prop: 'earlyWarnNum',
            minWidth: 120,
            sortable: true
        },
        {
            title: '整改通知',
            prop: 'rectificationNum',
            minWidth: 120,
            sortable: true
        },
        {
            title: '已评价供应商',
            prop: 'reviewedNum',
            minWidth: 120,
            sortable: true
        },
        {
            title: '未评价供应商',
            prop: 'notRatedNum',
            minWidth: 120,
            sortable: true
        },
        {
            title: '优秀',
            prop: 'excellentNum',
            minWidth: 120,
            sortable: true
        },
        {
            title: '良好',
            prop: 'fineNum',
            minWidth: 120,
            sortable: true
        },
        {
            title: '合格',
            prop: 'qualifiedNum',
            minWidth: 120,
            sortable: true
        },
        {
            title: '可改善',
            prop: 'improveNum',
            minWidth: 120,
            sortable: true
        },
        {
            title: '警告',
            prop: 'disqualifiedNum',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
