import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object, role: string) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterprise/v1/queryPage?role=${role}`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 表格回显
export function dataDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterprise/v1/getInfo/${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 菜单回显
export function menuDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterprise/v1/getFillingProgress?id=${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 导出excel
export function exportData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .download('/biz/enterprise/exportDataToExcel', 'post', data, 'arraybuffer')
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 供应商授信额度
export function setSupplierCreditLimit(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post('/bizSupplierEnterpriseCreditLimit/v1/batchAllocateSupplier',  data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}


// 客户授信额度
export function setCustomerCreditLimit(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post('/bizSupplierEnterpriseCreditLimit/v1/batchAllocateCustomer',  data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
