package com.artfess.workflow.runtime.listener;

import com.artfess.base.context.BaseContext;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FluentUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.StartNewFlowEvent;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.plugin.core.util.UserAssignRuleParser;
import com.artfess.bpm.plugin.core.util.UserAssignRuleQueryHelper;
import com.artfess.bpm.plugin.task.startnewflow.context.StartNewFlowPluginContext;
import com.artfess.bpm.plugin.task.startnewflow.def.StartNewFlowPluginDef;
import com.artfess.bpm.plugin.task.startnewflow.entity.StartConfig;
import com.artfess.bpm.util.BoDataUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.artfess.workflow.runtime.manager.IProcessManager;
import com.artfess.workflow.runtime.params.StartFlowParamObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.context.ApplicationListener;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Service
public class StartNewFlowEventListener implements ApplicationListener<StartNewFlowEvent> {
	@Resource
	BoDataService boDataService;
	@Resource
	BpmDefinitionManager bpmDefinitionManager;
	@Resource
	IProcessManager iProcessService;
	@Resource
	IUserService userServiceImpl;
	@Resource
	BaseContext baseContext;

	@Override
	public void onApplicationEvent(StartNewFlowEvent arg0) {

		BpmNodeDef bpmNodeDef = (BpmNodeDef) arg0.getSource();
		StartNewFlowPluginContext pluginContext = bpmNodeDef.getPluginContext(StartNewFlowPluginContext.class);
		if (BeanUtils.isEmpty(pluginContext)) {
			return;
		}
		StartNewFlowPluginDef pluginDef =  (StartNewFlowPluginDef) pluginContext.getBpmPluginDef();
		List<StartConfig> configs = pluginDef.getStartConfigList();
		ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
		ExecutorService executorService = Executors.newCachedThreadPool();
		String currentUserId = baseContext.getCurrentUserId();
		for (StartConfig conf : configs) {
			executorService.execute(() -> {
				try {
					IUser userByAccount = userServiceImpl.getUserById(currentUserId);
					SecurityContextHolder.getContext().setAuthentication(null);
					ContextUtil.setCurrentUser(userByAccount);
					startByConf(conf, actionCmd);
				} catch (Exception e) {
					e.printStackTrace();
				}
			});
		}
	}

	/**
	 * 根据配置自动启动流程
	 *
	 * @param iUser
	 * @param conf
	 * @param jsondata
	 * @return
	 * @throws Exception
	 */
	private void startByConf(StartConfig conf, ActionCmd actionCmd) throws Exception {
		if (!conf.getTriggerAction().equals(actionCmd.getActionName()) && !(OpinionStatus.REJECT.getKey().equals(conf.getTriggerAction()) && OpinionStatus.BACK_TO_START.getKey().equals(actionCmd.getActionName()))) {
			return;
		}
		DefaultBpmDefinition mainByDefKey = bpmDefinitionManager.getMainByDefKey(conf.getDefKey());
		if (BeanUtils.isEmpty(mainByDefKey)) {
			return;
		}

		List<UserAssignRule> rules = new ArrayList<>();
		UserAssignRule rule = UserAssignRuleParser.getUserAssignRule((ObjectNode) JsonUtil.toJsonNode(conf.getUserRule()));
		rules.add(rule);
		Map<String, Object> variables = actionCmd.getVariables();
		variables.putAll(actionCmd.getTransitVars());
		List<IUser> startUsers = UserAssignRuleQueryHelper.queryUsersWithExtract(rules, variables);
		if (BeanUtils.isEmpty(startUsers)) {
			return;
		}

		ObjectNode oldBoData = null;
		if (StringUtil.isEmpty(actionCmd.getBusData())) {
			BpmProcessInstanceManager instanceManager = AppUtil.getBean(BpmProcessInstanceManager.class);
			DefaultBpmProcessInstance instance = instanceManager.get(actionCmd.getInstId());
			if (BeanUtils.isNotEmpty(instance)) {
				List<ObjectNode> dataByInst = boDataService.getDataByInst(instance);
				if (BeanUtils.isNotEmpty(dataByInst)) {
					oldBoData = BoDataUtil.hanlerData(instance.getProcDefId(), dataByInst, true);
				}
			}
		}else {
			oldBoData = (ObjectNode) JsonUtil.toJsonNode(actionCmd.getBusData());
		}
		String newBusData = "";
		if (StringUtil.isNotEmpty(conf.getFormVarConf()) && oldBoData != null) {
			List<ObjectNode> boDatas = boDataService.getDataByDefId(mainByDefKey.getDefId());
			if (BeanUtils.isNotEmpty(boDatas)) {
				ObjectNode newBoData = BoDataUtil.hanlerData(mainByDefKey.getDefId(), boDatas, true);
				ArrayNode formVarConf = (ArrayNode) JsonUtil.toJsonNode(conf.getFormVarConf());
				for (JsonNode varConf : formVarConf) {
					String oldVar = JsonUtil.getString(varConf, "oldVar");
					String newVar = JsonUtil.getString(varConf, "newVar");
					if (StringUtil.isEmpty(oldVar) || StringUtil.isEmpty(newVar)) {
						continue;
					}
					String[] oldVarConf = oldVar.substring(oldVar.indexOf("【")+1, oldVar.length() - 1).split("\\.");
					String[] newVarConf = newVar.substring(newVar.indexOf("【")+1, newVar.length() - 1).split("\\.");
					if (BeanUtils.isEmpty(oldBoData.get(oldVarConf[0])) || BeanUtils.isEmpty(newBoData.get(newVarConf[0]))) {
						continue;
					}
					JsonNode oldValue = oldBoData.get(oldVarConf[0]).get(oldVarConf[1]);
					ObjectNode newData = (ObjectNode) newBoData.get(newVarConf[0]);
					if (BeanUtils.isNotEmpty(oldValue)) {
						newData.set(newVarConf[1], oldValue);
					}
				}
				newBusData =Base64.getBase64(JsonUtil.toJson(newBoData)) ;
			}
		}

		String url = "/runtime/instance/v1/start";
		for (IUser iUser : startUsers) {
			StartFlowParamObject paramObject = new StartFlowParamObject();
			paramObject.setData(newBusData);
			paramObject.setDefId(mainByDefKey.getId());
			System.err.println("启动新流程："+mainByDefKey.getName()+"发起人："+iUser.getFullname());
			paramObject.setAccount(iUser.getAccount());
			try {
				FluentUtil.postCurAppInterfaceWithHttp(url, iUser.getAccount(), paramObject);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

}
