package com.artfess.workflow.bpmModel.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.persistence.manager.CurrentUserService;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.service.IUserGroupService;
import com.artfess.workflow.bpmModel.dao.BpmOftenFlowDao;
import com.artfess.workflow.bpmModel.dao.BpmOftenFlowUserDao;
import com.artfess.workflow.bpmModel.manager.BpmOftenFlowManager;
import com.artfess.workflow.bpmModel.model.BpmOftenFlow;
import com.artfess.workflow.bpmModel.model.BpmOftenFlowUser;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 * <pre>
 *  
 * 描述：通用流程 处理实现类
 * 构建组：x7
 * 作者:liyg
 * 邮箱:liygui@jee-soft.cn
 * 日期:2019-03-04 15:23:03
 * 版权：广州宏天软件有限公司
 * </pre>
 */
@Service("bpmCommonDefManager")
public class BpmOftenFlowManagerImpl extends BaseManagerImpl<BpmOftenFlowDao, BpmOftenFlow> implements BpmOftenFlowManager {

    @Resource
    IUserGroupService defaultUserGroupService;
    @Resource
    BpmOftenFlowUserDao bpmOftenFlowUserDao;
    @Resource(name="bpmCurrentUserService")
    private CurrentUserService currentUserService;
    
	@Override
	@Transactional
	public void removeByUserIdAndDefKeys(String userId, List<String> defkeys) {
		baseMapper.removeByUserIdAndDefKeys(userId, defkeys);
	}

	@Override
	@Transactional
	public CommonResult<String> saveOrUpdateCommonFlow(Map<String,Object> map) throws Exception{
	    List<String> defkeysAry = (List<String>)map.get("defkeys");//选择的流程
        String type = map.get("type").toString();//新增或是修改
        ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode(map.get("calOwnerNameJson"));
        String msg = "添加常用流程成功";
		if (BeanUtils.isNotEmpty(defkeysAry)) {
		    for (String defKey : defkeysAry){
                BpmOftenFlow bpmOftenFlow = baseMapper.getBpmOftenFlow(defKey);
                if("add".equals(type)){//新增
                    if(BeanUtils.isNotEmpty(bpmOftenFlow)) {
                        return new CommonResult<String>(false, "流程key：" + defKey + "已存在，请重新选择");
                    }
                    if(BeanUtils.isEmpty(arrayNode)){
                        return new CommonResult<String>(false, "常用授权信息为空，请重新添加");
                    }
                    String id = UniqueIdUtil.getSuid();
                    BpmOftenFlow entity = new BpmOftenFlow();
                    entity.setId(id);
                    entity.setDefKey(defKey);
                    baseMapper.insert(entity);//新增常用流程
                    for (JsonNode jsonNode : arrayNode) {
                        saveBpmOftenFlowUser(jsonNode,id);
                    }
                }else if("edit".equals(type)){//修改
                    if(BeanUtils.isEmpty(bpmOftenFlow)){
                        return new CommonResult<String>(false, "通过流程key：" + defKey + "查询不到常用流程");
                    }
                    if(BeanUtils.isEmpty(arrayNode)){
                        return new CommonResult<String>(false, "常用授权信息为空，请重新添加");
                    }
                    bpmOftenFlowUserDao.removeByOftenFlowId(bpmOftenFlow.getId());//根据常用流程ID删除授权信息
                    for (JsonNode jsonNode : arrayNode) {
                        saveBpmOftenFlowUser(jsonNode,bpmOftenFlow.getId());
                    }
                }
            }
		}
		if("edit".equals(type)){
            msg = "修改常用流程成功";
        }
        return new CommonResult<String>(true, msg);
	}

	//新增常用流程授权对象
	private void saveBpmOftenFlowUser(JsonNode jsonNode,String id){
        String rightType = jsonNode.get("type").asText();
        if ("everyone".equals(rightType)) {
            BpmOftenFlowUser bpmOftenFlowUser = new BpmOftenFlowUser();
            bpmOftenFlowUser.setId(UniqueIdUtil.getSuid());
            bpmOftenFlowUser.setOftenFlowId(id);
            bpmOftenFlowUser.setRightType(rightType);
            bpmOftenFlowUserDao.insert(bpmOftenFlowUser);//新增常用流程授权对象
        } else {
            String[] ids = jsonNode.get("id").asText().split(",");
            String[] names = jsonNode.get("name").asText().split(",");
            for (int i = 0; i < ids.length; i++) {
                BpmOftenFlowUser bpmOftenFlowUser = new BpmOftenFlowUser();
                bpmOftenFlowUser.setId(UniqueIdUtil.getSuid());
                bpmOftenFlowUser.setOftenFlowId(id);
                bpmOftenFlowUser.setOwnerId(ids[i]);
                bpmOftenFlowUser.setOwnerName(names[i]);
                bpmOftenFlowUser.setRightType(rightType);
                bpmOftenFlowUserDao.insert(bpmOftenFlowUser);//新增常用流程授权对象
            }
        }
    }

	@Override
	@Transactional
	public void saveMyFlow(String userId, String userName, ArrayNode list) {
		this.removeByUserIdAndDefKeys(userId, null);
		List<BpmOftenFlow> bpmOftenFlows = new ArrayList<>();
		list.forEach(i -> {
			bpmOftenFlows.add(new BpmOftenFlow(userId, userName, i.get("defKey").asText()));
		});
		this.saveBatch(bpmOftenFlows);
	}

	@Override
	public PageList<BpmOftenFlow> customQuery(String userId) {
        QueryFilter<BpmOftenFlow> queryFilter = QueryFilter.<BpmOftenFlow>build();
        PageBean pageBean = new PageBean(1,20);
        queryFilter.setPageBean(pageBean);
        IPage<BpmOftenFlow> result = baseMapper.customQuery(convert2IPage(pageBean), convertGroupList(userId),
                convert2Wrapper(queryFilter, currentModelClass()));
		return new PageList<BpmOftenFlow>(result);
	}

    public PageList<BpmOftenFlow> query(QueryFilter<BpmOftenFlow> queryFilter) {
        return new PageList<>(baseMapper.query(convert2IPage(queryFilter.getPageBean()),convert2Wrapper(queryFilter, currentModelClass())));
    }

    // 根据用户ID或账号获取用户所属的组,这里不对组类别进行区分，返回统一的用户组列表，可能包括角色，部门等
    private Map<String, String> convertGroupList(String userId) {
        List<IGroup> list = defaultUserGroupService.getGroupsByUserIdOrAccount(userId);
        Map<String, String> map = new HashMap<String, String>();
        map.put("user", "'" + userId + "'");
        if (BeanUtils.isEmpty(list))
            return map;
        for (IGroup group : list) {
            String type = group.getGroupType();
            if (map.containsKey(type)) {
                String groupId = map.get(type);
                groupId += ",'" + group.getGroupId() + "'";
                map.put(type, groupId);
            } else {
                map.put(type, "'" + group.getGroupId() + "'");
            }
        }
        return map;
    }

	@Override
	public String getBpmOftenFlowUsers(String oftenFlowId) {
        return toOwnerNameJson(bpmOftenFlowUserDao.getBpmOftenFlowUsers(oftenFlowId));
	}

    /**
     * 常用流程授权人员列表转成按RightType分组授权人员JSON (单个OftenFlowId的人员列表)
     * [{type:"everyone"},{type:"user",id:"",name:""}]
     * @param bpmOftenFlowUsers
     * @return
     * String
     */
    private String toOwnerNameJson(List<BpmOftenFlowUser> bpmOftenFlowUsers){
        if(BeanUtils.isEmpty(bpmOftenFlowUsers)) return "[]";
        Map<String,List<BpmOftenFlowUser>> map = new HashMap<String, List<BpmOftenFlowUser>>();
        Map<String,String> userTypeMap= currentUserService.getUserTypeMap(CurrentUserService.DEFAULT_OBJECT_RIGHTTYPE_BEAN);

        for(BpmOftenFlowUser user:bpmOftenFlowUsers){
            String rightType=user.getRightType();
            if(map.containsKey(rightType)){
                List<BpmOftenFlowUser> list=map.get(rightType);
                list.add(user);
            }
            else{
                List<BpmOftenFlowUser> list =new ArrayList<BpmOftenFlowUser>();
                list.add(user);
                map.put(rightType, list);
            }
        }
        ArrayNode ArrayNode=JsonUtil.getMapper().createArrayNode();

        for (Map.Entry<String, List<BpmOftenFlowUser>> entry : map.entrySet()) {
            ObjectNode json= userEntToJson(entry,userTypeMap);
            ArrayNode.add(json);
        }
        return ArrayNode.toString();
    }


    private ObjectNode userEntToJson(Map.Entry<String, List<BpmOftenFlowUser>> entry,Map<String,String> userTypeMap){
        ObjectNode jsonObj=JsonUtil.getMapper().createObjectNode();
        String type=entry.getKey();
        String title=userTypeMap.get(type);
        jsonObj.put("type", type);
        jsonObj.put("title", title);
        if(type.equals("everyone")) {
            return jsonObj;
        }
        List<BpmOftenFlowUser> list=entry.getValue();
        String ids="";
        String names="";

        for(int i=0;i<list.size();i++){
            BpmOftenFlowUser user=list.get(i);
            if(i==0){
                ids+=user.getOwnerId();
                names+=user.getOwnerName();
            }
            else{
                ids+="," +user.getOwnerId();
                names+="," + user.getOwnerName();
            }
        }
        jsonObj.put("id", ids);
        jsonObj.put("name", names);

        return jsonObj;
    }
}
