package com.artfess.uc.model;

import com.artfess.base.util.BeanUtils;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModelProperty.AccessMode;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import java.time.LocalDateTime;

/**
* 用户登录日志表
* <pre>
* 描述：用户登录日志表 实体对象
* 构建组：x7
* 作者:zhangxw
* 邮箱:zhangxw@jee-soft.cn
* 日期:2020-06-19 18:42:21
* 版权：广州宏天软件股份有限公司
* </pre>
*/
@TableName("uc_login_log")
@ApiModel(value = "LoginLog",description = "用户登录日志表")
public class LoginLog extends UcBaseModel<LoginLog>{

   private static final long serialVersionUID = 1L;
   @XmlTransient
   @TableId("ID_")
   @ApiModelProperty(value="主键，用户id")
   protected String id;

   @XmlAttribute(name = "name")
   @TableField("NAME_")
   @ApiModelProperty(value="用户名")
   protected String name;

   @XmlAttribute(name = "account")
   @TableField("ACCOUNT_")
   @ApiModelProperty(value="用户账号")
   protected String account;

   @XmlAttribute(name = "ip")
   @TableField("IP_")
   @ApiModelProperty(value="登录IP")
   protected String ip;

   @XmlAttribute(name = "loginType")
   @TableField("LOGIN_TYPE_")
   @ApiModelProperty(value="登录类型（pc：电脑端登录，mobile：移动端登录）")
   protected String loginType;

   @XmlAttribute(name = "pcSum")
   @TableField("PC_SUM_")
   @ApiModelProperty(value="pc端登录次数")
   protected Integer pcSum;

   @XmlAttribute(name = "mobileSum")
   @TableField("MOBILE_SUM_")
   @ApiModelProperty(value="移动端登录次数")
   protected Integer mobileSum;

   @XmlAttribute(name = "loginSum")
   @TableField("LOGIN_SUM_")
   @ApiModelProperty(value="登录次数")
   protected Integer loginSum;

   @ApiModelProperty(value = "租户id", hidden=true, accessMode=AccessMode.READ_ONLY)
   @TableField(value="tenant_id_")
   protected String tenantId;

   @ApiModelProperty(value = "创建人ID", hidden=true, accessMode=AccessMode.READ_ONLY)
   @TableField(value="create_by_", fill=FieldFill.INSERT)
   private String createBy;

   @ApiModelProperty(value = "创建人组织ID", hidden=true, accessMode=AccessMode.READ_ONLY)
   @TableField(value="create_org_id_", fill=FieldFill.INSERT)
   private String createOrgId;

   @ApiModelProperty(value = "创建时间", hidden=true, accessMode=AccessMode.READ_ONLY)
   @TableField(value="create_time_", fill=FieldFill.INSERT)
   private LocalDateTime createTime;

   @ApiModelProperty(value = "更新人ID", hidden=true, accessMode=AccessMode.READ_ONLY)
   @TableField(value="update_by_", fill=FieldFill.UPDATE)
   private String updateBy;

   @ApiModelProperty(value = "更新时间", hidden=true, accessMode=AccessMode.READ_ONLY)
   @TableField(value="update_time_", fill=FieldFill.UPDATE)
   private LocalDateTime updateTime;

   @ApiModelProperty(value = "是否删除", hidden=true, accessMode=AccessMode.READ_ONLY)
   @TableField(value="IS_DELE_", fill=FieldFill.UPDATE)
   private String isDele;

   @ApiModelProperty(value = "版本号", hidden=true, accessMode=AccessMode.READ_ONLY)
   @TableField(value="VERSION_", fill=FieldFill.INSERT_UPDATE)
   private Integer version;


   public void setId(String id) {
       this.id = id;
   }

   /**
    * 返回 主键，用户id
    * @return
    */
   public String getId() {
       return this.id;
   }
   public void setName(String name) {
       this.name = name;
   }

   /**
    * 返回 用户名
    * @return
    */
   public String getName() {
       return this.name;
   }
   public void setAccount(String account) {
       this.account = account;
   }

   /**
    * 返回 用户账号
    * @return
    */
   public String getAccount() {
       return this.account;
   }
   public void setIp(String ip) {
       this.ip = ip;
   }

   /**
    * 返回 登录IP
    * @return
    */
   public String getIp() {
       return this.ip;
   }
   public void setLoginType(String loginType) {
       this.loginType = loginType;
   }

   /**
    * 返回 登录类型（pc：电脑端登录，mobile：移动端登录）
    * @return
    */
   public String getLoginType() {
       return this.loginType;
   }
   public Integer getPcSum() {
       if(BeanUtils.isEmpty(this.pcSum)){
           return 0;
       }
       return pcSum;
   }

   public void setPcSum(Integer pcSum) {
       this.pcSum = pcSum;
   }

   public Integer getMobileSum() {
       if(BeanUtils.isEmpty(this.mobileSum)){
           return 0;
       }
       return mobileSum;
   }

   public void setMobileSum(Integer mobileSum) {
       this.mobileSum = mobileSum;
   }

   public void setLoginSum(Integer loginSum) {
       this.loginSum = loginSum;
   }

   /**
    * 返回 登录次数
    * @return
    */
   public Integer getLoginSum() {
       if(BeanUtils.isEmpty(this.loginSum)){
           return 0;
       }
       return this.loginSum;
   }
   public void setCreateBy(String createBy) {
       this.createBy = createBy;
   }

   /**
    * 返回 创建人
    * @return
    */
   public String getCreateBy() {
       return this.createBy;
   }
   public void setCreateTime(LocalDateTime createTime) {
       this.createTime = createTime;
   }

   /**
    * 返回 创建时间
    * @return
    */
   public LocalDateTime getCreateTime() {
       return this.createTime;
   }
   public void setUpdateTime(LocalDateTime updateTime) {
       this.updateTime = updateTime;
   }

   /**
    * 返回 更新时间
    * @return
    */
   public LocalDateTime getUpdateTime() {
       return this.updateTime;
   }
   public void setCreateOrgId(String createOrgId) {
       this.createOrgId = createOrgId;
   }

   /**
    * 返回 创建人所属部门id
    * @return
    */
   public String getCreateOrgId() {
       return this.createOrgId;
   }
   public void setUpdateBy(String updateBy) {
       this.updateBy = updateBy;
   }


   public String getTenantId() {
       return tenantId;
   }

   public void setTenantId(String tenantId) {
       this.tenantId = tenantId;
   }

   public String getIsDele() {
       return isDele;
   }

   public void setIsDele(String isDele) {
       this.isDele = isDele;
   }

   public Integer getVersion() {
       return version;
   }

   public void setVersion(Integer version) {
       this.version = version;
   }

   public String getUpdateBy() {
       return updateBy;
   }

   /**
    * @see Object#toString()
    */
   public String toString() {
       return new ToStringBuilder(this)
       .append("id", this.id)
       .append("name", this.name)
       .append("account", this.account)
       .append("ip", this.ip)
       .append("loginType", this.loginType)
       .append("pcSum", this.pcSum)
       .append("mobileSum", this.mobileSum)
       .append("loginSum", this.loginSum)
       .append("createBy", this.createBy)
       .append("createTime", this.createTime)
       .append("updateTime", this.updateTime)
       .append("createOrgId", this.createOrgId)
       .append("updateBy", this.updateBy)
       .append("version", this.version)
       .append("tenantId", this.tenantId)
       .toString();
   }
}
