package com.artfess.examine.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.examine.vo.UserInfoVo;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 试卷基础信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@FieldRepeat(fields = {"name"},message = "试卷不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="ExamPaperBase对象", description="试卷基础信息")
public class ExamPaperBase extends AutoFillModel<ExamPaperBase> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "组卷方式【字典】（1：随机组卷，2：配置出卷，3：随机出卷）")
    @TableField("way_type_")
    private String wayType;

    @ApiModelProperty(value = "试卷类型（1正式考试、2模拟考试）")
    @TableField("type_")
    private String type;

    @ApiModelProperty(value = "考核类型【字典】（1普通考试、2年度考核），页面默认普通考试")
    @TableField("paper_type_")
    private String paperType;

    @NotBlank(message = "请选择科目",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考试科目(多个科目，隔开)")
    @TableField("subject_id_")
    private String subjectId;

    @ApiModelProperty(value = "课目名称")
    @TableField("subject_name_")
    private String subjectName;

    @Excel(name = "试卷名称", column = "A")
    @NotBlank(message = "请填写试卷名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "试卷名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "总分数")
    @TableField("total_score_")
    private BigDecimal totalScore;

    @ApiModelProperty(value = "总题目数")
    @TableField("total_number_")
    private Integer totalNumber;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "是否最终成绩【字典】1是，0否")
    @TableField("end_status_")
    private String endStatus;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "试卷配置信息（正式考试才会有这个配置信息）")
    @TableField(exist = false)
    private ExamPaperSetting paperSetting;

    @ApiModelProperty(value = "试卷分数配置信息")
    @TableField(exist = false)
    private List<ExamPaperQuestionSetting> paperQuestionSettings;

    @ApiModelProperty(value = "题目列表")
    @TableField(exist = false)
    private List<ExamQuestionsInfo> examQuestionsInfos;

    @ApiModelProperty(value = "考生集合")
    @TableField(exist = false)
    private List<UserInfoVo> userInfoVos;

    @ApiModelProperty(value = "科目列表")
    @TableField(exist = false)
    private List<ExamSubjectInfo> subjectInfos;

    @ApiModelProperty(value = "考试时长（分钟）")
    @TableField(exist = false)
    private BigDecimal timeLength;

    @ApiModelProperty(value = "考试开始时间")
    @TableField(exist = false)
    private LocalDateTime planStartTime;

    @ApiModelProperty(value = "考试结束时间")
    @TableField(exist = false)
    private LocalDateTime planEndTime;

    @ApiModelProperty(value = "阅卷方式【字典】（1：系统，2：人工）")
    @TableField(exist = false)
    private Integer trainModel;


    @ApiModelProperty(value = "试卷状态【字典】（0：未发布，1：考试中，2：已结束）")
    @TableField(exist = false)
    private String status;

    @ApiModelProperty(value = "考试场地")
    @TableField(exist = false)
    private String roomName;

    @ApiModelProperty(value = "及格率(%)")
    @TableField(exist = false)
    private BigDecimal passScore;

    @ApiModelProperty(value = "参考人员（1：所有人  2：用户）", hidden = true)
    @TableField(exist = false)
    private String testUserType = "1";

}
