package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 部队行动数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@ApiModel(value="BizForceActionData对象", description="部队行动数据")
public class BizForceActionData extends AutoFillModel<BizForceActionData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请填写单位", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "单位id")
    @TableField("org_id_")
    private String orgId;

    @Excel(name = "单位", column = "A")
    @ApiModelProperty(value = "单位")
    @TableField("org_name_")
    private String orgName;

    @Excel(name = "行动名称", column = "B")
    @ApiModelProperty(value = "行动名称")
    @TableField("action_name_")
    private String actionName;

    @Excel(name = "兵力编组", column = "C")
    @ApiModelProperty(value = "兵力编组")
    @TableField("troop_formation_")
    private String troopFormation;

    @Excel(name = "行动时间", column = "D")
    @ApiModelProperty(value = "行动时间")
    @TableField("action_time_")
    private LocalDate actionTime;

    @Excel(name = "环境条件", column = "E")
    @ApiModelProperty(value = "环境条件")
    @TableField("environmental_conditions_")
    private String environmentalConditions;

    @Excel(name = "机动速度", column = "F")
    @ApiModelProperty(value = "机动速度")
    @TableField("maneuvering_speed_")
    private String maneuveringSpeed;

    @Excel(name = "打击效果", column = "G")
    @ApiModelProperty(value = "打击效果")
    @TableField("strike_effect_")
    private String strikeEffect;

    @Excel(name = "备注", column = "H")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;
}
