/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.entity.BaseTreeModel;
import com.artfess.base.enums.TrainLevelEnum;
import com.artfess.base.enums.TrainTypeEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.examine.dao.ExamEquipmentSysDao;
import com.artfess.examine.dao.ExamPosSysDao;
import com.artfess.examine.dao.ExamSubjectInfoDao;
import com.artfess.examine.dao.ExamSubjectPosDao;
import com.artfess.examine.dao.ExamSubjectSysDao;
import com.artfess.examine.manager.ExamSubjectInfoManager;
import com.artfess.examine.model.ExamEquipmentSys;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamSubjectPos;
import com.artfess.examine.model.ExamSubjectSys;
import com.artfess.examine.model.ExamSubjectType;
import com.artfess.examine.vo.PositionVo;
import com.artfess.examine.vo.SubjectReqVo;
import com.artfess.examine.vo.UserInfoVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.api.client.util.Sets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ExamSubjectInfoManagerImpl
extends BaseManagerImpl<ExamSubjectInfoDao, ExamSubjectInfo>
implements ExamSubjectInfoManager {
    private static final Logger log = LoggerFactory.getLogger(ExamSubjectInfoManagerImpl.class);
    @Resource
    private ExamSubjectPosDao subjectPosDao;
    @Resource
    private ExamSubjectSysDao subjectSysDao;
    @Resource
    private ExamEquipmentSysDao equipmentSysDao;
    @Resource
    private ExamPosSysDao posSysDao;

    @Override
    public List<ExamSubjectType> getTree(ExamSubjectInfo entity) {
        ArrayList treeList = Lists.newArrayList();
        List<ExamSubjectType> orgs = ((ExamSubjectInfoDao)this.baseMapper).getOrgList();
        treeList.addAll(orgs);
        List<ExamSubjectType> posts = ((ExamSubjectInfoDao)this.baseMapper).getPositions();
        posts.forEach(post -> {
            if (StringUtil.isNotEmpty((String)post.getSysId())) {
                post.setParentId(post.getSysId());
            } else {
                post.setParentId(post.getOrgId());
            }
            post.setType("2");
        });
        treeList.addAll(posts);
        List<JSONObject> subjectList = ((ExamSubjectInfoDao)this.baseMapper).getSubjectList(entity);
        subjectList.forEach(subject -> {
            ExamSubjectType examSubjectType = new ExamSubjectType();
            examSubjectType.setType("3");
            examSubjectType.setName(subject.getString("name"));
            examSubjectType.setId(subject.getString("id"));
            String parentId = "0";
            if (!StringUtils.isEmpty((Object)subject.getString("positionid"))) {
                parentId = subject.getString("positionid");
            } else if (StringUtils.isEmpty((Object)subject.getString("positionid"))) {
                parentId = subject.getString("orgid");
            }
            examSubjectType.setParentId(parentId);
            treeList.add(examSubjectType);
        });
        List subjectInfoList = treeList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ExamSubjectType>(Comparator.comparing(BaseTreeModel::getId))), ArrayList::new));
        List tree = BeanUtils.listToTree((List)subjectInfoList);
        return tree;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subjectBindPosition(ExamSubjectInfo entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"subject_id_", (Object)entity.getId());
        this.subjectPosDao.delete((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(entity.getPositonVos())) {
            return;
        }
        entity.getPositonVos().forEach(positionVo -> {
            ExamSubjectPos subjectPos = new ExamSubjectPos();
            subjectPos.setPositionId(positionVo.getPositionId());
            subjectPos.setSubjectId(entity.getId());
            this.subjectPosDao.insert((Object)subjectPos);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(ExamSubjectInfo t) {
        int count = this.vaildSubject(t.getName(), t.getPositonVos(), t.getId());
        if (count > 0) {
            throw new BaseException(t.getName() + "\u5df2\u91cd\u590d");
        }
        int insert = ((ExamSubjectInfoDao)this.baseMapper).updateById((Object)t);
        if (insert > 0) {
            this.processPositionInfo(t);
            return true;
        }
        return false;
    }

    @Override
    public List<ExamSubjectPos> findByBindPos(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"subject_id_", (Object)id);
        return this.subjectPosDao.selectList((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createInfo(ExamSubjectInfo t) {
        int count = this.vaildSubject(t.getName(), t.getPositonVos(), null);
        if (count > 0) {
            throw new BaseException(t.getName() + "\u5df2\u91cd\u590d");
        }
        int insert = ((ExamSubjectInfoDao)this.baseMapper).insert((Object)t);
        if (insert > 0) {
            this.processPositionInfo(t);
            return true;
        }
        return false;
    }

    private int vaildSubject(String name, List<PositionVo> positonVos, String id) {
        HashSet majorIds = Sets.newHashSet();
        ArrayList positionIds = Lists.newArrayList();
        positonVos.forEach(positionVo -> {
            if (!StringUtils.isEmpty((Object)positionVo.getPositionId())) {
                positionIds.add(positionVo.getPositionId());
            }
        });
        ArrayList<String> strings = new ArrayList<String>(majorIds);
        return ((ExamSubjectInfoDao)this.baseMapper).getSubjectCount(name, positionIds, strings, id);
    }

    @Override
    public List<ExamSubjectPos> findBySubjectIds(SubjectReqVo t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"subject_id_", t.getSubjectIds());
        List subjectPosList = this.subjectPosDao.selectList((Wrapper)queryWrapper);
        return subjectPosList;
    }

    @Override
    public List<ExamSubjectInfo> findByMajorIds(SubjectReqVo t) {
        return ((ExamSubjectInfoDao)this.baseMapper).findByMajorIds(t);
    }

    @Override
    public ExamSubjectInfo findById(String id) {
        ExamSubjectInfo examSubjectInfo = (ExamSubjectInfo)((Object)((ExamSubjectInfoDao)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PositionVo> list = ((ExamSubjectInfoDao)this.baseMapper).getPositionInfo(id);
        examSubjectInfo.setPositonVos(list);
        return examSubjectInfo;
    }

    @Override
    public PageList<ExamSubjectInfo> findByPage(QueryFilter<ExamSubjectInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ExamSubjectInfo> result = ((ExamSubjectInfoDao)this.baseMapper).queryPage((IPage<ExamSubjectInfo>)this.convert2IPage(pageBean), (Wrapper<ExamSubjectInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List<String> subjectIds = result.getRecords().stream().map(ExamSubjectInfo::getId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(subjectIds)) {
            List<ExamEquipmentSys> list = ((ExamSubjectInfoDao)this.baseMapper).findBySubjectIds(subjectIds);
            HashMap map = Maps.newHashMap();
            list.forEach(examEquipmentSys -> {
                if (map.containsKey(examEquipmentSys.getSubjectId())) {
                    map.put(examEquipmentSys.getSubjectId(), (String)map.get(examEquipmentSys.getSubjectId()) + "," + examEquipmentSys.getName());
                } else {
                    map.put(examEquipmentSys.getSubjectId(), examEquipmentSys.getName());
                }
            });
            result.getRecords().forEach(subject -> {
                if (map.containsKey(subject.getId())) {
                    subject.setMajorName((String)map.get(subject.getId()));
                }
            });
        }
        return new PageList(result);
    }

    @Override
    public List<ExamSubjectInfo> getSubjectList(SubjectReqVo t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id_", t.getSubjectIds());
        return ((ExamSubjectInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<UserInfoVo> getSubjectUserList(SubjectReqVo t) {
        List<UserInfoVo> subjectUserList = ((ExamSubjectInfoDao)this.baseMapper).getSubjectUserList(t);
        HashMap userInfoVoMap = Maps.newHashMap();
        subjectUserList.forEach(userInfoVo -> userInfoVoMap.put(userInfoVo.getUserId(), userInfoVo));
        ArrayList list = Lists.newArrayList();
        userInfoVoMap.forEach((key, value) -> list.add(value));
        return list;
    }

    @Override
    public PageList<ExamSubjectInfo> notSubjectPage(QueryFilter<ExamSubjectInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ExamSubjectInfo> result = ((ExamSubjectInfoDao)this.baseMapper).notSubjectPage((IPage<ExamSubjectInfo>)this.convert2IPage(pageBean), (Wrapper<ExamSubjectInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()), queryFilter.getParams());
        return new PageList(result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<ExamSubjectInfo> list) {
        list.forEach(subject -> {
            subject.setTrainLevel(TrainLevelEnum.getType((String)subject.getTrainLevel()));
            subject.setTrainType(TrainTypeEnum.getType((String)subject.getTrainType()));
            if (!StringUtils.isEmpty((Object)subject.getUserTypeId())) {
                subject.setUserTypeId(((ExamSubjectInfoDao)this.baseMapper).getuserTypeId(subject.getUserTypeId()));
            }
            ((ExamSubjectInfoDao)this.baseMapper).insert(subject);
            String orgId = this.posSysDao.findByOrgName(subject.getOrgName());
            String positionId = null;
            if (!StringUtils.isEmpty((Object)subject.getPositonNames())) {
                positionId = ((ExamSubjectInfoDao)this.baseMapper).getPositionId(orgId, subject.getPositonNames());
            }
            ExamSubjectPos subjectPos = new ExamSubjectPos();
            subjectPos.setPositionId(positionId);
            subjectPos.setSubjectId(subject.getId());
            subjectPos.setOrgId(orgId);
            subjectPos.setFullId(orgId + "/" + positionId + "/" + subject.getId());
            this.subjectPosDao.insert((Object)subjectPos);
        });
        return true;
    }

    @Override
    public PageList<UserInfoVo> coachSubjectList(QueryFilter<ExamSubjectInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<UserInfoVo> result = ((ExamSubjectInfoDao)this.baseMapper).coachSubjectList((IPage<ExamSubjectInfo>)this.convert2IPage(pageBean), (Wrapper<ExamSubjectInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    private void processPositionInfo(ExamSubjectInfo t) {
        if (CollectionUtils.isEmpty(t.getPositonVos())) {
            return;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"subject_id_", (Object)t.getId());
        this.subjectPosDao.delete((Wrapper)queryWrapper);
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"subject_id_", (Object)t.getId());
        this.subjectSysDao.delete((Wrapper)query);
        HashSet majorIds = Sets.newHashSet();
        t.getPositonVos().forEach(positionVo -> {
            if (!StringUtils.isEmpty((Object)positionVo.getPositionId())) {
                ExamSubjectPos subjectPos = new ExamSubjectPos();
                subjectPos.setPositionId(positionVo.getPositionId());
                subjectPos.setSubjectId(t.getId());
                subjectPos.setOrgId(positionVo.getOrgId());
                subjectPos.setFullId(positionVo.getOrgId() + "/" + positionVo.getPositionId() + "/" + t.getId());
                this.subjectPosDao.insert((Object)subjectPos);
            }
        });
        if (CollectionUtils.isEmpty((Collection)majorIds)) {
            return;
        }
        ArrayList<String> strings = new ArrayList<String>(majorIds);
        strings.forEach(majorId -> {
            ExamSubjectSys subjectPos = new ExamSubjectSys();
            subjectPos.setSubjectId(t.getId());
            subjectPos.setMajorId((String)majorId);
            this.subjectSysDao.insert((Object)subjectPos);
        });
    }
}

