/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.enums.PaperStatusEnum;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.examine.manager.ExamQuestionsInfoManager;
import com.artfess.examine.manager.ExamUserRecordManager;
import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.vo.JobStatisticalVo;
import com.artfess.examine.vo.PaperAnalysisVo;
import com.artfess.examine.vo.PaperStatisticalVo;
import com.artfess.examine.vo.QuestionAnalysisVo;
import com.artfess.examine.vo.StatisticalReqVo;
import com.google.api.client.util.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7edf\u8ba1\u5206\u6790"})
@RequestMapping(value={"/exam/statistical"})
@ApiGroup(group={"group_biz"})
public class StatisticalController {
    private static final Logger log = LoggerFactory.getLogger(StatisticalController.class);
    @Autowired
    private ExamUserRecordManager userRecordManager;
    @Autowired
    private ExamQuestionsInfoManager questionsInfoManager;

    @PostMapping(value={"/paper"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8003\u8bd5\u7edf\u8ba1")
    public PageList<PaperStatisticalVo> trainingPaperQuery(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamPaperBase> queryFilter) {
        AtomicReference paperStatus = new AtomicReference();
        queryFilter.getQuerys().forEach(queryField -> {
            if ("paperStatus".equals(queryField.getProperty())) {
                paperStatus.set(queryField.getValue() + "");
            }
        });
        if (PaperStatusEnum.notRelease.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("s.plan_start_time_", (Object)LocalDateTime.now(), QueryOP.GREAT, FieldRelation.AND);
        } else if (PaperStatusEnum.inTets.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("s.plan_start_time_", (Object)LocalDateTime.now(), QueryOP.LESS, FieldRelation.AND);
            queryFilter.addFilter("s.plan_end_time_", (Object)LocalDateTime.now(), QueryOP.GREAT_EQUAL, FieldRelation.AND);
        } else if (PaperStatusEnum.finish.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("s.plan_end_time_", (Object)LocalDateTime.now(), QueryOP.LESS, FieldRelation.AND);
        }
        if (!StringUtils.isEmpty(paperStatus.get())) {
            queryFilter.getQuerys().removeIf(s -> "paperStatus".equals(s.getProperty()));
        }
        queryFilter.addFilter("b.type_", (Object)"1", QueryOP.EQUAL);
        ArrayList statusList = Lists.newArrayList();
        statusList.add("1");
        statusList.add("2");
        queryFilter.addFilter("s.status_", (Object)statusList, QueryOP.IN);
        queryFilter.addFilter("b.is_dele_", (Object)"0", QueryOP.EQUAL);
        return this.userRecordManager.paperStatistical(queryFilter);
    }

    @PostMapping(value={"/paperAnalysis"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bd5\u5377\u5206\u6790")
    public PaperAnalysisVo paperAnalysis() {
        return this.userRecordManager.paperAnalysis();
    }

    @PostMapping(value={"/questionAnalysis"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9898\u5e93\u5206\u6790")
    public QuestionAnalysisVo questionAnalysis(@ApiParam(name="reqVo", value="\u5165\u53c2") @RequestBody StatisticalReqVo reqVo) {
        return this.questionsInfoManager.questionAnalysis(reqVo);
    }

    @PostMapping(value={"/jobStatistical"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5de5\u4f5c\u53f0\u7edf\u8ba1")
    public JobStatisticalVo jobStatistical() {
        return this.userRecordManager.jobStatistical();
    }
}

