/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.controller;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.DictionaryUtils;
import com.artfess.base.util.DmpBeanUtil;
import com.artfess.data.manager.BizEquipmentBaseDataManager;
import com.artfess.data.manager.BizExamIndexDataManager;
import com.artfess.data.manager.BizExamPlanManager;
import com.artfess.data.manager.BizExamSpaceDataManager;
import com.artfess.data.manager.BizTrainEquipmentDataManager;
import com.artfess.data.model.BizExamPlan;
import com.artfess.data.vo.MonthPlanVo;
import com.artfess.data.vo.TrainReqVo;
import com.artfess.examine.manager.ExamEquipmentSysManager;
import com.artfess.poi.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bad\u7ec3\u7edf\u8ba1"})
@RequestMapping(value={"/exam/statistical"})
@ApiGroup(group={"group_biz"})
public class DataStatisticalController {
    private static final Logger log = LoggerFactory.getLogger(DataStatisticalController.class);
    @Autowired
    private BizExamPlanManager planManager;
    @Autowired
    private ExamEquipmentSysManager equipmentSysManager;
    @Autowired
    private BizExamSpaceDataManager spaceDataManager;
    @Autowired
    private BizExamIndexDataManager indexDataManager;
    @Autowired
    private BizTrainEquipmentDataManager trainEquipmentDataManager;
    @Autowired
    private BizEquipmentBaseDataManager equipmentBaseDataManager;

    @PostMapping(value={"/planStatistical"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e2a\u4eba\u8bad\u7ec3\u60c5\u51b5")
    public List<JSONObject> planStatistical() {
        return this.planManager.planStatistical();
    }

    @PostMapping(value={"/trainObject"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53ef\u89c6\u5316\u5206\u6790-\u8bad\u7ec3\u5bf9\u8c61\u6c47\u603b")
    public JSONObject summary() {
        return this.equipmentSysManager.summary();
    }

    @PostMapping(value={"/trainSafeguard"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53ef\u89c6\u5316\u5206\u6790-\u8bad\u7ec3\u4fdd\u969c\u6c47\u603b")
    public JSONObject trainSafeguard() {
        JSONObject jsonObject = new JSONObject(true);
        int spaceCount = this.spaceDataManager.count();
        jsonObject.put("spaceCount", (Object)spaceCount);
        int indexDateCount = this.indexDataManager.count();
        jsonObject.put("indexDateCount", (Object)indexDateCount);
        int trainEquipmentCount = this.trainEquipmentDataManager.count();
        jsonObject.put("trainEquipmentCount", (Object)trainEquipmentCount);
        int equipmentCount = this.equipmentBaseDataManager.count();
        jsonObject.put("equipmentCount", (Object)equipmentCount);
        return jsonObject;
    }

    @PostMapping(value={"/spacePancake"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53ef\u89c6\u5316\u5206\u6790-\u8bad\u7ec3\u573a\u5730\u997c\u72b6\u56fe")
    public List<JSONObject> spacePancake(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody TrainReqVo reqVo) {
        return this.spaceDataManager.spacePancake(reqVo);
    }

    @PostMapping(value={"/indexDataPancake"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53ef\u89c6\u5316\u5206\u6790-\u8bad\u7ec3\u6d88\u8017\u6307\u6807\u997c\u72b6\u56fe")
    public List<JSONObject> indexDataPancake(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody TrainReqVo reqVo) {
        return this.indexDataManager.indexDataPancake(reqVo);
    }

    @PostMapping(value={"/trainEquipmentPancake"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53ef\u89c6\u5316\u5206\u6790-\u8bad\u7ec3\u5668\u6750\u997c\u72b6\u56fe")
    public List<JSONObject> trainEquipmentPancake(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody TrainReqVo reqVo) {
        return this.trainEquipmentDataManager.trainEquipmentPancake(reqVo);
    }

    @PostMapping(value={"/equipmentBasePancake"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53ef\u89c6\u5316\u5206\u6790-\u88c5\u5907\u8d44\u6e90\u57fa\u7840\u997c\u72b6\u56fe")
    public List<JSONObject> equipmentBasePancake(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody TrainReqVo reqVo) {
        return this.equipmentBaseDataManager.equipmentBasePancake(reqVo);
    }

    @PostMapping(value={"/trainPlanStylolitic"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53ef\u89c6\u5316\u5206\u6790-\u8bad\u7ec3\u8ba1\u5212\u5b8c\u6210\u60c5\u51b5\u67f1\u72b6\u56fe")
    public List<JSONObject> trainPlanStylolitic(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody TrainReqVo reqVo) {
        return this.planManager.trainPlanStylolitic(reqVo);
    }

    @PostMapping(value={"/orgYearTrainPlan"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53ef\u89c6\u5316\u5206\u6790-\u5404\u5355\u4f4d\u5e74\u5ea6\u8bad\u7ec3\u8ba1\u5212\u5b8c\u6210\u60c5\u51b5\u67f1\u72b6\u56fe")
    public List<JSONObject> orgYearTrainPlan(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody TrainReqVo reqVo) {
        return this.planManager.orgYearTrainPlan(reqVo);
    }

    @PostMapping(value={"/monthPlanStatistical"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bad\u7ec3\u7edf\u8ba1")
    public PageList<BizExamPlan> monthPlanStatistical(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizExamPlan> queryFilter) {
        return this.planManager.monthPlanStatistical(queryFilter);
    }

    @ApiOperation(value="\u8bad\u7ec3\u7edf\u8ba1\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizExamPlan> queryFilter) throws Exception {
        PageList<BizExamPlan> page = this.planManager.monthPlanStatistical(queryFilter);
        queryFilter.addFilter("plan_type_", (Object)"3", QueryOP.EQUAL);
        page.getRows().forEach(data -> {
            String type;
            if (null != DictionaryUtils.findByDictValue((String)"xljb", (String)data.getTrainLevel())) {
                type = DictionaryUtils.findByDictValue((String)"xljb", (String)data.getTrainLevel()).getName();
                data.setTrainLevel(type);
            }
            if (null != DictionaryUtils.findByDictValue((String)"xllb", (String)data.getTrainType())) {
                String trainType = DictionaryUtils.findByDictValue((String)"xllb", (String)data.getTrainType()).getName();
                data.setTrainType(trainType);
            }
            if (null != DictionaryUtils.findByDictValue((String)"jdmc", (String)data.getQuarter())) {
                type = DictionaryUtils.findByDictValue((String)"jdmc", (String)data.getQuarter()).getName();
                data.setQuarter(type);
            }
            if (null != DictionaryUtils.findByDictValue((String)"xlfs", (String)data.getWay())) {
                String way = DictionaryUtils.findByDictValue((String)"xlfs", (String)data.getWay()).getName();
                data.setWay(way);
            }
        });
        ExcelUtils util = new ExcelUtils(MonthPlanVo.class);
        List list = DmpBeanUtil.copyList((List)page.getRows(), MonthPlanVo.class);
        util.exportExcel(response, request, list, "\u6708\u5ea6\u8bad\u7ec3\u7edf\u8ba1\u6570\u636e");
    }
}

