/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.examine.manager.ExamMaterialTypeManager;
import com.artfess.examine.model.ExamMaterialType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7840\u6570\u636e-\u8d44\u6599\u5206\u7c7b"})
@RequestMapping(value={"/exam/materialType/type/"})
@ApiGroup(group={"group_biz"})
public class ExamMaterialTypeController
extends BaseController<ExamMaterialTypeManager, ExamMaterialType> {
    private static final Logger log = LoggerFactory.getLogger(ExamMaterialTypeController.class);

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) ExamMaterialType t) {
        String id = ((ExamMaterialTypeManager)this.baseService).insertTree(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) ExamMaterialType t) {
        ExamMaterialType byId = (ExamMaterialType)((Object)((ExamMaterialTypeManager)this.baseService).getById((Serializable)((Object)t.getId())));
        String id = ((ExamMaterialTypeManager)this.baseService).updateTree(t, byId.getName());
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/getTree"})
    @ApiOperation(value="\u83b7\u53d6\u8d44\u6599\u5206\u7c7b\u4e0b\u62c9\u6811")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u8d44\u6599\u5206\u7c7b\u4e0b\u62c9\u6811")
    public CommonResult<String> getTree(@ApiParam(name="model", value="\u83b7\u53d6\u8d44\u6599\u5206\u7c7b\u4e0b\u62c9\u6811") @RequestBody ExamMaterialType entity) {
        log.info("\u83b7\u53d6\u8d44\u6599\u5206\u7c7b\u4e0b\u62c9\u6811\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        List<ExamMaterialType> list = ((ExamMaterialTypeManager)this.baseService).getTree(entity);
        return CommonResult.success(list, null);
    }
}

