package com.artfess.sysConfig.persistence.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 应用标签关系表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author zst
 * @since 2020-10-12
 */
@TableName("portal_app_tags_relation")
@ApiModel(value="AppTagsRelation对象", description="应用标签关系表")
public class AppTagsRelation extends BaseModel<AppTagsRelation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "应用ID")
    @TableField("APP_ID_")
    private String appId;

    @ApiModelProperty(value = "标签ID")
    @TableField("TAG_ID_")
    private String tagId;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }
    public String getTagId() {
        return tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "AppTagsRelation{" +
            "id=" + id +
            ", appId=" + appId +
            ", tagId=" + tagId +
            ", tenantId=" + tenantId +
        "}";
    }
}
