package com.artfess.mongodb.repository;

import com.artfess.mongodb.page.BasePage;
import com.artfess.mongodb.page.Page;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhx
 * @create 2021/7/31
 */
public interface MongoDbRepository<T, ID extends Serializable> extends MongoRepository<T,ID> {



    /**
     * 根据id修改
     * @param id 更新主键
     * @param updateFieldMap  key:需要更新的属性  value:对应的属性值
     */
    void update(ID id, Map<String, Object> updateFieldMap);

    /**
     * 根据传入值修改
     * @param queryFieldMap  key:查询条件的属性  value:对应的属性值
     * @param updateFieldMap  key:需要更新的属性  value:对应的属性值
     */
    void update(Map<String, Object> queryFieldMap, Map<String, Object> updateFieldMap);

    /**
     * 通过条件查询实体(集合)
     *
     * @param map
     */
    public List<T> find(HashMap<String, Object> map) ;

    /**
     * 通过条件查询,查询分页结果
     * @param page
     * @param map
     * @return
     */
    public Page<T> findPage(Page<T> page, HashMap<String, Object> map);

    public BasePage<T> findBasePage(BasePage<T> page);


    /**
     * 求数据总和
     * @param map
     * @return
     */
    public long count(HashMap<String, Object> map);

;

    /**
     * 通过ID获取记录,并且指定了集合名(表的意思)
     * @param id
     * @param collectionName
     * @return
     */

    public T findByIdCollectionName(String id, String collectionName);

    public void updateById(String id, T t);
}
