package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.persistence.dao.BpmWatermarkTypeDao;
import com.artfess.bpm.persistence.manager.BpmWatermarkTypeManager;
import com.artfess.bpm.persistence.model.BpmWatermarkType;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 
 * <pre> 
 * 描述：水印分配分类 处理实现类
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-09-08 10:29:51
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@Service("bpmWatermarkTypeManager")
public class BpmWatermarkTypeManagerImpl extends BaseManagerImpl<BpmWatermarkTypeDao, BpmWatermarkType> implements BpmWatermarkTypeManager{

    @Override
    public void batchAdd(List<BpmWatermarkType> watermarkTypes, int isAllSave) {
        if (isAllSave==0){
            List<BpmWatermarkType> types = watermarkTypes.stream().filter(item -> {
                BpmWatermarkType type = isExist(item.getTypeId());
                if (BeanUtils.isNotEmpty(type)){
                    return false;
                }else{
                    return true;
                }
            }).collect(Collectors.toList());
            saveBatch(types);
        }else{
            for (BpmWatermarkType item : watermarkTypes) {
                BpmWatermarkType type = isExist(item.getTypeId());
                if (BeanUtils.isNotEmpty(type)){
                    type.setWatermarkId(item.getWatermarkId());
                    update(type);
                }else{
                    create(item);
                }
            }
        }
    }

    @Override
    public CommonResult<String> isExist(List<BpmWatermarkType> watermarkTypes) {
        List<String> existList = new ArrayList<>();
        List<String> existHereList = new ArrayList<>();
        for (BpmWatermarkType item: watermarkTypes){
            BpmWatermarkType type = isExist(item.getTypeId());
            if(BeanUtils.isNotEmpty(type)) {
                if (!item.getWatermarkId().equals(type.getWatermarkId())){
                    existList.add(item.getTypeName());
                }else {
                    existHereList.add(item.getTypeName());
                }
            }
        }
        if (existHereList.size()==watermarkTypes.size()){ //设置的分类与存在此水印下的分类数量相同时证明已分配过
            return new CommonResult<>(false, "此分类已分配");
        } else if (existList.size()>0){ //其他地方已存在
            return new CommonResult<>(true,"["+String.join(",",existList)+"]已设置");
        } else {
            return new CommonResult<>(true,"设置成功");
        }
    }

    private BpmWatermarkType isExist(String typeId){
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq("type_id_",typeId);
        BpmWatermarkType type = baseMapper.selectOne(wrapper);
        return type;
    }
}
