package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.persistence.dao.BpmWatermarkDao;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmWatermarkManager;
import com.artfess.bpm.persistence.manager.BpmWatermarkProcessManager;
import com.artfess.bpm.persistence.manager.BpmWatermarkTypeManager;
import com.artfess.bpm.persistence.model.BpmWatermark;
import com.artfess.bpm.persistence.model.BpmWatermarkProcess;
import com.artfess.bpm.persistence.model.BpmWatermarkType;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * <pre>
 * 描述：流程水印 处理实现类
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-09-02 16:54:36
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@Service("bpmWatermarkManager")
public class BpmWatermarkManagerImpl extends BaseManagerImpl<BpmWatermarkDao, BpmWatermark> implements BpmWatermarkManager{

    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmWatermarkProcessManager bpmWatermarkProcessManager;
    @Resource
    BpmWatermarkTypeManager bpmWatermarkTypeManager;

    @Override
    public BpmWatermark getByInstId(String instId) {
        DefaultBpmProcessInstance instance =  bpmProcessInstanceManager.getNowAndHistory(instId);
        if (BeanUtils.isEmpty(instance))
            throw new RuntimeException("不存在此实例");

        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq("proc_def_key_", instance.getProcDefKey());
        BpmWatermarkProcess bpmWatermarkProcess = bpmWatermarkProcessManager.getOne(wrapper);
        if (bpmWatermarkProcess != null){
            BpmWatermark procBpmWatermark = baseMapper.selectById(bpmWatermarkProcess.getWatermarkId());
            if (procBpmWatermark != null){
                return procBpmWatermark;
            }
        }

        BpmWatermark typeBpmWatermark = baseMapper.getByTypeId(instance.getTypeId());
        return typeBpmWatermark;
    }

    @Transactional
    @Override
    public void batchRemove(String... ids) {
        removeByIds(ids);
        List<String> procIds = new ArrayList<>();
        List<String> typeIds = new ArrayList<>();
        for (String watermarkId: ids) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq("watermark_id_", watermarkId);
            List<BpmWatermarkProcess> bpmWatermarkProcesses = bpmWatermarkProcessManager.list(wrapper);
            for (BpmWatermarkProcess bpmWatermarkProcess : bpmWatermarkProcesses){
                if (bpmWatermarkProcess != null && BeanUtils.isNotEmpty(bpmWatermarkProcess.getId())){
                    procIds.add(bpmWatermarkProcess.getId());
                }
            }
            List<BpmWatermarkType> bpmWatermarkTypes = bpmWatermarkTypeManager.list(wrapper);
            for (BpmWatermarkType bpmWatermarkType : bpmWatermarkTypes){
                if (bpmWatermarkType != null && BeanUtils.isNotEmpty(bpmWatermarkType.getId())){
                    typeIds.add(bpmWatermarkType.getId());
                }
            }
        }
        bpmWatermarkProcessManager.removeByIds(procIds);
        bpmWatermarkTypeManager.removeByIds(typeIds);
    }
}
