package com.artfess.bpm.persistence.dao;

import com.artfess.bpm.persistence.model.BpmCommuReceiver;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;


public interface BpmCommuReceiverDao extends BaseMapper<BpmCommuReceiver> {
	
	/**
	 * 根据commuId和接收人ID取得接收人对象。 
	 * @param commuId
	 * @param receiverId
	 * @return 
	 * BpmCommuReceiver
	 */
	BpmCommuReceiver getByCommuUser(@Param("commuId") String commuId,@Param("receiverId") String receiverId);

    /**
     * 根据commuId取得接收人对象。
     * @param commuId
     * @param receiverId
     * @return
     * BpmCommuReceiver
     */
    BpmCommuReceiver getByCommuId(@Param("commuId") String commuId);
	/**
	 * 通过通知，状态获取所有的接收人消息
	 * @param commuId
	 * @param status
	 * @return
	 */
	List<BpmCommuReceiver> getByCommuStatus(@Param("commuId") String commuId,@Param("status") String status);
	
	Integer checkHasCommued(@Param("commuId")String commuId,@Param("receiverId") String receiverId);
}
