package com.artfess.bpm.factory;

import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.engine.BpmxEngine;
import com.artfess.bpm.api.engine.BpmxEngineFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.annotation.Resource;
import java.util.List;


//@Service
public class DefaultBpmxEngineFactory implements BpmxEngineFactory {

	@Resource
	private List<BpmxEngine> bpmxEngines;

	private String defaultEngineName="x5";

	private static final Log logger = LogFactory.getLog(DefaultBpmxEngineFactory.class);

	@Override
	public BpmxEngine getEngine() {
		return this.getEngine(defaultEngineName);
	}

	@Override
	public BpmxEngine getEngine(String engineName) {
		logger.debug("获取BPMX引擎，名称为：" + engineName);

		if (BeanUtils.isNotEmpty(bpmxEngines)) {
			for (BpmxEngine bpmxEngine : this.bpmxEngines) {
				logger.debug("找到引擎：" + bpmxEngine.getName());
				if (bpmxEngine.getName().equals(engineName)) {
					return bpmxEngine;
				}
			}
		}

		logger.warn("无法找到名称为：" + engineName + "的引擎。");

		return null;
	}

	public void setDefaultEngineName(String defaultEngineName) {
		this.defaultEngineName = defaultEngineName;
	}

	public void setBpmxEngines(List<BpmxEngine> bpmxEngines) {
		this.bpmxEngines = bpmxEngines;
	}



}
