package com.artfess.dataAccess.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.dataAccess.dao.DataAccessControlDao;
import com.artfess.dataAccess.dao.DataAccessDefinedDao;
import com.artfess.dataAccess.manager.DataAccessControlManager;
import com.artfess.dataAccess.manager.DataAccessDefinedManager;
import com.artfess.dataAccess.model.DataAccessControl;
import com.artfess.dataAccess.model.DataAccessDefined;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.dao.RoleDao;
import com.artfess.uc.model.Role;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 数据权限定义 服务实现类
 *
 * @author llj
 * @since 2021-04-01
 */
@Service
public class DataAccessDefinedManagerImpl extends BaseManagerImpl<DataAccessDefinedDao, DataAccessDefined> implements DataAccessDefinedManager {
    @Resource
    private DataAccessDefinedDao dao;
    @Resource
    private DataAccessControlDao dataAccessControlDao;
    @Resource
    private DataAccessControlManager manager;
    @Resource
    private RoleDao roleDao;

    @Override
    public List<DataAccessDefined> queryListDataAccessDefined(String interfaceId) {
        Assert.hasText(interfaceId, "接口id不能为空");
        QueryWrapper<DataAccessDefined> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("INTERFACE_ID_", interfaceId);
        List<DataAccessDefined> list = this.dao.selectList(queryWrapper);

        for (com.artfess.dataAccess.model.DataAccessDefined DataAccessDefined : list) {
            String accessRangeId = DataAccessDefined.getAccessRangeId();
            //返回权限范围name
            List<String> rangNameList = new ArrayList<>();
            if (DataAccessDefined.getAccessRangeType() == 5) {
                String[] split = accessRangeId.split(",");
                rangNameList = dao.queryRangNameByOrg(Arrays.asList(split));
            } else if (DataAccessDefined.getAccessRangeType() == 6) {
                String[] split = accessRangeId.split(",");
                rangNameList = dao.queryRangNameByUser(Arrays.asList(split));
            }
            String strip = StringUtils.strip(rangNameList.toString(), "[]");
            DataAccessDefined.setRangeNameList(strip);

            List<DataAccessControl> listControl = manager.queryListDataAccessDefined(DataAccessDefined.getId());
            if (listControl.size() > 0) {
                if (listControl.get(0).getAccessControlType() == 1) {
                    DataAccessDefined.setType("所有人");
                } else {
                    DataAccessDefined.setType("其他");
                }
            } else {
                DataAccessDefined.setType("");
            }
        }
        return list;
    }

    @Override
    @Transactional
    public String saveDataAccessDefined(DataAccessDefined DataAccessDefined) {
        Assert.notNull(DataAccessDefined, "权限定义不能为空！");
        String msg = "";
        if (StringUtils.isNotBlank(DataAccessDefined.getId())) { // 更新
            if (DataAccessDefined.getAccessRangeType() != 5 && DataAccessDefined.getAccessRangeType() != 6) {
                //清空授权范围id
//                DataAccessDefined.setAccessRangeId(null);
            }
            this.update(DataAccessDefined);
            msg = "更新成功";
        } else { // 新增
            this.create(DataAccessDefined);
            msg = "新增成功";
        }
        return msg;
    }

    @Override
    @Transactional
    public void deleteDataAccessDefinedByIds(List<String> ids) {
        Assert.notEmpty(ids, "参数ids不能为空！");
        //删除对应的所有授权用户
        for (int i = 0; i < ids.size(); i++) {
            dataAccessControlDao.deleteByAccessDefinedId(ids.get(i));
        }
        baseMapper.deleteBatchIds(ids);
    }

    @Override
    public DataAccessDefined loadDataAccessDefined(String id) {
        Assert.hasText(id, "权限id不能为空");
        DataAccessDefined DataAccessDefined = baseMapper.selectById(id);
        String accessRangeId = DataAccessDefined.getAccessRangeId();
        //返回权限范围name
        List<String> rangNameList = new ArrayList<>();
        if (DataAccessDefined.getAccessRangeType() == 5) {
            String[] split = accessRangeId.split(",");
            rangNameList = dao.queryRangNameByOrg(Arrays.asList(split));
        } else if (DataAccessDefined.getAccessRangeType() == 6) {
            String[] split = accessRangeId.split(",");

            rangNameList = dao.queryRangNameByUser(Arrays.asList(split));
        }
        String strip = StringUtils.strip(rangNameList.toString(), "[]");
        DataAccessDefined.setRangeNameList(strip);
        List<DataAccessControl> list = manager.queryListDataAccessDefined(DataAccessDefined.getId());
        if (list.size() > 0) {
            if (list.get(0).getAccessControlType() == 1) {
                DataAccessDefined.setType("所有人");
            } else {
                DataAccessDefined.setType("其他");
            }
        } else {
            DataAccessDefined.setType("");
        }
        return DataAccessDefined;
    }

    @Override
    public List<Map<String, Object>> getDataAccessDefinedList(String alias) {
        IUser currentUser = ContextUtil.getCurrentUser();

        Set<String> currentUserRolesAlias = AuthenticationUtil.getCurrentUserRolesAlias();
        QueryWrapper<Role> roleQueryWrapper = new QueryWrapper<>();
        roleQueryWrapper.in("CODE_", currentUserRolesAlias);
        List<Role> roles = roleDao.selectList(roleQueryWrapper);
        String roleids = "";
        for (int i = 0; i < roles.size(); i++) {
            if (i < roles.size() - 1) {
                roleids = roleids + roles.get(i).getId() + ",";
            } else {
                roleids = roleids + roles.get(i).getId();
            }

        }
        HashMap<String, Object> map = new HashMap<>();
        map.put("alias", alias);
        map.put("userId", currentUser.getUserId());
        map.put("userName", currentUser.getAccount());
        String currentUserOrgIds = AuthenticationUtil.getCurrentUserOrgIds();
        if (StringUtils.isNotBlank(currentUserOrgIds)) {
            List<String> orgList = Arrays.asList(currentUserOrgIds.split(","));
            map.put("orgIds", orgList);
        } else {
            List<Object> list = new ArrayList<>();
            list.add("-1");
            map.put("orgIds", list);
        }
        if (StringUtils.isNotBlank(roleids)) {

            List<String> roleidsList = Arrays.asList(roleids.split(","));
            map.put("roleIds", roleidsList);
        } else {
            List<Object> list = new ArrayList<>();
            list.add("-1");
            map.put("roleIds", list);
        }
        List<Map<String, Object>> maps = dao.selectAccessDefinedList(map);
        return maps;
    }
}
