package com.artfess.file.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * 分片上传初始化
 */
@Data
@ApiModel(value = "分片上传初始化",description = "分片上传初始化")
public class MultipartInitParam {
    @ApiModelProperty("文件名")
    @NotEmpty(message = "文件名不能为空")
    private String filename;
    @ApiModelProperty("文件MIME类型")
    private String contentType;
    @ApiModelProperty("文件大小（单位：字节Byte）,按照10兆分割")
    @NotNull(message = "文件大小不能为空")
    private Long size;
    @ApiModelProperty("md5")
    private String md5;

    @ApiModelProperty("存储类型(folder:基于磁盘  database:基于数据库 ftp:FTP服务器 aliyunOss:阿里云OSS minio：minio)")
    protected String storeType="folder";

    /**
     * 分片大小  B
     */
    private Long partSize;
    @ApiModelProperty(name = "分片数量", hidden = true)
    private Long zoneTotal;
}
