package com.artfess.base.sqlbuilder;

import com.artfess.base.query.QueryOP;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;

import java.text.ParseException;

/**
 * <pre>
 * 构建组：x5-base-db
 * 作者：lyj
 * 邮箱:liyj@jee-soft.cn
 * 日期:2014-7-16-下午5:05:36
 * 版权：广州宏天软件有限公司版权所有
 * </pre>
 */
public class OracleSqlBuilder extends AbstractSqlBuilder {

	public OracleSqlBuilder() {
		super();
	}

	@Override
	// TODO 日期格式已写死- -
	public void handleDbTypeEqualDate(StringBuffer sql, String field, QueryOP op, Object value, String format) {
		if (op == QueryOP.BETWEEN) {
			ObjectNode value1 = (ObjectNode) value;
			String start = JsonUtil.getString( value1,"start","");
			String end = JsonUtil.getString(value1, "end", "");
			if(StringUtil.isEmpty(format)){
				format="yyyy-mm-dd hh24:mi:ss";
			}
			String newStart=start;
			String newEnd=end;
			try {
				newStart= DateFormatUtil.format(DateFormatUtil.parseDate(start,format).getTime(),format);
				newEnd=DateFormatUtil.format(DateFormatUtil.parseDate(newEnd,format).getTime(),format);
			} catch (ParseException e) {
				newStart=start;
				newEnd=newEnd;
			}
			if (StringUtil.isNotEmpty(newStart)) {
				sql.append(" and " + field + " " + ">=" + " to_date('" + newStart + "','"+format+"')");
			}
			if (StringUtil.isNotEmpty(newEnd)) {
				sql.append(" and " + field + " " + "<=" + " to_date('" + newEnd + "','"+format+"')");
			}
		} else {
			if(StringUtil.isEmpty(format)){
				format="yyyy-mm-dd hh24:mi:ss";
			}
			Object newValue=value;
			try {
				newValue=DateFormatUtil.format(DateFormatUtil.parseDate(value.toString(),format).getTime(),format);
			} catch (ParseException e) {
				newValue=value;
			}
			sql.append(" and " + field + " " + op.op() + " to_date('" + newValue.toString() + "','"+format+"')");
		}
	}



}
