package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 试卷类型
 */
@Getter
public enum PaperTypeEnum {
    /**
     * 单选
     */
    formal("1", "正式考试"),

    simulation("2", "模拟考试"),

    ;

    PaperTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        PaperTypeEnum[] values = values();
        for (PaperTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
