package com.artfess.base.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Package com.scaffold.util.Enum
 * date 2020/3/6 14:27
 * author 陈实
 * Description:
 */
public enum OperationType {
    LIST("LIST", "进入页面"),

    DETALL("DETALL", "查询明细"),

    ADD("ADD", "添加"),

    UPDATE("UPDATE", "修改"),

    DELETE("DELETE", "删除"),

    MOVE("MOVE", "移动"),

    QUERY("QUERY", "查询"),

    SYN("SYN", "同步"),

    SAVE("SAVE", "保存"),

    UPLOAD("UPLOAD", "上传"),

    DOWNLOAD("DOWNLOAD", "下载"),

    EXPORT("EXPORT", "导出"),

    VIEW("VIEW", "查看"),

    IMPORT("IMPORT","导入");

    private String id;
    private String name;

    private OperationType(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static OperationType fromId(String id) {
        String str = id;
        int i = -1;
        switch (str.hashCode()) {
            case 2336926:
                if (str.equals("LIST"))
                    i = 0;
                break;
            case 2013072558:
                if (str.equals("DETALL"))
                    i = 1;
                break;
            case 64641:
                if (str.equals("ADD"))
                    i = 2;
                break;
            case -1785516855:
                if (str.equals("UPDATE"))
                    i = 3;
                break;
            case 2012838315:
                if (str.equals("DELETE"))
                    i = 4;
                break;
            case 2372561:
                if (str.equals("MOVE"))
                    i = 5;
                break;
            case 77406376:
                if (str.equals("QUERY"))
                    i = 6;
                break;
            case 82600:
                if (str.equals("SYN"))
                    i = 7;
                break;
            case 2537853:
                if (str.equals("SAVE"))
                    i = 8;
                break;
            case -1785265663:
                if (str.equals("UPLOAD"))
                    i = 9;
                break;
            case -2084521848:
                if (str.equals("DOWNLOAD"))
                    i = 10;
                break;
            case 2634405:
                if (str.equals("VIEW"))
                    i = 11;
        }
        switch (i) {
            case 0:
                return LIST;
            case 1:
                return DETALL;
            case 2:
                return ADD;
            case 3:
                return UPDATE;
            case 4:
                return DELETE;
            case 5:
                return MOVE;
            case 6:
                return QUERY;
            case 7:
                return SYN;
            case 8:
                return SAVE;
            case 9:
                return UPLOAD;
            case 10:
                return DOWNLOAD;
            case 11:
                return VIEW;
        }
        throw new RuntimeException(String.format("无效操作类型类型“%s”。",
                new Object[] { String.valueOf(id) }));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static Map<String, String> getData() {
        Map<String, String> map = new HashMap<String, String>(values().length);
        for (OperationType c : values()) {
            map.put(String.valueOf(c.getId()), c.getName());
        }
        return map;
    }
}
