package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 受控对象枚举类型
 */
@Getter
public enum AccessControlTypeEnum {
    /**
     * 启用
     */
    ALL("1", "所有人"),

    ORG("2", "组织"),

    USER("3", "用户"),
    ;

    AccessControlTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        AccessControlTypeEnum[] values = values();
        for (AccessControlTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
