package com.artfess.examine.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * 年度考核考生(体育成绩课目)明细记录表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2024-12-31
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value="ExamUserEvaluationDetailTy对象", description="年度考核考生(体育成绩课目)明细记录表")
public class ExamUserEvaluationDetailTy extends AutoFillModel<ExamUserEvaluationDetailTy> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "年份")
    @TableField("year_")
    private String year;

    @ApiModelProperty(value = "岗位id")
    @TableField("position_id_")
    private String positionId;

    @ApiModelProperty(value = "考生ID")
    @TableField("user_id_")
    private String userId;

    @ApiModelProperty(value = "考生姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "考试记录ID (外键,允许为NULL)")
    @TableField("record_id_")
    private String recordId;

    @ApiModelProperty(value = "考评课目名称")
    @TableField("ti_yu_kao_ping_ke_mu_ming_cheng")
    private String tiYuKaoPingKeMuMingCheng;

    @ApiModelProperty(value = "考评课目成绩分数")
    @TableField("ti_yu_kao_ping_ke_mu_cheng_ji")
    private String tiYuKaoPingKeMuChengJi;

    @ApiModelProperty(value = "评价等级")
    @TableField("level_")
    private String level;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("data_time_")
    private LocalDateTime dataTime;

    @ApiModelProperty(value = "成绩类型，1-专业共同 2-专业XX 3-XX共同 4-XX体育")
    @TableField("type_")
    private Integer type;
}
