package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 考生考试申请
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@ApiModel(value="ExamPaperApply对象", description="考生考试申请")
public class ExamPaperApply extends BaseModel<ExamPaperApply> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试卷基础信息ID")
    @TableField("paper_base_id_")
    private String paperBaseId;

    @ApiModelProperty(value = "考生ID")
    @TableField("user_id_")
    private String userId;

    @ApiModelProperty(value = "申请时间")
    @TableField("apply_time_")
    private LocalDateTime applyTime;

    @ApiModelProperty(value = "申请理由")
    @TableField("reasons")
    private String reasons;

    @ApiModelProperty(value = "申请结果【字典】(0、拒绝申请 1、同意申请  )")
    @TableField("result_status_")
    private String resultStatus;

    @ApiModelProperty(value = "处理人")
    @TableField("process_user_id_")
    private String processUserId;

    @ApiModelProperty(value = "处理时间")
    @TableField("process_time_")
    private LocalDateTime processTime;

    @ApiModelProperty(value = "是否正确【字典】（0：否，1：是）")
    @TableField("note_")
    private String note;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPaperBaseId() {
        return paperBaseId;
    }

    public void setPaperBaseId(String paperBaseId) {
        this.paperBaseId = paperBaseId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public LocalDateTime getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(LocalDateTime applyTime) {
        this.applyTime = applyTime;
    }

    public String getReasons() {
        return reasons;
    }

    public void setReasons(String reasons) {
        this.reasons = reasons;
    }

    public String getResultStatus() {
        return resultStatus;
    }

    public void setResultStatus(String resultStatus) {
        this.resultStatus = resultStatus;
    }

    public String getProcessUserId() {
        return processUserId;
    }

    public void setProcessUserId(String processUserId) {
        this.processUserId = processUserId;
    }

    public LocalDateTime getProcessTime() {
        return processTime;
    }

    public void setProcessTime(LocalDateTime processTime) {
        this.processTime = processTime;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ExamPaperApply{" +
            "id=" + id +
            ", paperBaseId=" + paperBaseId +
            ", userId=" + userId +
            ", applyTime=" + applyTime +
            ", reasons=" + reasons +
            ", resultStatus=" + resultStatus +
            ", processUserId=" + processUserId +
            ", processTime=" + processTime +
            ", note=" + note +
        "}";
    }
}
