package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.examine.vo.ExamMaterialVo;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 资料信息表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@ApiModel(value="ExamMaterialInfo对象", description="资料信息表")
public class ExamMaterialInfo extends BaseModel<ExamMaterialInfo> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择资料分类",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "资料分类_ID")
    @TableField("type_id_")
    private String typeId;

    @NotBlank(message = "请输入资料名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "资料名称")
    @TableField("title_")
    private String title;

    @ApiModelProperty(value = "关键词")
    @TableField("keyword_")
    private String keyword;

    @ApiModelProperty(value = "摘要简介")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "资料文件")
    @TableField(exist = false)
    private List<ExamFile> examFiles;

    @ApiModelProperty(value = "资料分类名称")
    @TableField(exist = false)
    private String typeName;

    @ApiModelProperty(value = "授权信息")
    @TableField(exist = false)
    private ExamMaterialVo examMaterialVo;

}
