package com.artfess.data.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * xxx成绩与奖惩表（按年成绩明细记录表）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2024-12-27
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value="BizUserGrade对象", description="xxx成绩与奖惩表（按年成绩明细记录表）")
public class BizUserGrade extends AutoFillModel<BizUserGrade> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id_")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "人员档案id（外键）")
    @TableField("user_archive_id_")
    private String userArchiveId;

    @ApiModelProperty(value = "人员姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "身份证号")
    @TableField("identi_card_")
    private String identiCard;

    @ApiModelProperty(value = "填档年份（格式：2024）")
    @TableField("td_year_")
    private Integer tdYear;

    @ApiModelProperty(value = "历年xxx成绩评定描述")
    @TableField("grade_content_")
    private String gradeContent;

    @ApiModelProperty(value = "历年xxx奖惩描述")
    @TableField("rewards_content_")
    private String rewardsContent;

    @ApiModelProperty(value = "排序号")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "创建人")
    @TableField("create_by_")
    private String createBy;

}
