package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 训练消耗指标数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@ApiModel(value="BizExamIndexData对象", description="训练消耗指标数据")
public class BizExamIndexData extends AutoFillModel<BizExamIndexData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请选择所属单位", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "所属单位id")
    @TableField("org_id_")
    private String orgId;

    @Excel(name = "所属单位", column = "A")
    @ApiModelProperty(value = "所属单位")
    @TableField("org_name")
    private String orgName;

    @Excel(name = "仓库位置", column = "B")
    @ApiModelProperty(value = "仓库位置")
    @TableField("warehouse_location_")
    private String warehouseLocation;

    @Excel(name = "指标名称", column = "C")
    @ApiModelProperty(value = "指标名称")
    @TableField("name_")
    private String name;

    @Excel(name = "指标类型", column = "D")
    @ApiModelProperty(value = "指标类型【字典】（1：弹药、2：油料、3：摩托小时）")
    @TableField("type_")
    private String type;

    @Excel(name = "数量", column = "E")
    @ApiModelProperty(value = "数量")
    @TableField("number_")
    private BigDecimal number;

    @Excel(name = "计量单位", column = "F")
    @ApiModelProperty(value = "计量单位【字典】")
    @TableField("unit_")
    private String unit;

    @Excel(name = "备注", column = "G")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;
}
